/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.monitor.model;

import ilog.rules.monitor.model.IlrCodeLocation;
import java.util.Iterator;
import java.util.LinkedHashMap;

public final class IlrClassDescription
implements Iterable<IlrCodeLocation> {
    private String className;
    private LinkedHashMap<IlrCodeLocation, IlrCodeLocation> codeLocations;

    IlrClassDescription(String className) {
        this.className = className;
        this.codeLocations = new LinkedHashMap();
    }

    public String getClassName() {
        return this.className;
    }

    @Override
    public Iterator<IlrCodeLocation> iterator() {
        return this.codeLocations.values().iterator();
    }

    public int numbersOfCodeLocation() {
        return this.codeLocations.size();
    }

    IlrCodeLocation getCodeLocation(String name, int line, Thread.State threadState, boolean isNative) {
        IlrCodeLocation codeLoc = new IlrCodeLocation(name, line, threadState, isNative);
        IlrCodeLocation codeLocation = this.codeLocations.get(codeLoc);
        if (codeLocation == null) {
            this.codeLocations.put(codeLoc, codeLoc);
            return codeLoc;
        }
        return codeLocation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IlrClassDescription that = (IlrClassDescription)o;
        return this.className.equals(that.className);
    }

    public int hashCode() {
        return this.className.hashCode();
    }
}

