/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.monitor.model;

import ilog.rules.monitor.model.IlrClassDescription;
import ilog.rules.monitor.model.IlrClassDescriptionSet;
import ilog.rules.monitor.model.IlrCodeLocation;
import ilog.rules.monitor.model.IlrExecutionPoint;
import ilog.rules.monitor.model.IlrExecutionPointHistory;
import ilog.rules.monitor.model.IlrThread;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;

public final class IlrClassDescriptionSetImpl
implements IlrClassDescriptionSet {
    private LinkedHashMap<String, IlrClassDescription> classDescriptions = new LinkedHashMap();
    private volatile long numberOfThreads;
    private volatile int maxDepth;
    private ArrayList<Long> snapshots = new ArrayList();
    private volatile Date firstSnapshot = null;
    private volatile Date lastSnapshot = null;

    public IlrClassDescription makeClassDescription(String name) {
        IlrClassDescription classDescription = this.classDescriptions.get(name);
        if (classDescription == null) {
            classDescription = new IlrClassDescription(name);
            this.classDescriptions.put(name, classDescription);
        }
        return classDescription;
    }

    @Override
    public IlrClassDescription getClassDescription(String name) {
        return this.classDescriptions.get(name);
    }

    @Override
    public Iterator<IlrClassDescription> iterator() {
        return Collections.unmodifiableCollection(this.classDescriptions.values()).iterator();
    }

    @Override
    public Iterator<String> getClassNames() {
        return Collections.unmodifiableSet(this.classDescriptions.keySet()).iterator();
    }

    @Override
    public Iterator<IlrClassDescription> getClassDescriptionsOfPackage(String name) {
        LinkedList<IlrClassDescription> list = new LinkedList<IlrClassDescription>();
        for (String className : this.classDescriptions.keySet()) {
            String packageName = className.substring(0, className.lastIndexOf(46));
            if (!packageName.equals(name)) continue;
            list.add(this.classDescriptions.get(className));
        }
        return list.iterator();
    }

    @Override
    public int size() {
        return this.classDescriptions.size();
    }

    @Override
    public Date getLastSnapshot() {
        return this.lastSnapshot;
    }

    @Override
    public Date getFirstSnapshot() {
        return this.firstSnapshot;
    }

    @Override
    public long getTotalStartedThreadCount() {
        return this.numberOfThreads;
    }

    public void setTotalStartedThreadCount(long value) {
        this.numberOfThreads = value;
    }

    @Override
    public int getMaxStacktraceDepth() {
        return this.maxDepth;
    }

    public void setMaxStacktraceDepth(int newValue) {
        if (newValue > this.maxDepth) {
            this.maxDepth = newValue;
        }
    }

    @Override
    public int getNumberOfSnapshots() {
        return this.snapshots.size();
    }

    public void incrNumberOfSnapshots(long currentTime) {
        this.lastSnapshot = this.firstSnapshot == null ? (this.firstSnapshot = GregorianCalendar.getInstance().getTime()) : GregorianCalendar.getInstance().getTime();
        this.snapshots.add(currentTime);
    }

    @Override
    public int getSnapshotNumber(long value) {
        return Collections.binarySearch(this.snapshots, value);
    }

    public static IlrExecutionPoint addExecutionPoint(IlrExecutionPointHistory execPointHistory, IlrThread blocked, IlrThread owner, long date, String lockName) {
        IlrExecutionPoint executionPoint = execPointHistory.addExecutionPoint(blocked, owner, date, lockName);
        if (executionPoint != null) {
            return executionPoint;
        }
        throw new IllegalStateException("Execution Point already present " + date + " " + blocked);
    }

    public static void enlistBlockedStackElement(IlrExecutionPoint execPoint, String fullyQualifiedMethodName, int line, boolean isNative) {
        execPoint.enlistStackElement(fullyQualifiedMethodName, line, isNative);
    }

    public static void enlistOwnerStackElement(IlrExecutionPoint execPoint, String fullyQualifiedMethodName, int line, boolean isNative) {
        execPoint.enlistOwnerStackElement(fullyQualifiedMethodName, line, isNative);
    }

    public static IlrThread getThread(String name, long id) {
        return IlrThread.getThread(name, id);
    }

    public static IlrCodeLocation getCodeLocation(IlrClassDescription classDesc, String name, int line, Thread.State threadState, boolean isNative) {
        return classDesc.getCodeLocation(name, line, threadState, isNative);
    }

    public static void setMeasureCount(IlrThread thread, long waitedCount, long blockedCount) {
        thread.setWaitedCount(waitedCount);
        thread.setBlockedCount(blockedCount);
    }

    public static void setMeasureTime(IlrThread thread, long waitedTime, long blockedTime) {
        thread.setWaitedTime(waitedTime);
        thread.setBlockedTime(blockedTime);
    }
}

