/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.monitor.model;

import ilog.rules.monitor.model.IlrStackElement;
import ilog.rules.monitor.model.IlrThread;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class IlrExecutionPoint
implements Comparable<IlrExecutionPoint> {
    private IlrThread threadBlocked;
    private IlrThread threadOwner;
    private long date;
    private List<IlrStackElement> stackBlocked;
    private String lockDescription;
    private List<IlrStackElement> stackOwner;

    IlrExecutionPoint(IlrThread threadBlocked, IlrThread threadOwner, long date, String lockDescription) {
        this.threadBlocked = threadBlocked;
        this.threadOwner = threadOwner;
        this.date = date;
        this.stackBlocked = new ArrayList<IlrStackElement>();
        this.lockDescription = lockDescription;
        this.stackOwner = new ArrayList<IlrStackElement>();
    }

    void enlistStackElement(String fullyQualifiedMethodName, int line, boolean isNative) {
        IlrStackElement stackElement = IlrStackElement.getStackElement(fullyQualifiedMethodName, line, isNative);
        this.stackBlocked.add(stackElement);
    }

    void enlistOwnerStackElement(String fullyQualifiedMethodName, int line, boolean isNative) {
        IlrStackElement stackElement = IlrStackElement.getStackElement(fullyQualifiedMethodName, line, isNative);
        this.stackOwner.add(stackElement);
    }

    public IlrThread getThreadBlocked() {
        return this.threadBlocked;
    }

    public IlrThread getThreadOwner() {
        return this.threadOwner;
    }

    public long getDate() {
        return this.date;
    }

    public String getLockDescription() {
        return this.lockDescription;
    }

    public Iterator<IlrStackElement> getStackOwner() {
        return this.stackOwner.iterator();
    }

    public Iterator<IlrStackElement> getStackBlocked() {
        return this.stackBlocked.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IlrExecutionPoint that = (IlrExecutionPoint)o;
        return this.date == that.date && this.threadBlocked.equals(that.threadBlocked);
    }

    public int hashCode() {
        int result = this.threadBlocked.hashCode();
        result = 31 * result + (int)(this.date ^ this.date >>> 32);
        return result;
    }

    @Override
    public int compareTo(IlrExecutionPoint o) {
        long diff = this.date - o.date;
        if (diff < 0L) {
            return -1;
        }
        if (diff > 0L) {
            return 1;
        }
        return 0;
    }
}

