/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.monitor.model;

import ilog.rules.monitor.model.IlrExecutionPoint;
import ilog.rules.monitor.model.IlrThread;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeMap;

public final class IlrExecutionPointHistory
implements Iterable<IlrExecutionPoint> {
    private TreeMap<Long, HashSet<IlrExecutionPoint>> history = new TreeMap();

    IlrExecutionPointHistory() {
    }

    IlrExecutionPoint addExecutionPoint(IlrThread threadBlocked, IlrThread threadOwner, long date, String lockDescription) {
        IlrExecutionPoint point = new IlrExecutionPoint(threadBlocked, threadOwner, date, lockDescription);
        HashSet<IlrExecutionPoint> setForDate = this.history.get(date);
        if (setForDate == null) {
            setForDate = new HashSet();
            this.history.put(date, setForDate);
        }
        if (setForDate.add(point)) {
            return point;
        }
        return null;
    }

    @Override
    public Iterator<IlrExecutionPoint> iterator() {
        return new Iterator<IlrExecutionPoint>(){
            private Iterator<Long> itOnDate;
            private Iterator<IlrExecutionPoint> currentIt;
            {
                this.itOnDate = IlrExecutionPointHistory.this.history.keySet().iterator();
                this.currentIt = null;
            }

            @Override
            public boolean hasNext() {
                if (this.currentIt == null || !this.currentIt.hasNext()) {
                    if (this.itOnDate.hasNext()) {
                        this.currentIt = ((HashSet)IlrExecutionPointHistory.this.history.get(this.itOnDate.next())).iterator();
                    } else {
                        return false;
                    }
                }
                return this.currentIt.hasNext();
            }

            @Override
            public IlrExecutionPoint next() {
                if (this.currentIt == null || !this.currentIt.hasNext()) {
                    if (this.itOnDate.hasNext()) {
                        this.currentIt = ((HashSet)IlrExecutionPointHistory.this.history.get(this.itOnDate.next())).iterator();
                    } else {
                        throw new NoSuchElementException();
                    }
                }
                return this.currentIt.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int size() {
        int size = 0;
        for (HashSet<IlrExecutionPoint> points : this.history.values()) {
            size += points.size();
        }
        return size;
    }
}

