/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.monitor.model;

import java.lang.ref.WeakReference;
import java.util.HashMap;

public final class IlrStackElement {
    private String fullyQualifiedMethodName;
    private int line;
    private boolean isNative;
    private static HashMap<String, HashMap<Integer, IlrStackElement>> elements = new HashMap();
    private WeakReference<String> packageNameRef;

    static IlrStackElement getStackElement(String fullyQualifiedMethodName, int line, boolean isNative) {
        IlrStackElement element;
        HashMap<Integer, IlrStackElement> list = elements.get(fullyQualifiedMethodName);
        if (list == null) {
            list = new HashMap();
            elements.put(fullyQualifiedMethodName, list);
        }
        if ((element = list.get(line)) == null) {
            element = new IlrStackElement(fullyQualifiedMethodName, line, isNative);
            list.put(line, element);
        }
        return element;
    }

    private IlrStackElement(String fullyQualifiedMethodName, int line, boolean isNative) {
        this.fullyQualifiedMethodName = fullyQualifiedMethodName;
        this.line = line;
        this.isNative = isNative;
    }

    public String getFullyQualifiedMethodName() {
        return this.fullyQualifiedMethodName;
    }

    public int getLine() {
        return this.line;
    }

    public boolean isNative() {
        return this.isNative;
    }

    public String getPackageName() {
        if (this.packageNameRef == null || this.packageNameRef.get() == null) {
            int indexOfMethodName = this.fullyQualifiedMethodName.lastIndexOf(46);
            int indexOfClassName = this.fullyQualifiedMethodName.substring(0, indexOfMethodName).lastIndexOf(46);
            String packageName = this.fullyQualifiedMethodName.substring(0, indexOfClassName);
            this.packageNameRef = new WeakReference<String>(packageName);
        }
        return (String)this.packageNameRef.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IlrStackElement that = (IlrStackElement)o;
        return this.line == that.line && this.fullyQualifiedMethodName.equals(that.fullyQualifiedMethodName);
    }

    public int hashCode() {
        int result = this.fullyQualifiedMethodName.hashCode();
        result = 31 * result + this.line;
        return result;
    }
}

