/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.monitor.model;

import java.util.HashMap;

public final class IlrThread {
    private static HashMap<Long, HashMap<String, IlrThread>> threads = new HashMap();
    private String name;
    private long id;
    private long waitedTime = -1L;
    private long waitedCount;
    private long blockedTime = -1L;
    private long blockedCount;

    static IlrThread getThread(String name, long id) {
        IlrThread theThread;
        if (id == -1L || name == null) {
            return null;
        }
        HashMap<String, IlrThread> theThreads = threads.get(id);
        if (theThreads == null) {
            theThreads = new HashMap();
            threads.put(id, theThreads);
        }
        if ((theThread = theThreads.get(name)) == null) {
            theThread = new IlrThread(name, id);
            theThreads.put(name, theThread);
        }
        return theThread;
    }

    private IlrThread(String name, long id) {
        this.name = name;
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public long getId() {
        return this.id;
    }

    public long getWaitedTime() {
        return this.waitedTime;
    }

    void setWaitedTime(long waitedTime) {
        this.waitedTime = waitedTime;
    }

    public long getWaitedCount() {
        return this.waitedCount;
    }

    void setWaitedCount(long waitedCount) {
        this.waitedCount = waitedCount;
    }

    public long getBlockedTime() {
        return this.blockedTime;
    }

    void setBlockedTime(long blockedTime) {
        this.blockedTime = blockedTime;
    }

    public long getBlockedCount() {
        return this.blockedCount;
    }

    void setBlockedCount(long blockedCount) {
        this.blockedCount = blockedCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IlrThread ilrThread = (IlrThread)o;
        return this.id == ilrThread.id && this.name.equals(ilrThread.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        StringBuilder stBuilder = new StringBuilder(super.toString());
        stBuilder.append('[');
        stBuilder.append(this.id);
        stBuilder.append(',');
        stBuilder.append(this.name);
        stBuilder.append(']');
        return stBuilder.toString();
    }
}

