/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.monitor.report;

import ilog.rules.monitor.model.IlrClassDescription;
import ilog.rules.monitor.model.IlrClassDescriptionSet;
import ilog.rules.monitor.model.IlrCodeLocation;
import ilog.rules.monitor.model.IlrExecutionPoint;
import ilog.rules.monitor.model.IlrExecutionPointHistory;
import ilog.rules.monitor.model.IlrStackElement;
import ilog.rules.monitor.model.IlrThread;
import ilog.rules.monitor.report.IlrDummyStackElementFilter;
import ilog.rules.monitor.report.IlrStackElementFilter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Iterator;

public class IlrMonitorModelPrinter {
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final String CLASSDESCSETHEADER = "############################## Monitoring done ";
    public static final String CLASSDESCHEADER = "** ";
    public static final String CLASSDESCFOOTER = "***************";
    public static final String CODELOCHEADER = " -> ";
    public static final String THREADSTATE = " contention type ";
    public static final String CODELOCFOOTER = " - ";
    public static final String EXECPOINTHEADER = "  ~ ";
    public static final String STACKMARGING = "      ";
    public static final String LINE = " line: ";
    public static final String NBOFCONTENTION = " # ";
    public static final String THREADB = " th(";
    public static final String THREADS = ",";
    public static final String THREADE = ") ";
    public static final String CAUSEDBY = " caused by ";
    public static final String AT = " at ";
    public static final String ON = " with ";
    public static final String NATIVE = " native ";
    protected PrintWriter writer;
    protected IlrStackElementFilter stackElementfilter;

    public IlrMonitorModelPrinter(PrintWriter writer) {
        this(writer, null);
    }

    public IlrMonitorModelPrinter(PrintWriter writer, IlrStackElementFilter stackElementfilter) {
        this.writer = writer;
        this.stackElementfilter = stackElementfilter != null ? stackElementfilter : new IlrDummyStackElementFilter();
    }

    public void print(IlrClassDescriptionSet classDescriptionSet) {
        this.print(CLASSDESCSETHEADER);
        this.print(classDescriptionSet.getLastSnapshot());
        this.print(NEWLINE);
        for (IlrClassDescription aClassDescriptionSet : classDescriptionSet) {
            this.print(aClassDescriptionSet);
        }
        this.print(NEWLINE);
        this.print(CLASSDESCSETHEADER);
    }

    public void print(IlrClassDescription classDescription) {
        this.print(CLASSDESCHEADER);
        this.print(classDescription.getClassName());
        this.print(NEWLINE);
        for (IlrCodeLocation aClassDescription : classDescription) {
            this.print(aClassDescription);
        }
        this.print(CLASSDESCFOOTER);
    }

    public void print(IlrCodeLocation codeLoc) {
        this.print(CODELOCHEADER);
        this.print(codeLoc.getMethod());
        if (codeLoc.getLine() > 0) {
            this.print(LINE);
            this.print(codeLoc.getLine());
        } else if (codeLoc.isNative()) {
            this.print(NATIVE);
        }
        this.print(THREADSTATE);
        this.print(codeLoc.getTypeOf());
        this.print(codeLoc.getExecutionPointHistory());
        this.print(CODELOCFOOTER);
        this.print(NEWLINE);
    }

    public void print(IlrExecutionPointHistory execPointH) {
        this.print(NBOFCONTENTION);
        this.print(execPointH.size());
        this.print(NEWLINE);
        for (IlrExecutionPoint anExecPointH : execPointH) {
            this.print(anExecPointH);
        }
    }

    public void print(IlrExecutionPoint execPoint) {
        this.print(EXECPOINTHEADER);
        this.print(execPoint.getDate());
        this.print(execPoint.getThreadBlocked());
        if (execPoint.getThreadOwner() != null) {
            this.print(CAUSEDBY);
            this.print(execPoint.getThreadOwner());
            this.print(AT);
            this.print(execPoint.getStackOwner().next());
        }
        if (execPoint.getLockDescription() != null) {
            this.print(ON);
            this.print(execPoint.getLockDescription());
        }
        this.print(NEWLINE);
        Iterator<IlrStackElement> it = execPoint.getStackBlocked();
        while (it.hasNext()) {
            this.print(STACKMARGING);
            this.print(it.next());
            this.print(NEWLINE);
        }
    }

    public void print(IlrStackElement stackElement) {
        if (this.stackElementfilter.accept(stackElement)) {
            this.print(stackElement.getFullyQualifiedMethodName());
            if (stackElement.getLine() > 0) {
                this.print(LINE);
                this.print(stackElement.getLine());
            } else if (stackElement.isNative()) {
                this.print(NATIVE);
            }
        }
    }

    public void print(IlrThread thread) {
        this.print(THREADB);
        this.print(thread.getName());
        this.print(THREADS);
        this.print(thread.getId());
        this.print(THREADE);
    }

    public void print(Date date) {
        this.print(date.toString());
    }

    public void print(Thread.State state) {
        this.print(state.toString());
    }

    protected void print(String string) {
        this.writer.print(string);
    }

    protected void print(int intValue) {
        this.writer.print(intValue);
    }

    protected void print(long longValue) {
        this.writer.print(longValue);
    }
}

