/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.monitor.report;

import ilog.rules.monitor.model.IlrClassDescription;
import ilog.rules.monitor.model.IlrClassDescriptionSet;
import ilog.rules.monitor.model.IlrCodeLocation;
import ilog.rules.monitor.model.IlrExecutionPoint;
import ilog.rules.monitor.model.IlrExecutionPointHistory;
import ilog.rules.monitor.model.IlrStackElement;
import ilog.rules.monitor.model.IlrThread;
import ilog.rules.monitor.report.IlrDummyStackElementFilter;
import ilog.rules.monitor.report.IlrMonitorModelXMLTags;
import ilog.rules.monitor.report.IlrStackElementFilter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class IlrMonitorModelXmlBuilder
implements IlrMonitorModelXMLTags {
    private GregorianCalendar calendar = new GregorianCalendar();
    private DatatypeFactory dataTypeFactory = DatatypeFactory.newInstance();
    private HashMap<String, Integer> textId = new HashMap();
    private ArrayList<Element> lockDescriptionElts = new ArrayList();
    private boolean namespaceAble;
    private HashMap<Date, XMLGregorianCalendar> convertTable;
    private HashMap<Integer, Element> snapshotsElements = new HashMap();
    private IlrStackElementFilter filter;
    private HashMap<IlrThread, Element> threads;

    public IlrMonitorModelXmlBuilder(boolean namespace) throws DatatypeConfigurationException {
        this.convertTable = new HashMap();
        this.namespaceAble = namespace;
        this.threads = new HashMap();
    }

    public IlrMonitorModelXmlBuilder() throws DatatypeConfigurationException {
        this(false);
    }

    public String generateXmlDocumentAsString(IlrClassDescriptionSet classDescriptionSet) throws ParserConfigurationException, TransformerException {
        return this.generateXmlDocumentAsString(classDescriptionSet, null, null);
    }

    public String generateXmlDocumentAsString(IlrClassDescriptionSet classDescriptionSet, IlrStackElementFilter filter, Properties xslProperties) throws ParserConfigurationException, TransformerException {
        Document doc = this.generateXmlDocument(classDescriptionSet, filter);
        StringWriter sw = new StringWriter();
        this.writeDocument(doc, sw, xslProperties);
        return sw.toString();
    }

    public Document generateXmlDocument(IlrClassDescriptionSet classDescriptionSet) throws ParserConfigurationException {
        return this.generateXmlDocument(classDescriptionSet, null);
    }

    public Document generateXmlDocument(IlrClassDescriptionSet classDescriptionSet, IlrStackElementFilter stackElementFilter) throws ParserConfigurationException {
        this.filter = stackElementFilter == null ? new IlrDummyStackElementFilter() : stackElementFilter;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(this.namespaceAble);
        DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element monitorModelElt = this.createElement(doc, doc, "monitor-model");
        Element classListElt = this.createElement(doc, monitorModelElt, "class-list");
        this.createAttribute(classListElt, "max-depth-stacktrace", String.valueOf(classDescriptionSet.getMaxStacktraceDepth()));
        Element threadListElt = this.createElement(doc, monitorModelElt, "thread-list");
        this.createAttribute(threadListElt, "total-number-started", String.valueOf(classDescriptionSet.getTotalStartedThreadCount()));
        this.createElement(doc, monitorModelElt, "lock-description-list");
        Element snapshotListElt = this.createElement(doc, monitorModelElt, "snapshot-list");
        this.createAttribute(snapshotListElt, "last", this.convert(classDescriptionSet.getLastSnapshot()).toXMLFormat());
        this.createAttribute(snapshotListElt, "first", this.convert(classDescriptionSet.getFirstSnapshot()).toXMLFormat());
        this.createAttribute(snapshotListElt, "number-of-snapshots-made", String.valueOf(classDescriptionSet.getNumberOfSnapshots()));
        for (IlrClassDescription classDescription : classDescriptionSet) {
            this.addClassDescription(doc, classListElt, classDescriptionSet, classDescription);
        }
        this.buildSnapShotList(snapshotListElt, classDescriptionSet);
        doc.normalizeDocument();
        this.resetCache();
        return doc;
    }

    private void addClassDescription(Document doc, Element classListElt, IlrClassDescriptionSet classDescriptionSet, IlrClassDescription classDescription) {
        Element classDescElt = this.createElement(doc, classListElt, "class-description");
        this.createAttribute(classDescElt, "class-name", classDescription.getClassName());
        for (IlrCodeLocation codeLocation : classDescription) {
            this.addCodeLocation(doc, classDescElt, classDescriptionSet, codeLocation);
        }
    }

    private void addCodeLocation(Document doc, Element classDescElt, IlrClassDescriptionSet classDescriptionSet, IlrCodeLocation codeLocation) {
        Element codeLocationElt = this.createElement(doc, classDescElt, "code-location");
        this.createAttribute(codeLocationElt, "method-name", codeLocation.getMethod());
        this.createAttribute(codeLocationElt, "state", codeLocation.getTypeOf().toString());
        if (codeLocation.getLine() > 0) {
            this.createAttribute(codeLocationElt, "line", Integer.toString(codeLocation.getLine()));
        } else if (codeLocation.isNative()) {
            this.createAttribute(codeLocationElt, "native", null);
        }
        IlrExecutionPointHistory execPointH = codeLocation.getExecutionPointHistory();
        for (IlrExecutionPoint executionPoint : execPointH) {
            this.addExecutionPoint(doc, codeLocationElt, classDescriptionSet, executionPoint);
        }
    }

    private void addExecutionPoint(Document doc, Element codeLocationElt, IlrClassDescriptionSet classDescriptionSet, IlrExecutionPoint executionPoint) {
        Element execPointElt = this.createElement(doc, codeLocationElt, "execution-point");
        Element threadElt = this.getThreadElt(doc, executionPoint.getThreadBlocked());
        this.createAttribute(execPointElt, "thread-id", this.getAttribute(threadElt, "id"));
        this.createAttribute(execPointElt, "snapshot-id", this.getAttribute(this.getSnapshotElement(doc, executionPoint.getDate(), classDescriptionSet), "id"));
        if (executionPoint.getThreadOwner() != null) {
            Element threadOElt = this.getThreadElt(doc, executionPoint.getThreadOwner());
            this.createAttribute(execPointElt, "thread-id-lock-owner", this.getAttribute(threadOElt, "id"));
            this.addStackTrace(doc, executionPoint, execPointElt, false);
        }
        if (executionPoint.getLockDescription() != null) {
            Element lockElt = this.getLockDescritionElement(doc, executionPoint.getLockDescription());
            this.createAttribute(execPointElt, "lock-description-id", this.getAttribute(lockElt, "id"));
        }
        this.addStackTrace(doc, executionPoint, execPointElt, true);
    }

    private void addStackTrace(Document doc, IlrExecutionPoint execPoint, Element executionPointElt, boolean threadBlocked) {
        Element stackTraceElement = this.createElement(doc, executionPointElt, "stacktrace");
        if (threadBlocked) {
            this.createAttribute(stackTraceElement, "thread-id", this.getAttribute(executionPointElt, "thread-id"));
            Iterator<IlrStackElement> it = execPoint.getStackBlocked();
            while (it.hasNext()) {
                this.addStackTraceElement(doc, stackTraceElement, it.next());
            }
        } else {
            this.createAttribute(stackTraceElement, "thread-id", this.getAttribute(executionPointElt, "thread-id-lock-owner"));
            Iterator<IlrStackElement> it = execPoint.getStackOwner();
            while (it.hasNext()) {
                this.addStackTraceElement(doc, stackTraceElement, it.next());
            }
        }
    }

    private void addStackTraceElement(Document doc, Element stackTrace, IlrStackElement stackElement) {
        if (this.filter.accept(stackElement)) {
            Element selement = this.createElement(doc, stackTrace, "stacktrace-element");
            this.createAttribute(selement, "method-name", stackElement.getFullyQualifiedMethodName());
            if (stackElement.getLine() > 0) {
                this.createAttribute(selement, "line", Integer.toString(stackElement.getLine()));
            }
            if (stackElement.isNative()) {
                this.createAttribute(selement, "native", null);
            }
        }
    }

    private Element getThreadElt(Document doc, IlrThread thread) {
        Element threadElt = this.threads.get(thread);
        if (threadElt == null) {
            Element threadListElt = (Element)doc.getElementsByTagName("thread-list").item(0);
            threadElt = this.createElement(doc, threadListElt, "thread");
            this.createAttribute(threadElt, "thread-name", thread.getName());
            this.createAttribute(threadElt, "id", Long.toString(thread.getId()));
            this.createAttribute(threadElt, "total-waited-count", Long.toString(thread.getWaitedCount()));
            this.createAttribute(threadElt, "total-blocked-count", Long.toString(thread.getBlockedCount()));
            if (thread.getWaitedTime() != -1L) {
                this.createAttribute(threadElt, "total-waited-time", Long.toString(thread.getWaitedTime()));
            }
            if (thread.getBlockedTime() != -1L) {
                this.createAttribute(threadElt, "total-blocked-time", Long.toString(thread.getBlockedTime()));
            }
            this.threads.put(thread, threadElt);
        }
        return threadElt;
    }

    private Element getLockDescritionElement(Document doc, String text) {
        Element lockElt;
        Integer ID = this.textId.get(text);
        if (ID == null) {
            ID = this.lockDescriptionElts.size();
            this.textId.put(text, ID);
            CDATASection cdata = doc.createCDATASection(text);
            Element lockDescriptionListElt = (Element)doc.getElementsByTagName("lock-description-list").item(0);
            lockElt = this.createElement(doc, lockDescriptionListElt, "lock-description");
            lockElt.appendChild(cdata);
            this.createAttribute(lockElt, "id", ID.toString());
            this.lockDescriptionElts.add(lockElt);
        } else {
            lockElt = this.lockDescriptionElts.get(ID);
        }
        return lockElt;
    }

    private void buildSnapShotList(Element snapshotsListElt, IlrClassDescriptionSet classDescriptionSet) {
        for (int i = 0; i < classDescriptionSet.getNumberOfSnapshots(); ++i) {
            Element snapshotElement = this.snapshotsElements.get(i);
            if (snapshotElement == null) continue;
            snapshotsListElt.appendChild(snapshotElement);
        }
    }

    private Element getSnapshotElement(Document doc, long date, IlrClassDescriptionSet classDescriptionSet) {
        int ID = classDescriptionSet.getSnapshotNumber(date);
        if (ID < 0) {
            throw new IllegalStateException(date + " unkwown snapshot");
        }
        Element snapshotElt = this.snapshotsElements.get(ID);
        if (snapshotElt == null) {
            snapshotElt = this.createElement(doc, "snapshot");
            this.createAttribute(snapshotElt, "id", Integer.toString(ID));
            this.createAttribute(snapshotElt, "value", Long.toString(date));
            this.snapshotsElements.put(ID, snapshotElt);
        }
        return snapshotElt;
    }

    private XMLGregorianCalendar convert(Date date) {
        XMLGregorianCalendar xmlCal = this.convertTable.get(date);
        if (xmlCal == null) {
            this.calendar.setTime(date);
            xmlCal = this.dataTypeFactory.newXMLGregorianCalendar(this.calendar);
            this.convertTable.put(date, xmlCal);
        }
        return xmlCal;
    }

    private Element createElement(Document doc, Node father, String elementTag) {
        Element child = this.createElement(doc, elementTag);
        father.appendChild(child);
        return child;
    }

    private Element createElement(Document doc, String elementTag) {
        Element child = this.namespaceAble ? doc.createElementNS("http://www.ilog.com/rules/monitor-thread", elementTag) : doc.createElement(elementTag);
        return child;
    }

    private void createAttribute(Element owner, String name, String value) {
        if (this.namespaceAble) {
            if (value != null) {
                owner.setAttributeNS("http://www.ilog.com/rules/monitor-thread", name, value);
            } else {
                Document doc = owner.getOwnerDocument();
                Attr attr = doc.createAttributeNS("http://www.ilog.com/rules/monitor-thread", name);
                owner.setAttributeNodeNS(attr);
            }
        } else if (value != null) {
            owner.setAttribute(name, value);
        } else {
            Document doc = owner.getOwnerDocument();
            Attr attr = doc.createAttribute(name);
            owner.setAttributeNode(attr);
        }
    }

    private String getAttribute(Element owner, String name) {
        if (this.namespaceAble) {
            return owner.getAttributeNS("http://www.ilog.com/rules/monitor-thread", name);
        }
        return owner.getAttribute(name);
    }

    private void resetCache() {
        this.convertTable.clear();
        this.lockDescriptionElts.clear();
        this.snapshotsElements.clear();
        this.textId.clear();
        this.threads.clear();
    }

    private void writeDocument(Document doc, Writer writer, Properties xslProperties) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        if (xslProperties == null) {
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        } else {
            transformer.setOutputProperties(xslProperties);
        }
        DOMSource xmlSource = new DOMSource(doc);
        StreamResult xmlDest = new StreamResult(writer);
        transformer.transform(xmlSource, xmlDest);
    }
}

