/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.mbean.util;

import ilog.rules.res.mbean.util.IlrMBeanManager;
import ilog.rules.res.mbean.util.IlrMBeanManagerImpl;
import ilog.rules.res.mbean.util.IlrMBeanManagerImpl_sunas;
import ilog.rules.res.mbean.util.IlrMBeanManagerImpl_weblogic9;
import ilog.rules.res.mbean.util.IlrMBeanManagerImpl_websphere;
import java.util.Properties;

public class IlrMBeanManagerFactory {
    public static final int NOT_DEFINED = -1;
    public static final int DEFAULT = 0;
    public static final int WEBSPHERE = 3;
    public static final int WEBLOGIC90 = 5;
    public static final int SUNAS = 8;
    public static final int JBOSS5HA = 9;
    public static final int JBOSS6HA = 10;
    private static final String JMX_CHOICE = "ilog.jmx.implementation";
    private int jmxImpl = -1;
    private final Properties properties;

    public IlrMBeanManagerFactory(Properties properties) {
        this.properties = properties;
        if (properties != null) {
            String jmxChoice = properties.getProperty(JMX_CHOICE);
            try {
                this.jmxImpl = Integer.parseInt(jmxChoice);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public synchronized int getJMXImplementation() {
        if (this.jmxImpl != -1) {
            return this.jmxImpl;
        }
        this.jmxImpl = this.findJMXImplementation();
        return this.jmxImpl;
    }

    public IlrMBeanManager createMBeanManager() {
        switch (this.getJMXImplementation()) {
            case 0: {
                return new IlrMBeanManagerImpl(this.properties);
            }
            case 3: {
                return new IlrMBeanManagerImpl_websphere(this.properties);
            }
            case 9: {
                return this.createMBeanManagerForJBoss5Cluster();
            }
            case 10: {
                return this.createMBeanManagerForJBoss6Cluster();
            }
            case 5: {
                return new IlrMBeanManagerImpl_weblogic9(this.properties);
            }
            case 8: {
                return new IlrMBeanManagerImpl_sunas(this.properties);
            }
        }
        return null;
    }

    private int findJMXImplementation() {
        try {
            Class.forName("com.sun.appserv.management.DomainRoot");
            return 8;
        }
        catch (Throwable t) {
            try {
                Class.forName("weblogic.management.jmx.modelmbean.WLSModelMBean");
                return 5;
            }
            catch (Throwable t2) {
                try {
                    Class.forName("com.ibm.websphere.management.AdminServiceFactory");
                    return 3;
                }
                catch (Throwable t3) {
                    block13: {
                        try {
                            Class.forName("org.jboss.ha.framework.interfaces.HAPartition");
                            Class.forName("org.jboss.invocation.InvokerInterceptor");
                            Class<?> clusterNodeClass = Class.forName("org.jboss.ha.framework.interfaces.ClusterNode");
                            if (!clusterNodeClass.isInterface()) break block13;
                            IlrMBeanManager mbeanManager = null;
                            int returnedValue = 0;
                            try {
                                Class.forName("org.jboss.bootstrap.spi.util.ServerConfigUtil");
                                mbeanManager = this.createMBeanManagerForJBoss5Cluster();
                                returnedValue = 9;
                            }
                            catch (Throwable t4) {
                                mbeanManager = this.createMBeanManagerForJBoss6Cluster();
                                returnedValue = 10;
                            }
                            if (mbeanManager == null) break block13;
                            boolean clusterMode = true;
                            try {
                                mbeanManager.initMBeanManager();
                            }
                            catch (Throwable t5) {
                                clusterMode = false;
                            }
                            if (clusterMode) {
                                return returnedValue;
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    return 0;
                }
            }
        }
    }

    private IlrMBeanManager createMBeanManagerForJBoss5Cluster() {
        IlrMBeanManager returnedValue = null;
        try {
            Class<?> implClass = Class.forName("ilog.rules.res.mbean.util.IlrMBeanManagerImpl_jboss5HA");
            returnedValue = (IlrMBeanManager)implClass.getConstructor(Properties.class).newInstance(this.properties);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return returnedValue;
    }

    private IlrMBeanManager createMBeanManagerForJBoss6Cluster() {
        IlrMBeanManager returnedValue = null;
        try {
            Class<?> implClass = Class.forName("ilog.rules.res.mbean.util.IlrMBeanManagerImpl_jboss6HA");
            returnedValue = (IlrMBeanManager)implClass.getConstructor(Properties.class).newInstance(this.properties);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return returnedValue;
    }
}

