/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.mbean.util;

import ilog.rules.res.mbean.util.IlrMBeanManager;
import ilog.rules.res.mbean.util.InvocationResult;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.RuntimeMBeanException;

public class IlrSingleMBeanInvocationHandler
implements InvocationHandler {
    private static final String GET_METHOD_PREFIX = "get";
    private static final String IS_METHOD_PREFIX = "is";
    private static final String SET_METHOD_PREFIX = "set";
    protected IlrMBeanManager mbeanManager;
    protected ObjectName objectName;
    protected Map<Method, String[]> paramMap = new HashMap<Method, String[]>();

    public IlrSingleMBeanInvocationHandler(IlrMBeanManager mbeanManager, ObjectName objectName) {
        this.mbeanManager = mbeanManager;
        this.objectName = objectName;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        List<InvocationResult> jmxresult;
        String attributeName;
        Class<?>[] paramTypes = method.getParameterTypes();
        String methodName = method.getName();
        if (methodName.startsWith(GET_METHOD_PREFIX) && paramTypes.length == 0) {
            attributeName = methodName.substring(GET_METHOD_PREFIX.length());
            jmxresult = this.mbeanManager.getAttribute(this.objectName, attributeName);
        } else if (methodName.startsWith(IS_METHOD_PREFIX) && paramTypes.length == 1) {
            attributeName = methodName.substring(IS_METHOD_PREFIX.length());
            jmxresult = this.mbeanManager.getAttribute(this.objectName, attributeName);
        } else if (methodName.startsWith(SET_METHOD_PREFIX) && paramTypes.length == 1) {
            attributeName = methodName.substring(SET_METHOD_PREFIX.length());
            jmxresult = this.mbeanManager.setAttribute(this.objectName, attributeName, args[0]);
        } else {
            String[] sig = this.getMethodSignature(method, paramTypes);
            jmxresult = this.mbeanManager.invoke(this.objectName, methodName, args, sig);
        }
        for (InvocationResult element : jmxresult) {
            if (element.getError() == null) continue;
            Throwable exception = element.getError();
            if (exception instanceof MBeanException) {
                throw ((MBeanException)exception).getTargetException();
            }
            if (exception instanceof RuntimeMBeanException) {
                throw ((RuntimeMBeanException)exception).getTargetException();
            }
            throw exception;
        }
        if (jmxresult.size() == 0) {
            throw new IllegalStateException();
        }
        return jmxresult.get(0).getResult();
    }

    public String[] getMethodSignature(Method method, Class<?>[] paramTypes) {
        String[] sig = this.paramMap.get(method);
        if (sig != null) {
            return sig;
        }
        sig = new String[paramTypes.length];
        for (int i = 0; i < sig.length; ++i) {
            sig[i] = paramTypes[i].getName();
        }
        this.paramMap.put(method, sig);
        return sig;
    }
}

