/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.model;

import ilog.rules.res.model.IlrFormatException;
import ilog.rules.res.model.IlrVersion;
import ilog.rules.res.model.internal.IlrModelLocalization;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IlrPath
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Pattern PATTERN = Pattern.compile("/([_\\p{javaLetter}][_\\p{javaLetterOrDigit}]*)(?:/([1-9][0-9]*)\\.([0-9]+))?(?:/([_\\p{javaLetter}][_\\p{javaLetterOrDigit}]*)(?:/([1-9][0-9]*)\\.([0-9]+))?)?");
    private final String ruleAppName;
    private final IlrVersion ruleAppVersion;
    private final String rulesetName;
    private final IlrVersion rulesetVersion;
    private final String path;

    public IlrPath(String ruleAppName) {
        this(ruleAppName, null, null, null);
    }

    public IlrPath(String ruleAppName, IlrVersion ruleAppVersion) {
        this(ruleAppName, ruleAppVersion, null, null);
    }

    public IlrPath(String ruleAppName, String rulesetName, IlrVersion rulesetVersion) {
        this(ruleAppName, null, rulesetName, rulesetVersion);
    }

    public IlrPath(String ruleAppName, String rulesetName) {
        this(ruleAppName, null, rulesetName, null);
    }

    public IlrPath(String ruleAppName, IlrVersion ruleAppVersion, String rulesetName) {
        this(ruleAppName, ruleAppVersion, rulesetName, null);
    }

    private IlrPath(String ruleAppName, IlrVersion ruleAppVersion, String rulesetName, IlrVersion rulesetVersion, String path) {
        this.ruleAppName = ruleAppName;
        this.ruleAppVersion = ruleAppVersion;
        this.rulesetName = rulesetName;
        this.rulesetVersion = rulesetVersion;
        this.path = path;
    }

    public IlrPath(String ruleAppName, IlrVersion ruleAppVersion, String rulesetName, IlrVersion rulesetVersion) {
        if (ruleAppName == null) {
            throw new IllegalArgumentException();
        }
        this.ruleAppName = ruleAppName;
        this.ruleAppVersion = ruleAppVersion;
        this.rulesetName = rulesetName;
        this.rulesetVersion = rulesetVersion;
        StringBuffer buff = new StringBuffer();
        if (!ruleAppName.equals("") && !ruleAppName.startsWith("/")) {
            buff.append('/');
        }
        buff.append(ruleAppName);
        if (ruleAppVersion != null) {
            buff.append('/').append(ruleAppVersion);
        }
        if (rulesetName != null) {
            buff.append('/').append(rulesetName);
            if (rulesetVersion != null) {
                buff.append('/').append(rulesetVersion);
            }
        }
        this.path = buff.toString();
    }

    public static IlrPath parsePath(String path) throws IlrFormatException {
        if (path == null) {
            throw new IlrFormatException("ilog.rules.res.model.messages", IlrModelLocalization.PATH_CANNOT_BE_NULL);
        }
        Matcher m = PATTERN.matcher(path);
        if (!m.matches()) {
            throw new IlrFormatException("ilog.rules.res.model.messages", IlrModelLocalization.INVALID_PATH, new String[]{path});
        }
        String ruleAppName = m.group(1);
        String ruleAppMajorVersion = m.group(2);
        String ruleAppMinorVersion = m.group(3);
        String rulesetName = m.group(4);
        String rulesetMajorVersion = m.group(5);
        String rulesetMinorVersion = m.group(6);
        IlrVersion ruleAppVersion = null;
        if (ruleAppMajorVersion != null && ruleAppMinorVersion != null) {
            try {
                ruleAppVersion = new IlrVersion(Integer.parseInt(ruleAppMajorVersion), Integer.parseInt(ruleAppMinorVersion));
            }
            catch (NumberFormatException e) {
                throw new IlrFormatException("ilog.rules.res.model.messages", IlrModelLocalization.INVALID_PATH, new String[]{path});
            }
        }
        IlrVersion rulesetVersion = null;
        if (rulesetMajorVersion != null && rulesetMinorVersion != null) {
            try {
                rulesetVersion = new IlrVersion(Integer.parseInt(rulesetMajorVersion), Integer.parseInt(rulesetMinorVersion));
            }
            catch (NumberFormatException e) {
                throw new IlrFormatException("ilog.rules.res.model.messages", IlrModelLocalization.INVALID_PATH, new String[]{path});
            }
        }
        return new IlrPath(ruleAppName, ruleAppVersion, rulesetName, rulesetVersion, path);
    }

    public String getRuleAppName() {
        return this.ruleAppName;
    }

    public IlrVersion getRuleAppVersion() {
        return this.ruleAppVersion;
    }

    public String getRulesetName() {
        return this.rulesetName;
    }

    public IlrVersion getRulesetVersion() {
        return this.rulesetVersion;
    }

    public boolean isRuleAppPath() {
        return this.ruleAppName != null && this.rulesetName == null && this.rulesetVersion == null;
    }

    public boolean isRulesetPath() {
        return this.ruleAppName != null && this.rulesetName != null;
    }

    public boolean isCanonical() {
        return this.ruleAppName != null && this.ruleAppVersion != null && this.rulesetName == null && this.rulesetVersion == null || this.ruleAppName != null && this.ruleAppVersion != null && this.rulesetName != null && this.rulesetVersion != null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IlrPath)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.path;
    }
}

