/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.model.internal;

import com.ibm.rules.res.util.internal.StreamUtil;
import ilog.rules.res.model.IlrDERulesetArchive;
import ilog.rules.res.model.IlrResourceRuntimeException;
import ilog.rules.res.model.IlrRulesetParameter;
import ilog.rules.res.model.internal.IlrBaseRESRulesetArchive;
import ilog.rules.res.model.internal.IlrRESArchiveUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class IlrDERulesetArchiveImpl
extends IlrBaseRESRulesetArchive
implements IlrDERulesetArchive {
    private static final String SIGNATURE_FILE_PATH = "RULES_ENGINE/default/resources/ruleset/com.ibm.rules.engine.signature.xml";
    protected byte[] data;

    public IlrDERulesetArchiveImpl(byte[] data) {
        this.data = data;
    }

    @Override
    public InputStream getContentStream() {
        return StreamUtil.toStream(this.data);
    }

    @Override
    public Collection<IlrRulesetParameter> getRulesetParameters(byte direction) {
        ZipInputStream zipInputStream = new ZipInputStream(this.getContentStream());
        String signaturePath = SIGNATURE_FILE_PATH;
        try {
            ZipEntry currentEntry;
            while ((currentEntry = zipInputStream.getNextEntry()) != null && !currentEntry.getName().startsWith(signaturePath)) {
            }
        }
        catch (IOException e) {
            throw new IlrResourceRuntimeException(e);
        }
        return new IlrRESArchiveUtil().extractRulesetParametersFromRulesetArchiveXmlSignature(zipInputStream, direction);
    }
}

