/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.model.internal;

import ilog.rules.res.model.IlrVersion;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class IlrEntityContainer<E> {
    private final HashMap<String, TreeMap<IlrVersion, E>> entities = new HashMap();

    public IlrEntityContainer() {
    }

    public IlrEntityContainer(IlrEntityContainer<E> entityContainer) {
        for (Map.Entry<String, TreeMap<IlrVersion, E>> entry : entityContainer.entities.entrySet()) {
            this.entities.put(entry.getKey(), new TreeMap(entry.getValue()));
        }
    }

    public synchronized int getNbEntities() {
        int result = 0;
        for (TreeMap<IlrVersion, E> tm : this.entities.values()) {
            result += tm.size();
        }
        return result;
    }

    public synchronized Set<E> getEntities() {
        HashSet<E> result = new HashSet<E>();
        for (TreeMap<IlrVersion, E> tm : this.entities.values()) {
            result.addAll(tm.values());
        }
        return result;
    }

    public synchronized Set<E> getEntities(String entityName) {
        TreeMap<IlrVersion, E> tm = this.entities.get(entityName);
        if (tm != null) {
            return new HashSet<E>(tm.values());
        }
        return new HashSet();
    }

    public synchronized E getGreatestEntity(String entityName) {
        TreeMap<IlrVersion, E> tm = this.entities.get(entityName);
        if (tm != null) {
            return tm.get(tm.lastKey());
        }
        return null;
    }

    public synchronized E getEntity(String entityName, IlrVersion entityVersion) {
        TreeMap<IlrVersion, E> tm = this.entities.get(entityName);
        if (tm != null && entityVersion != null) {
            return tm.get(entityVersion);
        }
        return null;
    }

    public synchronized E addEntity(String entityName, IlrVersion entityVersion, E entity) {
        TreeMap<IlrVersion, Object> tm = this.entities.get(entityName);
        if (tm == null) {
            tm = new TreeMap();
            this.entities.put(entityName, tm);
        }
        tm.put(entityVersion, entity);
        return entity;
    }

    public synchronized E removeEntity(String entityName, IlrVersion entityVersion) {
        TreeMap<IlrVersion, E> tm = this.entities.get(entityName);
        if (tm != null) {
            E result = tm.remove(entityVersion);
            if (tm.size() == 0) {
                this.entities.remove(entityName);
            }
            return result;
        }
        return null;
    }

    public synchronized boolean containsEntity(String entityName, IlrVersion entityVersion) {
        TreeMap<IlrVersion, E> tm = this.entities.get(entityName);
        if (tm != null) {
            return tm.containsKey(entityVersion);
        }
        return false;
    }
}

