/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.model.internal;

import ilog.rules.res.model.IlrFormatException;
import ilog.rules.res.model.IlrInvalidCharFormatException;
import ilog.rules.res.model.internal.IlrFieldValidator;
import ilog.rules.res.model.internal.IlrModelImplLocalization;

public class IlrNameValidator
extends IlrFieldValidator {
    public static void validateRulesetName(String name) throws IlrFormatException {
        IlrNameValidator.checkMinimumLength(name, IlrModelImplLocalization.RULESET_NAME_NULL_ERROR);
        IlrNameValidator.checkMaximumLength(name, IlrModelImplLocalization.RULESET_NAME_LENGTH_ERROR);
        int errorCodePoint = IlrNameValidator.check(name);
        if (errorCodePoint != -1) {
            StringBuffer errorString = new StringBuffer();
            errorString.appendCodePoint(errorCodePoint);
            throw new IlrInvalidCharFormatException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.RULESET_NAME_FORMAT_ERROR, new String[]{name, errorString.toString()}, Character.valueOf((char)errorCodePoint));
        }
    }

    public static void validateRulesetDisplayName(String displayName) throws IlrFormatException {
        IlrNameValidator.checkMaximumLength(displayName, IlrModelImplLocalization.RULESET_DISPLAY_NAME_LENGTH_ERROR);
    }

    public static void validateRuleAppDisplayName(String displayName) throws IlrFormatException {
        IlrNameValidator.checkMaximumLength(displayName, IlrModelImplLocalization.RULEAPP_DISPLAY_NAME_LENGTH_ERROR);
    }

    private static void checkMinimumLength(String name, String messageKey) throws IlrFormatException {
        if (name == null || name.length() == 0) {
            throw new IlrFormatException("ilog.rules.res.model.impl.messages", messageKey);
        }
    }

    public static void validateRuleAppName(String name) throws IlrFormatException {
        IlrNameValidator.checkMinimumLength(name, IlrModelImplLocalization.RULEAPP_NAME_NULL_ERROR);
        IlrNameValidator.checkMaximumLength(name, IlrModelImplLocalization.RULEAPP_NAME_LENGTH_ERROR);
        int errorCodePoint = IlrNameValidator.check(name);
        if (errorCodePoint != -1) {
            StringBuffer errorString = new StringBuffer();
            errorString.appendCodePoint(errorCodePoint);
            throw new IlrInvalidCharFormatException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.RULEAPP_NAME_FORMAT_ERROR, new String[]{name, errorString.toString()}, Character.valueOf((char)errorCodePoint));
        }
    }

    public static void validateLibraryName(String name) throws IlrFormatException {
        IlrNameValidator.checkMinimumLength(name, IlrModelImplLocalization.LIBRARY_NAME_NULL_ERROR);
        IlrNameValidator.checkMaximumLength(name, IlrModelImplLocalization.LIBRARY_NAME_LENGTH_ERROR);
        int errorCodePoint = -1;
        if (errorCodePoint != -1) {
            StringBuffer errorString = new StringBuffer();
            errorString.appendCodePoint(errorCodePoint);
            throw new IlrInvalidCharFormatException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.LIBRARY_NAME_FORMAT_ERROR, new String[]{name, errorString.toString()}, Character.valueOf((char)errorCodePoint));
        }
    }

    public static void validateResourceName(String name) throws IlrFormatException {
        IlrNameValidator.checkMinimumLength(name, IlrModelImplLocalization.RESOURCE_NAME_NULL_ERROR);
        IlrNameValidator.checkMaximumLength(name, IlrModelImplLocalization.RESOURCE_NAME_LENGTH_ERROR);
        int errorCodePoint = -1;
        if (errorCodePoint != -1) {
            StringBuffer errorString = new StringBuffer();
            errorString.appendCodePoint(errorCodePoint);
            throw new IlrInvalidCharFormatException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.RESOURCE_NAME_FORMAT_ERROR, new String[]{name, errorString.toString()}, Character.valueOf((char)errorCodePoint));
        }
    }

    private static int check(String name) {
        int ch = name.codePointAt(0);
        if (ch != 95 && !Character.isLetter(ch)) {
            return ch;
        }
        int length = name.codePointCount(0, name.length());
        for (int i = 1; i < length; ++i) {
            ch = name.codePointAt(name.offsetByCodePoints(0, i));
            if (ch == 95 || Character.isLetterOrDigit(ch)) continue;
            return ch;
        }
        return -1;
    }
}

