/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.model.mbean;

import com.ibm.rules.res.logging.internal.RESLogger;
import com.ibm.rules.res.message.internal.XXMessageCode;
import ilog.rules.res.mbean.util.IlrMBeanManager;
import ilog.rules.res.mbean.util.InvocationResult;
import java.util.List;
import java.util.Properties;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class IlrDSMBeanUtil {
    private static final RESLogger logger = RESLogger.getRESLogger("com.ibm.rules.res.mbean", "com.ibm.rules.res.common");
    private static final String METHOD_resetStatistics = "resetStatistics";
    private static final String[] METHOD_SIGNATURE_resetStatistics = new String[0];
    private static final String METHOD_remove = "remove";
    private static final String[] METHOD_SIGNATURE_remove = new String[0];
    private static final String METHOD_setProperty = "setProperty";
    private static final String[] METHOD_SIGNATURE_setProperty = new String[]{String.class.getName(), String.class.getName()};
    private static final String ATTRIBUTE_RulesetPath = "RulesetPath";
    private static final String ATTRIBUTE_State = "State";
    private static final String ATTRIBUTE_Activated = "Activated";
    private IlrMBeanManager mbeanManager;

    public IlrDSMBeanUtil(IlrMBeanManager mbeanManager) {
        this.mbeanManager = mbeanManager;
    }

    public List<InvocationResult> getRulesetPath() {
        List<InvocationResult> result = this.mbeanManager.getAttribute(this.getQuery(null), ATTRIBUTE_RulesetPath);
        this.logErrors(result, XXMessageCode.ERROR_GET_RULESET_PATH);
        return result;
    }

    public List<InvocationResult> getState(String name) {
        List<InvocationResult> result = this.mbeanManager.getAttribute(this.getQuery(name), ATTRIBUTE_State);
        this.logErrors(result, XXMessageCode.ERROR_GET_STATE);
        return result;
    }

    public List<InvocationResult> resetStatistics(String name) {
        List<InvocationResult> result = this.mbeanManager.invoke(this.getQuery(name), METHOD_resetStatistics, new Object[0], METHOD_SIGNATURE_resetStatistics);
        this.logErrors(result, XXMessageCode.ERROR_RESET_STAT);
        return result;
    }

    public List<InvocationResult> setActivated(String name, boolean activated) {
        List<InvocationResult> result = this.mbeanManager.setAttribute(this.getQuery(name), ATTRIBUTE_Activated, new Boolean(activated));
        this.logErrors(result, XXMessageCode.ERROR_SET_ACTIVATED);
        return result;
    }

    public List<InvocationResult> setProperty(String name, String key, String value) {
        List<InvocationResult> result = this.mbeanManager.invoke(this.getQuery(name), METHOD_setProperty, new Object[]{key, value}, METHOD_SIGNATURE_setProperty);
        this.logErrors(result, XXMessageCode.ERROR_SET_PROPERTY);
        return result;
    }

    public List<InvocationResult> remove(String name) {
        List<InvocationResult> result = this.mbeanManager.invoke(this.getQuery(name), METHOD_remove, new Object[0], METHOD_SIGNATURE_remove);
        this.logErrors(result, XXMessageCode.ERROR_REMOVE_DS);
        return result;
    }

    private synchronized ObjectName getQuery(String name) {
        try {
            Properties managerProps = this.mbeanManager.getProperties();
            String queryPart = managerProps.getProperty("JMX_DS_QUERY_PART");
            Properties filter = null;
            if (name != null) {
                filter = new Properties();
                filter.setProperty("dsName", name);
            }
            return this.mbeanManager.getQuery("IlrDecisionService", queryPart, filter);
        }
        catch (MalformedObjectNameException e) {
            throw new UnsupportedOperationException(e.getMessage());
        }
    }

    private void logErrors(List<InvocationResult> result, String messageCode) {
        for (InvocationResult element : result) {
            if (element.getError() == null) continue;
            logger.severe(messageCode, null, element.getError());
        }
    }
}

