/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.model.mbean;

import com.ibm.rules.res.logging.internal.RESLogger;
import com.ibm.rules.res.message.internal.XXMessageCode;
import ilog.rules.res.mbean.util.IlrMBeanManager;
import ilog.rules.res.mbean.util.InvocationResult;
import ilog.rules.res.model.IlrMutableRuleAppInformation;
import ilog.rules.res.model.internal.IlrDeploymentReport;
import ilog.rules.res.model.internal.IlrMutableRepositoryImpl;
import ilog.rules.res.model.mbean.IlrJMXMutableRuleAppInformationImpl;
import ilog.rules.res.model.mbean.IlrJMXRepositoryFactoryImpl;
import ilog.rules.res.model.mbean.IlrJMXRepositoryMBean;
import ilog.rules.res.model.mbean.IlrLogHelper;
import ilog.rules.res.model.mbean.IlrXUMBeanUtil;
import ilog.rules.res.persistence.IlrRepositoryDAO;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;

public class IlrJMXMutableRepositoryImpl
extends IlrMutableRepositoryImpl {
    private static final RESLogger logger = RESLogger.getRESLogger("com.ibm.rules.res.mbean", "com.ibm.rules.res.common");
    private IlrMBeanManager mbeanManager;
    private IlrXUMBeanUtil xuMBeanUtil;
    private ObjectName objectname;
    private IlrJMXRepositoryMBean modelMBean;
    private boolean sendNotif = false;

    protected IlrJMXMutableRepositoryImpl(IlrJMXRepositoryFactoryImpl repositoryFactory) {
        this(repositoryFactory, null, null);
    }

    protected IlrJMXMutableRepositoryImpl(IlrJMXRepositoryFactoryImpl repositoryFactory, IlrRepositoryDAO repositoryDAO, Set<IlrMutableRuleAppInformation> ruleApps) {
        super(repositoryFactory, repositoryDAO, ruleApps);
        this.xuMBeanUtil = repositoryFactory.getXUMBeanUtil();
        this.mbeanManager = repositoryFactory.getMBeanFactory().getMBeanManager();
        this.modelMBean = repositoryFactory.getMBeanFactory().createRepositoryMBean(this);
        try {
            this.objectname = this.mbeanManager.registerMBean("IlrJMXRepository", new Properties(), this.modelMBean);
        }
        catch (Throwable e) {
            logger.severe(IlrLogHelper.registerMBeanError("IlrJMXRepository", new Properties(), this.modelMBean), null, e);
        }
        this.sendNotif = true;
    }

    public boolean mustSendNotif() {
        return this.sendNotif;
    }

    public ObjectName getObjectName() {
        return this.objectname;
    }

    public IlrJMXRepositoryMBean getMBean() {
        return this.modelMBean;
    }

    public IlrJMXRepositoryFactoryImpl getRepositoryFactory() {
        return (IlrJMXRepositoryFactoryImpl)this.repositoryFactory;
    }

    public synchronized void unregisterMBean() {
        this.sendNotif = false;
        try {
            if (this.objectname != null) {
                this.mbeanManager.unregisterMBean(this.objectname);
            }
            this.objectname = null;
        }
        catch (InstanceNotFoundException e) {
            logger.log(Level.FINER, "UnregisterMBean failed due to InstanceNotFoundException on " + this.objectname, null, e);
        }
        catch (Throwable e) {
            logger.severe(IlrLogHelper.unregisterMBeanError(this.objectname), null, e);
        }
        for (IlrJMXMutableRuleAppInformationImpl ruleapp : this.ruleAppsContainer.getEntities()) {
            ruleapp.linked(null, false);
        }
    }

    public void cleanMBeans() {
        Set<ObjectName> objectNames = null;
        try {
            objectNames = this.mbeanManager.findLocalMBeans(this.mbeanManager.getQuery("IlrJMXRepository"));
            objectNames.addAll(this.mbeanManager.findLocalMBeans(this.mbeanManager.getQuery("IlrJMXRuleApp")));
            objectNames.addAll(this.mbeanManager.findLocalMBeans(this.mbeanManager.getQuery("IlrJMXRuleset")));
        }
        catch (Throwable e) {
            logger.severe(XXMessageCode.ERROR_CLEAN_MBEANS_FAILED, null, e);
        }
        if (objectNames != null) {
            for (ObjectName on : objectNames) {
                try {
                    this.mbeanManager.unregisterMBean(on);
                }
                catch (Throwable e) {
                    logger.severe(XXMessageCode.ERROR_CLEAN_MBEANS_FAILED, null, e);
                }
            }
        }
    }

    @Override
    public void update() {
        this.xuMBeanUtil.startBuffering();
        super.update();
        this.xuMBeanUtil.flushBuffer();
    }

    @Override
    protected IlrDeploymentReport commit(List<IlrMutableRepositoryImpl.EntityOperation> operations) {
        this.xuMBeanUtil.startBuffering();
        IlrDeploymentReport result = super.commit(operations);
        this.xuMBeanUtil.flushBuffer();
        return result;
    }

    public IlrMBeanManager getMBeanManager() {
        return this.mbeanManager;
    }

    protected long getWarningCount() {
        long result = 0L;
        List<InvocationResult> warningCounts = this.xuMBeanUtil.getWarningCount();
        for (InvocationResult element : warningCounts) {
            if (element.getResult() == null) continue;
            result += ((Long)element.getResult()).longValue();
        }
        return result;
    }

    protected long getErrorCount() {
        long result = 0L;
        List<InvocationResult> errorCounts = this.xuMBeanUtil.getErrorCount();
        for (InvocationResult element : errorCounts) {
            if (element.getResult() == null) continue;
            result += ((Long)element.getResult()).longValue();
        }
        return result;
    }

    protected void resetWarningCount() {
        this.xuMBeanUtil.resetWarningCount();
    }

    protected void resetErrorCount() {
        this.xuMBeanUtil.resetErrorCount();
    }
}

