/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.model.mbean;

import com.ibm.rules.res.logging.internal.RESLogger;
import ilog.rules.res.mbean.util.IlrMBeanManager;
import ilog.rules.res.model.IlrResourceRuntimeException;
import ilog.rules.res.model.IlrVersion;
import ilog.rules.res.model.internal.IlrMutableRepositoryImpl;
import ilog.rules.res.model.internal.IlrMutableRuleAppInformationImpl;
import ilog.rules.res.model.mbean.IlrJMXMutableRepositoryImpl;
import ilog.rules.res.model.mbean.IlrJMXRepositoryFactoryImpl;
import ilog.rules.res.model.mbean.IlrJMXRuleAppMBean;
import ilog.rules.res.model.mbean.IlrLogHelper;
import ilog.rules.res.model.mbean.IlrNotificationMBean;
import ilog.rules.res.model.mbean.IlrXUMBeanUtil;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import javax.management.InstanceNotFoundException;
import javax.management.Notification;
import javax.management.ObjectName;

public class IlrJMXMutableRuleAppInformationImpl
extends IlrMutableRuleAppInformationImpl {
    private static final RESLogger logger = RESLogger.getRESLogger("com.ibm.rules.res.mbean", "com.ibm.rules.res.common");
    private IlrJMXRepositoryFactoryImpl repositoryFactory;
    private IlrMBeanManager mbeanManager;
    private ObjectName objectname;
    private IlrJMXRuleAppMBean ruleAppMBean;
    private long sequenceNumber = 1L;
    private IlrXUMBeanUtil xuMBeanUtil;

    protected IlrJMXMutableRuleAppInformationImpl(String name, IlrVersion version, Date creationDate, IlrJMXRepositoryFactoryImpl repositoryFactory) {
        super(name, version, creationDate);
        this.repositoryFactory = repositoryFactory;
        this.xuMBeanUtil = repositoryFactory.getXUMBeanUtil();
        this.mbeanManager = repositoryFactory.getMBeanFactory().getMBeanManager();
        this.ruleAppMBean = repositoryFactory.getMBeanFactory().createRuleAppMBean(this);
    }

    public ObjectName getObjectName() {
        return this.objectname;
    }

    public IlrJMXRuleAppMBean getMBean() {
        return this.ruleAppMBean;
    }

    public IlrJMXRepositoryFactoryImpl getRepositoryFactory() {
        return this.repositoryFactory;
    }

    private void notifyRulesetPropertiesChanged(String key, String value) {
        if (this.getRepository() == null || !((IlrJMXMutableRepositoryImpl)this.getRepository()).mustSendNotif()) {
            return;
        }
        Notification notif = this.createPropertyChangeNotification(key, value);
        if (this.xuMBeanUtil.getXuManager() != null) {
            this.xuMBeanUtil.getXuManager().notifyFineRulesetArchiveChange(notif);
        }
        if (notif != null) {
            ((IlrNotificationMBean)((Object)this.ruleAppMBean)).sendNotif(notif);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Notification createPropertyChangeNotification(String key, String value) {
        if (this.repository == null) {
            return null;
        }
        IlrMutableRepositoryImpl ilrMutableRepositoryImpl = this.repository;
        synchronized (ilrMutableRepositoryImpl) {
            if (this.objectname == null) {
                return null;
            }
            Notification n = new Notification("ilog.ruleapp.property.change", (Object)this.objectname, this.sequenceNumber++, key);
            n.setUserData(value);
            return n;
        }
    }

    @Override
    public void setProperty(String key, String value) throws IlrResourceRuntimeException {
        super.setProperty(key, value);
        this.notifyRulesetPropertiesChanged(key, value);
    }

    @Override
    protected void linked(IlrMutableRepositoryImpl newRepository, boolean propertiesLoaded) {
        super.linked(newRepository, propertiesLoaded);
        if (newRepository != null) {
            Properties properties = new Properties();
            properties.setProperty("Name", this.name);
            properties.setProperty("Version", this.version.toString());
            try {
                this.objectname = this.mbeanManager.registerMBean("IlrJMXRuleApp", properties, this.ruleAppMBean);
            }
            catch (Throwable e) {
                logger.severe(IlrLogHelper.registerMBeanError("IlrJMXRuleApp", properties, this.ruleAppMBean), null, e);
            }
        } else {
            try {
                if (this.objectname != null) {
                    this.mbeanManager.unregisterMBean(this.objectname);
                }
                this.objectname = null;
            }
            catch (InstanceNotFoundException e) {
                logger.log(Level.FINER, "UnregisterMBean failed due to InstanceNotFoundException on " + this.objectname, null, e);
            }
            catch (Throwable e) {
                logger.severe(IlrLogHelper.unregisterMBeanError(this.objectname), null, e);
            }
        }
    }
}

