/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.model.mbean;

import com.ibm.rules.res.logging.internal.RESLogger;
import com.ibm.rules.res.message.internal.XXMessageCode;
import ilog.rules.archive.IlrRulesetArchive;
import ilog.rules.res.mbean.util.IlrMBeanManager;
import ilog.rules.res.mbean.util.InvocationResult;
import ilog.rules.res.model.IlrEngineType;
import ilog.rules.res.model.IlrResourceRuntimeException;
import ilog.rules.res.model.IlrVersion;
import ilog.rules.res.model.internal.IlrMutableRuleAppInformationImpl;
import ilog.rules.res.model.internal.IlrMutableRulesetArchiveInformationImpl;
import ilog.rules.res.model.mbean.IlrJMXMutableRepositoryImpl;
import ilog.rules.res.model.mbean.IlrJMXRepositoryFactoryImpl;
import ilog.rules.res.model.mbean.IlrJMXRulesetMBean;
import ilog.rules.res.model.mbean.IlrLogHelper;
import ilog.rules.res.model.mbean.IlrNotificationMBean;
import ilog.rules.res.model.mbean.IlrXUMBeanUtil;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.management.InstanceNotFoundException;
import javax.management.Notification;
import javax.management.ObjectName;

public class IlrJMXMutableRulesetArchiveInformationImpl
extends IlrMutableRulesetArchiveInformationImpl {
    private static final RESLogger logger = RESLogger.getRESLogger("com.ibm.rules.res.mbean", "com.ibm.rules.res.common");
    private final IlrMBeanManager mbeanManager;
    private ObjectName objectname;
    private final IlrJMXRulesetMBean rulesetMBean;
    private final IlrXUMBeanUtil xuMBeanUtil;
    private long sequenceNumber = 1L;
    private IlrJMXMutableRepositoryImpl repository;

    protected IlrJMXMutableRulesetArchiveInformationImpl(String name, IlrVersion version, Date creationDate, IlrJMXRepositoryFactoryImpl repositoryFactory) {
        super(name, version, creationDate);
        this.xuMBeanUtil = repositoryFactory.getXUMBeanUtil();
        this.mbeanManager = repositoryFactory.getMBeanFactory().getMBeanManager();
        this.rulesetMBean = repositoryFactory.getMBeanFactory().createRulesetMBean(this);
    }

    public ObjectName getObjectName() {
        return this.objectname;
    }

    public IlrJMXRulesetMBean getMBean() {
        return this.rulesetMBean;
    }

    protected Map<String, long[]> getUnifiedStatistics() {
        List<InvocationResult> stats = this.xuMBeanUtil.getStatistics(this.getCanonicalPath().toString());
        return IlrXUMBeanUtil.getUnifiedStatistics(stats);
    }

    protected void resetStatistics() {
        this.xuMBeanUtil.resetStatistics(this.getCanonicalPath().toString());
    }

    private void notifyRulesetAdded() {
        if (this.repository == null || !this.repository.mustSendNotif()) {
            return;
        }
        this.xuMBeanUtil.notifyRulesetArchiveChanged(this.getCanonicalPath().toString());
        logger.info(XXMessageCode.INFO_NOTIF_RULESET_ADDED, new String[]{this.getCanonicalPath().toString()}, null);
    }

    private void notifyRulesetArchiveChanged() {
        if (this.repository == null || !this.repository.mustSendNotif()) {
            return;
        }
        this.xuMBeanUtil.notifyRulesetArchiveChanged(this.getCanonicalPath().toString());
        Notification notif = this.createArchiveChangeNotification();
        if (notif != null) {
            ((IlrNotificationMBean)((Object)this.rulesetMBean)).sendNotif(notif);
        }
        logger.info(XXMessageCode.INFO_NOTIF_RULESET_ARCHIVE_CHANGED, new String[]{this.getCanonicalPath().toString()}, null);
    }

    private void notifyRulesetPropertiesChanged(String key, String value) {
        if (this.repository == null || !this.repository.mustSendNotif()) {
            return;
        }
        this.xuMBeanUtil.notifyRulesetArchiveChanged(this.getCanonicalPath().toString());
        Notification notif = this.createPropertyChangeNotification(key, value);
        if (notif != null) {
            ((IlrNotificationMBean)((Object)this.rulesetMBean)).sendNotif(notif);
        }
        logger.info(XXMessageCode.INFO_NOTIF_RULESET_PROPERTIES_CHANGED, new String[]{this.getCanonicalPath().toString()}, null);
    }

    private void notifyRulesetRemoved(String canonicalRulesetPath) {
        this.xuMBeanUtil.notifyRulesetArchiveChanged(canonicalRulesetPath);
        logger.info(XXMessageCode.INFO_NOTIF_RULESET_REMOVED, new String[]{canonicalRulesetPath}, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Notification createArchiveChangeNotification() {
        if (this.repository == null) {
            return null;
        }
        IlrJMXMutableRepositoryImpl ilrJMXMutableRepositoryImpl = this.repository;
        synchronized (ilrJMXMutableRepositoryImpl) {
            if (this.objectname == null) {
                return null;
            }
            return new Notification("ilog.ruleset.rulesetarchive.change", this.objectname, this.sequenceNumber++);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Notification createPropertyChangeNotification(String key, String value) {
        if (this.repository == null) {
            return null;
        }
        IlrJMXMutableRepositoryImpl ilrJMXMutableRepositoryImpl = this.repository;
        synchronized (ilrJMXMutableRepositoryImpl) {
            if (this.objectname == null) {
                return null;
            }
            Notification n = new Notification("ilog.ruleset.property.change", (Object)this.objectname, this.sequenceNumber++, key);
            n.setUserData(value);
            return n;
        }
    }

    @Override
    @Deprecated
    public void setRulesetArchive(IlrRulesetArchive rulesetArchive) {
        super.setRulesetArchive(rulesetArchive);
        this.notifyRulesetArchiveChanged();
    }

    @Override
    public void setRESRulesetArchive(IlrEngineType engineType, InputStream content) {
        super.setRESRulesetArchive(engineType, content);
        this.notifyRulesetArchiveChanged();
    }

    @Override
    public void setProperty(String key, String value) throws IlrResourceRuntimeException {
        super.setProperty(key, value);
        this.notifyRulesetPropertiesChanged(key, value);
    }

    @Override
    protected void linked(IlrMutableRuleAppInformationImpl newRuleApp, boolean propertiesLoaded) {
        String currentPath = this.toString();
        super.linked(newRuleApp, propertiesLoaded);
        if (newRuleApp != null && newRuleApp.getRepository() != null) {
            this.repository = (IlrJMXMutableRepositoryImpl)this.getRepository();
            this.notifyRulesetAdded();
            Properties properties = new Properties();
            properties.setProperty("RelatedRuleAppName", newRuleApp.getName());
            properties.setProperty("RelatedRuleAppVersion", newRuleApp.getVersion().toString());
            properties.setProperty("Name", this.name);
            properties.setProperty("Version", this.version.toString());
            try {
                this.objectname = this.mbeanManager.registerMBean("IlrJMXRuleset", properties, this.rulesetMBean);
            }
            catch (Throwable e) {
                logger.severe(IlrLogHelper.registerMBeanError("IlrJMXRuleset", properties, this.rulesetMBean), null, e);
            }
        } else if (newRuleApp == null && this.repository != null || newRuleApp != null && newRuleApp.getRepository() == null && this.repository != null) {
            if (this.repository.mustSendNotif()) {
                this.notifyRulesetRemoved(currentPath);
            }
            this.repository = null;
            try {
                if (this.objectname != null) {
                    this.mbeanManager.unregisterMBean(this.objectname);
                }
                this.objectname = null;
            }
            catch (InstanceNotFoundException e) {
                logger.log(Level.FINER, "UnregisterMBean failed due to InstanceNotFoundException on " + this.objectname, null, e);
            }
            catch (Throwable e) {
                logger.severe(IlrLogHelper.unregisterMBeanError(this.objectname), null, e);
            }
        }
    }
}

