/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.model.mbean;

import ilog.rules.res.model.IlrAlreadyExistException;
import ilog.rules.res.model.IlrFormatException;
import ilog.rules.res.model.IlrIllegalArgumentRuntimeException;
import ilog.rules.res.model.IlrMutableRuleAppInformation;
import ilog.rules.res.model.IlrRepositoryException;
import ilog.rules.res.model.IlrResourceRuntimeException;
import ilog.rules.res.model.IlrVersion;
import ilog.rules.res.model.internal.IlrDeploymentOperation;
import ilog.rules.res.model.internal.IlrDeploymentReport;
import ilog.rules.res.model.internal.IlrRuleAppsDeployer;
import ilog.rules.res.model.mbean.IlrJMXMutableRepositoryImpl;
import ilog.rules.res.model.mbean.IlrJMXMutableRuleAppInformationImpl;
import ilog.rules.res.model.mbean.IlrJMXRepositoryFactoryImpl;
import ilog.rules.res.model.mbean.IlrJMXRepositoryMBean;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarInputStream;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InvalidAttributeValueException;
import javax.management.ObjectName;
import javax.management.OperationsException;

public class IlrJMXRepository
implements IlrJMXRepositoryMBean {
    private IlrJMXRepositoryFactoryImpl repositoryFactory;
    private IlrJMXMutableRepositoryImpl repository;

    public IlrJMXRepository(IlrJMXMutableRepositoryImpl repository) {
        this.repositoryFactory = repository.getRepositoryFactory();
        this.repository = repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ObjectName> getRuleAppObjectNames() {
        IlrJMXMutableRepositoryImpl ilrJMXMutableRepositoryImpl = this.repository;
        synchronized (ilrJMXMutableRepositoryImpl) {
            Set<IlrMutableRuleAppInformation> ruleApps = this.repository.getRuleApps();
            return this.objectToObjectName(ruleApps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ObjectName> getRuleAppObjectNames(String ruleAppName) {
        IlrJMXMutableRepositoryImpl ilrJMXMutableRepositoryImpl = this.repository;
        synchronized (ilrJMXMutableRepositoryImpl) {
            Set<IlrMutableRuleAppInformation> ruleApps = this.repository.getRuleApps(ruleAppName);
            return this.objectToObjectName(ruleApps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectName getGreatestRuleAppObjectName(String ruleAppName) {
        IlrJMXMutableRepositoryImpl ilrJMXMutableRepositoryImpl = this.repository;
        synchronized (ilrJMXMutableRepositoryImpl) {
            IlrJMXMutableRuleAppInformationImpl ruleApp = (IlrJMXMutableRuleAppInformationImpl)this.repository.getGreatestRuleApp(ruleAppName);
            if (ruleApp != null) {
                return ruleApp.getObjectName();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectName getRuleAppObjectName(String ruleAppName, String ruleAppVersion) {
        try {
            IlrVersion version = IlrVersion.parseVersion(ruleAppVersion);
            IlrJMXMutableRepositoryImpl ilrJMXMutableRepositoryImpl = this.repository;
            synchronized (ilrJMXMutableRepositoryImpl) {
                IlrJMXMutableRuleAppInformationImpl ruleApp = (IlrJMXMutableRuleAppInformationImpl)this.repository.getRuleApp(ruleAppName, version);
                if (ruleApp != null) {
                    return ruleApp.getObjectName();
                }
            }
            return null;
        }
        catch (IlrFormatException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectName addRuleApp(String ruleAppName, String ruleAppVersion) throws InstanceAlreadyExistsException, InvalidAttributeValueException, OperationsException {
        try {
            IlrVersion version = IlrVersion.parseVersion(ruleAppVersion);
            IlrJMXMutableRuleAppInformationImpl ruleApp = (IlrJMXMutableRuleAppInformationImpl)this.repositoryFactory.createRuleApp(ruleAppName, version);
            IlrJMXMutableRepositoryImpl ilrJMXMutableRepositoryImpl = this.repository;
            synchronized (ilrJMXMutableRepositoryImpl) {
                this.repository.addRuleApp(ruleApp);
                return ruleApp.getObjectName();
            }
        }
        catch (IlrFormatException e) {
            throw new InvalidAttributeValueException(e.getMessage());
        }
        catch (IlrIllegalArgumentRuntimeException e) {
            throw new InvalidAttributeValueException(e.getMessage());
        }
        catch (IlrAlreadyExistException e) {
            throw new InstanceAlreadyExistsException(e.getMessage());
        }
        catch (IlrResourceRuntimeException e) {
            throw new OperationsException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeRuleApp(String ruleAppName, String ruleAppVersion) throws OperationsException {
        try {
            IlrVersion version = IlrVersion.parseVersion(ruleAppVersion);
            IlrJMXMutableRepositoryImpl ilrJMXMutableRepositoryImpl = this.repository;
            synchronized (ilrJMXMutableRepositoryImpl) {
                return this.repository.removeRuleApp(this.repository.getRuleApp(ruleAppName, version));
            }
        }
        catch (IlrResourceRuntimeException e) {
            throw new OperationsException(e.getMessage());
        }
        catch (IlrFormatException ilrFormatException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ObjectName> importRuleApps(byte[] ruleAppArchive, String mergingPolicy, String versioningPolicy) throws IOException, InvalidAttributeValueException, OperationsException {
        try {
            JarInputStream inputStream = null;
            if (ruleAppArchive != null) {
                ByteArrayInputStream bytes = new ByteArrayInputStream(ruleAppArchive);
                inputStream = new JarInputStream(bytes);
            }
            Set<IlrMutableRuleAppInformation> ruleApps = this.repositoryFactory.getArchiveManager().read(this.repositoryFactory, inputStream);
            HashSet<ObjectName> result = new HashSet<ObjectName>();
            IlrRuleAppsDeployer deployer = new IlrRuleAppsDeployer();
            IlrJMXMutableRepositoryImpl ilrJMXMutableRepositoryImpl = this.repository;
            synchronized (ilrJMXMutableRepositoryImpl) {
                IlrDeploymentReport report = deployer.deploy(this.repository, mergingPolicy, versioningPolicy, ruleApps);
                for (IlrDeploymentOperation op : report.getOperations()) {
                    IlrVersion raVersion;
                    String raName;
                    IlrJMXMutableRuleAppInformationImpl ruleApp;
                    if (!op.getPath().isRuleAppPath() || op.getOperationType() == 0 || (ruleApp = (IlrJMXMutableRuleAppInformationImpl)this.repository.getRuleApp(raName = op.getPath().getRuleAppName(), raVersion = op.getResult().getRuleAppVersion())) == null) continue;
                    result.add(ruleApp.getObjectName());
                }
            }
            return result;
        }
        catch (IlrResourceRuntimeException e) {
            throw new OperationsException(e.getMessage());
        }
        catch (IlrIllegalArgumentRuntimeException e) {
            throw new InvalidAttributeValueException(e.getMessage());
        }
        catch (IlrRepositoryException e) {
            throw new OperationsException(e.getMessage());
        }
    }

    @Override
    public long getWarningCount() {
        return this.repository.getWarningCount();
    }

    @Override
    public long getErrorCount() {
        return this.repository.getErrorCount();
    }

    @Override
    public void resetWarningCount() {
        this.repository.resetWarningCount();
    }

    @Override
    public void resetErrorCount() {
        this.repository.resetErrorCount();
    }

    private Set<ObjectName> objectToObjectName(Set<IlrMutableRuleAppInformation> ruleApps) {
        HashSet<ObjectName> result = new HashSet<ObjectName>();
        for (IlrMutableRuleAppInformation ruleApp : ruleApps) {
            result.add(((IlrJMXMutableRuleAppInformationImpl)ruleApp).getObjectName());
        }
        return result;
    }
}

