/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.model.mbean;

import com.ibm.rules.res.message.internal.XXMessageCode;
import ilog.rules.res.model.IlrFormatException;
import ilog.rules.res.model.IlrIllegalArgumentRuntimeException;
import ilog.rules.res.model.IlrMutableRepository;
import ilog.rules.res.model.IlrMutableRuleAppInformation;
import ilog.rules.res.model.IlrMutableRulesetArchiveInformation;
import ilog.rules.res.model.IlrResourceRuntimeException;
import ilog.rules.res.model.IlrVersion;
import ilog.rules.res.model.archive.IlrArchiveManager;
import ilog.rules.res.model.internal.IlrRepositoryFactoryImpl;
import ilog.rules.res.model.mbean.IlrDSMBeanUtil;
import ilog.rules.res.model.mbean.IlrJMXMutableRepositoryImpl;
import ilog.rules.res.model.mbean.IlrJMXMutableRuleAppInformationImpl;
import ilog.rules.res.model.mbean.IlrJMXMutableRulesetArchiveInformationImpl;
import ilog.rules.res.model.mbean.IlrMBeanFactory;
import ilog.rules.res.model.mbean.IlrXUMBeanUtil;
import ilog.rules.res.persistence.IlrRepositoryDAO;
import java.util.Date;
import java.util.Set;

public class IlrJMXRepositoryFactoryImpl
extends IlrRepositoryFactoryImpl {
    private static final long serialVersionUID = 1L;
    private transient IlrMBeanFactory mbeanFactory;
    private transient IlrXUMBeanUtil xuMBeanUtil;
    private transient IlrDSMBeanUtil dsMBeanUtil;
    private transient IlrArchiveManager archiveManager;

    public IlrJMXRepositoryFactoryImpl(IlrMBeanFactory mbeanFactory) {
        if (mbeanFactory == null) {
            throw new IlrIllegalArgumentRuntimeException("com.ibm.rules.res.common", XXMessageCode.ERROR_MBEAN_FACTORY_NULL);
        }
        this.mbeanFactory = mbeanFactory;
        this.xuMBeanUtil = new IlrXUMBeanUtil(mbeanFactory.getMBeanManager(), mbeanFactory.getXUManager());
        this.dsMBeanUtil = new IlrDSMBeanUtil(mbeanFactory.getMBeanManager());
        this.archiveManager = new IlrArchiveManager();
    }

    @Override
    public IlrMutableRepository createRepository() {
        return new IlrJMXMutableRepositoryImpl(this);
    }

    @Override
    public IlrMutableRepository createRepository(IlrRepositoryDAO repositoryDAO) throws IlrResourceRuntimeException, IlrIllegalArgumentRuntimeException {
        Set<IlrMutableRuleAppInformation> ruleApps = this.loadRepository(repositoryDAO);
        return new IlrJMXMutableRepositoryImpl(this, repositoryDAO, ruleApps);
    }

    @Override
    public IlrMutableRuleAppInformation createRuleApp(String name, IlrVersion version, Date creationDate) throws IlrFormatException, IlrIllegalArgumentRuntimeException {
        this.checkRuleAppParameters(name, version, creationDate);
        return new IlrJMXMutableRuleAppInformationImpl(name, version, creationDate, this);
    }

    @Override
    public IlrMutableRulesetArchiveInformation createRuleset(String name, IlrVersion version, Date creationDate) throws IlrFormatException, IlrIllegalArgumentRuntimeException {
        this.checkRulesetParameters(name, version, creationDate);
        return new IlrJMXMutableRulesetArchiveInformationImpl(name, version, creationDate, this);
    }

    public IlrMBeanFactory getMBeanFactory() {
        return this.mbeanFactory;
    }

    public IlrArchiveManager getArchiveManager() {
        return this.archiveManager;
    }

    public IlrXUMBeanUtil getXUMBeanUtil() {
        return this.xuMBeanUtil;
    }

    public IlrDSMBeanUtil getDSMBeanUtil() {
        return this.dsMBeanUtil;
    }
}

