/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.model.mbean;

import ilog.rules.archive.IlrRulesetArchive;
import ilog.rules.res.model.IlrAlreadyExistException;
import ilog.rules.res.model.IlrEngineType;
import ilog.rules.res.model.IlrFormatException;
import ilog.rules.res.model.IlrIllegalArgumentRuntimeException;
import ilog.rules.res.model.IlrMutableRepository;
import ilog.rules.res.model.IlrMutableRulesetArchiveInformation;
import ilog.rules.res.model.IlrRepositoryRuntimeException;
import ilog.rules.res.model.IlrResourceRuntimeException;
import ilog.rules.res.model.IlrVersion;
import ilog.rules.res.model.archive.IlrArchiveException;
import ilog.rules.res.model.internal.IlrRuleAppPropertiesImpl;
import ilog.rules.res.model.mbean.IlrJMXMutableRepositoryImpl;
import ilog.rules.res.model.mbean.IlrJMXMutableRuleAppInformationImpl;
import ilog.rules.res.model.mbean.IlrJMXMutableRulesetArchiveInformationImpl;
import ilog.rules.res.model.mbean.IlrJMXRepositoryFactoryImpl;
import ilog.rules.res.model.mbean.IlrJMXRuleAppMBean;
import ilog.rules.res.model.mbean.IlrNotificationMBean;
import ilog.rules.res.util.IlrRulesetArchiveExtractor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.RuntimeOperationsException;

public class IlrJMXRuleApp
extends NotificationBroadcasterSupport
implements IlrJMXRuleAppMBean,
IlrNotificationMBean {
    private final IlrJMXRepositoryFactoryImpl repositoryFactory;
    private final IlrJMXMutableRuleAppInformationImpl ruleApp;

    public IlrJMXRuleApp(IlrJMXMutableRuleAppInformationImpl ruleApp) {
        this.repositoryFactory = ruleApp.getRepositoryFactory();
        this.ruleApp = ruleApp;
    }

    @Override
    @Deprecated
    public ObjectName getModelObjectName() {
        return this.getRepositoryObjectName();
    }

    @Override
    public ObjectName getRepositoryObjectName() {
        return ((IlrJMXMutableRepositoryImpl)this.ruleApp.getRepository()).getObjectName();
    }

    @Override
    public String getName() {
        return this.ruleApp.getName();
    }

    @Override
    public String getVersion() {
        return this.ruleApp.getVersion().toString();
    }

    @Override
    public long getCreationDate() {
        return this.ruleApp.getCreationDate().getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDisplayName() {
        IlrMutableRepository ilrMutableRepository = this.ruleApp.getRepository();
        synchronized (ilrMutableRepository) {
            return this.ruleApp.getDisplayName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDisplayName(String displayName) {
        IlrMutableRepository ilrMutableRepository = this.ruleApp.getRepository();
        synchronized (ilrMutableRepository) {
            try {
                this.ruleApp.setDisplayName(displayName);
            }
            catch (IlrResourceRuntimeException e) {
                throw new RuntimeOperationsException(null, e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDescription() {
        IlrMutableRepository ilrMutableRepository = this.ruleApp.getRepository();
        synchronized (ilrMutableRepository) {
            return this.ruleApp.getDescription();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDescription(String description) {
        IlrMutableRepository ilrMutableRepository = this.ruleApp.getRepository();
        synchronized (ilrMutableRepository) {
            try {
                this.ruleApp.setDescription(description);
            }
            catch (IlrResourceRuntimeException e) {
                throw new RuntimeOperationsException(null, e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ObjectName> getRulesetObjectNames() {
        IlrMutableRepository ilrMutableRepository = this.ruleApp.getRepository();
        synchronized (ilrMutableRepository) {
            Set<IlrMutableRulesetArchiveInformation> rulesets = this.ruleApp.getRulesets();
            return this.objectToObjectName(rulesets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ObjectName> getRulesetObjectNames(String rulesetName) {
        IlrMutableRepository ilrMutableRepository = this.ruleApp.getRepository();
        synchronized (ilrMutableRepository) {
            Set<IlrMutableRulesetArchiveInformation> rulesets = this.ruleApp.getRulesets(rulesetName);
            return this.objectToObjectName(rulesets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectName getGreatestRulesetObjectName(String rulesetName) {
        IlrMutableRepository ilrMutableRepository = this.ruleApp.getRepository();
        synchronized (ilrMutableRepository) {
            IlrJMXMutableRulesetArchiveInformationImpl ruleset = (IlrJMXMutableRulesetArchiveInformationImpl)this.ruleApp.getGreatestRuleset(rulesetName);
            if (ruleset != null) {
                return ruleset.getObjectName();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectName getRulesetObjectName(String rulesetName, String rulesetVersion) {
        try {
            IlrVersion version = IlrVersion.parseVersion(rulesetVersion);
            IlrMutableRepository ilrMutableRepository = this.ruleApp.getRepository();
            synchronized (ilrMutableRepository) {
                IlrJMXMutableRulesetArchiveInformationImpl ruleset = (IlrJMXMutableRulesetArchiveInformationImpl)this.ruleApp.getRuleset(rulesetName, version);
                if (ruleset != null) {
                    return ruleset.getObjectName();
                }
            }
            return null;
        }
        catch (IlrFormatException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public ObjectName addRuleset(String rulesetName, String rulesetVersion, byte[] rulesetArchive) throws InstanceAlreadyExistsException, InvalidAttributeValueException, OperationsException {
        IlrRulesetArchive archive = null;
        if (rulesetArchive != null) {
            try {
                archive = IlrRulesetArchiveExtractor.extract(new ByteArrayInputStream(rulesetArchive));
            }
            catch (Exception e) {
                throw new OperationsException(e.getMessage());
            }
        }
        try {
            IlrVersion version = IlrVersion.parseVersion(rulesetVersion);
            IlrJMXMutableRulesetArchiveInformationImpl ruleset = (IlrJMXMutableRulesetArchiveInformationImpl)this.repositoryFactory.createRuleset(rulesetName, version);
            ruleset.setRulesetArchive(archive);
            IlrMutableRepository ilrMutableRepository = this.ruleApp.getRepository();
            synchronized (ilrMutableRepository) {
                this.ruleApp.addRuleset(ruleset);
                return ruleset.getObjectName();
            }
        }
        catch (IlrFormatException e) {
            throw new InvalidAttributeValueException(e.getMessage());
        }
        catch (IlrIllegalArgumentRuntimeException e) {
            throw new InvalidAttributeValueException(e.getMessage());
        }
        catch (IlrAlreadyExistException e) {
            throw new InstanceAlreadyExistsException(e.getMessage());
        }
        catch (IlrResourceRuntimeException e) {
            throw new OperationsException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectName addRuleset(String rulesetName, String rulesetVersion, String engineType, byte[] rulesetArchive) throws InstanceAlreadyExistsException, InvalidAttributeValueException, OperationsException {
        try {
            IlrVersion version = IlrVersion.parseVersion(rulesetVersion);
            IlrJMXMutableRulesetArchiveInformationImpl ruleset = (IlrJMXMutableRulesetArchiveInformationImpl)this.repositoryFactory.createRuleset(rulesetName, version);
            IlrEngineType type = IlrEngineType.toEngineType(engineType);
            if (rulesetArchive != null) {
                ruleset.setRESRulesetArchive(type, new ByteArrayInputStream(rulesetArchive));
            } else {
                ruleset.setRESRulesetArchive(type, null);
            }
            IlrMutableRepository ilrMutableRepository = this.ruleApp.getRepository();
            synchronized (ilrMutableRepository) {
                this.ruleApp.addRuleset(ruleset);
                return ruleset.getObjectName();
            }
        }
        catch (IllegalArgumentException e) {
            throw new InvalidAttributeValueException(e.getMessage());
        }
        catch (IlrFormatException e) {
            throw new InvalidAttributeValueException(e.getMessage());
        }
        catch (IlrIllegalArgumentRuntimeException e) {
            throw new InvalidAttributeValueException(e.getMessage());
        }
        catch (IlrAlreadyExistException e) {
            throw new InstanceAlreadyExistsException(e.getMessage());
        }
        catch (IlrResourceRuntimeException e) {
            throw new OperationsException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeRuleset(String rulesetName, String rulesetVersion) throws OperationsException {
        try {
            IlrVersion version = IlrVersion.parseVersion(rulesetVersion);
            IlrMutableRepository ilrMutableRepository = this.ruleApp.getRepository();
            synchronized (ilrMutableRepository) {
                return this.ruleApp.removeRuleset(this.ruleApp.getRuleset(rulesetName, version));
            }
        }
        catch (IlrRepositoryRuntimeException e) {
            throw new OperationsException(e.getMessage());
        }
        catch (IlrFormatException ilrFormatException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getProperty(String key) throws OperationsException {
        try {
            IlrMutableRepository ilrMutableRepository = this.ruleApp.getRepository();
            synchronized (ilrMutableRepository) {
                return (String)this.ruleApp.getProperties().get(key);
            }
        }
        catch (IlrRepositoryRuntimeException e) {
            throw new OperationsException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getProperties() throws OperationsException {
        try {
            Properties result;
            IlrMutableRepository ilrMutableRepository = this.ruleApp.getRepository();
            synchronized (ilrMutableRepository) {
                IlrRuleAppPropertiesImpl props = (IlrRuleAppPropertiesImpl)this.ruleApp.getProperties();
                Properties defaults = null;
                if (props.getDefaultProperties() != null) {
                    defaults = new Properties();
                    defaults.putAll(props.getDefaultProperties());
                }
                result = new Properties(defaults);
                for (Map.Entry<String, String> entry : props.entrySet()) {
                    result.setProperty(entry.getKey(), entry.getValue());
                }
            }
            return result;
        }
        catch (IlrRepositoryRuntimeException e) {
            throw new OperationsException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperty(String key, String value) throws OperationsException {
        try {
            IlrMutableRepository ilrMutableRepository = this.ruleApp.getRepository();
            synchronized (ilrMutableRepository) {
                this.ruleApp.setProperty(key, value);
            }
        }
        catch (IlrRepositoryRuntimeException e) {
            throw new OperationsException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] export() throws OperationsException {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            IlrMutableRepository ilrMutableRepository = this.ruleApp.getRepository();
            synchronized (ilrMutableRepository) {
                this.repositoryFactory.getArchiveManager().write((OutputStream)outputStream, this.ruleApp);
            }
            return outputStream.toByteArray();
        }
        catch (IOException e) {
            throw new OperationsException(e.getMessage());
        }
        catch (IlrArchiveException e) {
            throw new OperationsException(e.getMessage());
        }
        catch (IlrIllegalArgumentRuntimeException e) {
            throw new InvalidAttributeValueException(e.getMessage());
        }
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo propertyChange = new MBeanNotificationInfo(new String[]{"ilog.ruleapp.property.change"}, Notification.class.getName(), "Notify listeners that a property was changed. The notification contains key and new value of the property.");
        return new MBeanNotificationInfo[]{propertyChange};
    }

    @Override
    public void sendNotif(Notification notification) {
        this.sendNotification(notification);
    }

    private Set<ObjectName> objectToObjectName(Set<IlrMutableRulesetArchiveInformation> rulesets) {
        HashSet<ObjectName> result = new HashSet<ObjectName>();
        for (IlrMutableRulesetArchiveInformation ruleset : rulesets) {
            result.add(((IlrJMXMutableRulesetArchiveInformationImpl)ruleset).getObjectName());
        }
        return result;
    }
}

