/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.model.mbean;

import ilog.rules.archive.IlrRulesetArchive;
import ilog.rules.res.model.IlrEngineType;
import ilog.rules.res.model.IlrMutableRepository;
import ilog.rules.res.model.IlrRESRulesetArchive;
import ilog.rules.res.model.IlrRepositoryRuntimeException;
import ilog.rules.res.model.IlrResourceRuntimeException;
import ilog.rules.res.model.internal.IlrRESArchiveUtil;
import ilog.rules.res.model.internal.IlrRulesetArchivePropertiesImpl;
import ilog.rules.res.model.mbean.IlrJMXMutableRepositoryImpl;
import ilog.rules.res.model.mbean.IlrJMXMutableRuleAppInformationImpl;
import ilog.rules.res.model.mbean.IlrJMXMutableRulesetArchiveInformationImpl;
import ilog.rules.res.model.mbean.IlrJMXRulesetMBean;
import ilog.rules.res.model.mbean.IlrNotificationMBean;
import ilog.rules.res.util.IlrRulesetArchiveExtractor;
import ilog.rules.res.xu.management.IlrXUStatistics;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarOutputStream;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.RuntimeOperationsException;

public class IlrJMXRuleset
extends NotificationBroadcasterSupport
implements IlrJMXRulesetMBean,
IlrNotificationMBean {
    protected IlrJMXMutableRulesetArchiveInformationImpl ruleset;

    public IlrJMXRuleset(IlrJMXMutableRulesetArchiveInformationImpl ruleset) {
        this.ruleset = ruleset;
    }

    @Override
    @Deprecated
    public ObjectName getModelObjectName() {
        return this.getRepositoryObjectName();
    }

    @Override
    public ObjectName getRepositoryObjectName() {
        return ((IlrJMXMutableRepositoryImpl)this.ruleset.getRepository()).getObjectName();
    }

    @Override
    public ObjectName getParentRuleAppObjectName() {
        IlrJMXMutableRuleAppInformationImpl ruleApp = (IlrJMXMutableRuleAppInformationImpl)this.ruleset.getRuleApp();
        return ruleApp.getObjectName();
    }

    @Override
    public String getName() {
        return this.ruleset.getName();
    }

    @Override
    public String getVersion() {
        return this.ruleset.getVersion().toString();
    }

    @Override
    public long getCreationDate() {
        return this.ruleset.getCreationDate().getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDisplayName() {
        IlrMutableRepository ilrMutableRepository = this.ruleset.getRepository();
        synchronized (ilrMutableRepository) {
            return this.ruleset.getDisplayName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDisplayName(String displayName) {
        IlrMutableRepository ilrMutableRepository = this.ruleset.getRepository();
        synchronized (ilrMutableRepository) {
            try {
                this.ruleset.setDisplayName(displayName);
            }
            catch (IlrResourceRuntimeException e) {
                throw new RuntimeOperationsException(null, e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDescription() {
        IlrMutableRepository ilrMutableRepository = this.ruleset.getRepository();
        synchronized (ilrMutableRepository) {
            return this.ruleset.getDescription();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDescription(String description) {
        IlrMutableRepository ilrMutableRepository = this.ruleset.getRepository();
        synchronized (ilrMutableRepository) {
            try {
                this.ruleset.setDescription(description);
            }
            catch (IlrResourceRuntimeException e) {
                throw new RuntimeOperationsException(null, e.getMessage());
            }
        }
    }

    @Override
    public String getCanonicalRulesetPath() {
        return this.ruleset.getCanonicalPath().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStatus() throws OperationsException {
        try {
            IlrMutableRepository ilrMutableRepository = this.ruleset.getRepository();
            synchronized (ilrMutableRepository) {
                return this.ruleset.getProperties().getStatus();
            }
        }
        catch (IlrRepositoryRuntimeException e) {
            throw new OperationsException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatus(String status) throws OperationsException {
        try {
            IlrMutableRepository ilrMutableRepository = this.ruleset.getRepository();
            synchronized (ilrMutableRepository) {
                this.ruleset.setProperty("ruleset.status", status);
            }
        }
        catch (IlrRepositoryRuntimeException e) {
            throw new OperationsException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public synchronized byte[] getRulesetArchive() throws InvalidAttributeValueException, OperationsException {
        try {
            IlrRulesetArchive archive;
            IlrMutableRepository ilrMutableRepository = this.ruleset.getRepository();
            synchronized (ilrMutableRepository) {
                archive = this.ruleset.getRulesetArchive();
            }
            if (archive == null) {
                return null;
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            JarOutputStream jar = new JarOutputStream(outputStream);
            try {
                archive.write(jar);
            }
            finally {
                jar.close();
            }
            return outputStream.toByteArray();
        }
        catch (IlrRepositoryRuntimeException e) {
            throw new OperationsException(e.getMessage());
        }
        catch (IOException e) {
            throw new OperationsException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized byte[] getRESRulesetArchive() throws InvalidAttributeValueException, OperationsException {
        try {
            IlrRESRulesetArchive archive;
            IlrMutableRepository ilrMutableRepository = this.ruleset.getRepository();
            synchronized (ilrMutableRepository) {
                archive = this.ruleset.getRESRulesetArchive();
            }
            if (archive == null) {
                return null;
            }
            return IlrRESArchiveUtil.getRESRulesetArchiveAsBytes(archive);
        }
        catch (IlrRepositoryRuntimeException e) {
            throw new OperationsException(e.getMessage());
        }
        catch (IOException e) {
            throw new OperationsException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public synchronized void setRulesetArchive(byte[] rulesetArchive) throws OperationsException {
        try {
            IlrRulesetArchive archive = null;
            if (rulesetArchive != null) {
                archive = IlrRulesetArchiveExtractor.extract(new ByteArrayInputStream(rulesetArchive));
            }
            IlrMutableRepository ilrMutableRepository = this.ruleset.getRepository();
            synchronized (ilrMutableRepository) {
                this.ruleset.setRulesetArchive(archive);
            }
        }
        catch (Exception e) {
            throw new OperationsException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setRESRulesetArchive(String engineType, byte[] content) throws OperationsException {
        try {
            IlrMutableRepository ilrMutableRepository = this.ruleset.getRepository();
            synchronized (ilrMutableRepository) {
                this.ruleset.setRESRulesetArchive(IlrEngineType.toEngineType(engineType), new ByteArrayInputStream(content));
            }
        }
        catch (Exception e) {
            throw new OperationsException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getProperty(String key) throws OperationsException {
        try {
            IlrMutableRepository ilrMutableRepository = this.ruleset.getRepository();
            synchronized (ilrMutableRepository) {
                return (String)this.ruleset.getProperties().get(key);
            }
        }
        catch (IlrRepositoryRuntimeException e) {
            throw new OperationsException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getProperties() throws OperationsException {
        try {
            Properties result;
            IlrMutableRepository ilrMutableRepository = this.ruleset.getRepository();
            synchronized (ilrMutableRepository) {
                IlrRulesetArchivePropertiesImpl props = (IlrRulesetArchivePropertiesImpl)this.ruleset.getProperties();
                Properties defaults = null;
                if (props.getDefaultProperties() != null) {
                    defaults = new Properties();
                    defaults.putAll(props.getDefaultProperties());
                }
                result = new Properties(defaults);
                for (Map.Entry<String, String> entry : props.entrySet()) {
                    result.setProperty(entry.getKey(), entry.getValue());
                }
            }
            return result;
        }
        catch (IlrRepositoryRuntimeException e) {
            throw new OperationsException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperty(String key, String value) throws OperationsException {
        try {
            IlrMutableRepository ilrMutableRepository = this.ruleset.getRepository();
            synchronized (ilrMutableRepository) {
                this.ruleset.setProperty(key, value);
            }
        }
        catch (IlrRepositoryRuntimeException e) {
            throw new OperationsException(e.getMessage());
        }
    }

    @Override
    public long getExecuteCount() {
        long[] metrics = this.ruleset.getUnifiedStatistics().get("1");
        if (metrics != null) {
            return new IlrXUStatistics(metrics).getNbExecution();
        }
        return -1L;
    }

    @Override
    public long getTotalExecuteTime() {
        long[] metrics = this.ruleset.getUnifiedStatistics().get("1");
        if (metrics != null) {
            return new IlrXUStatistics(metrics).getTotalExecutionTime();
        }
        return -1L;
    }

    @Override
    public double getAverageExecuteTime() {
        long[] metrics = this.ruleset.getUnifiedStatistics().get("1");
        if (metrics != null) {
            return new IlrXUStatistics(metrics).getAverageExecutionTime();
        }
        return -1.0;
    }

    @Override
    public long getMaxExecuteTime() {
        long[] metrics = this.ruleset.getUnifiedStatistics().get("1");
        if (metrics != null) {
            return new IlrXUStatistics(metrics).getMaxExecutionTime();
        }
        return -1L;
    }

    @Override
    public long getMinExecuteTime() {
        long[] metrics = this.ruleset.getUnifiedStatistics().get("1");
        if (metrics != null) {
            return new IlrXUStatistics(metrics).getMinExecutionTime();
        }
        return -1L;
    }

    @Override
    public long getFirstExecuteTime() {
        long[] metrics = this.ruleset.getUnifiedStatistics().get("1");
        if (metrics != null) {
            return new IlrXUStatistics(metrics).getFirstExecutionDate();
        }
        return -1L;
    }

    @Override
    public long getLastExecuteTime() {
        long[] metrics = this.ruleset.getUnifiedStatistics().get("1");
        if (metrics != null) {
            return new IlrXUStatistics(metrics).getLastExecutionDate();
        }
        return -1L;
    }

    @Override
    public long getLastExecuteDuration() {
        long[] metrics = this.ruleset.getUnifiedStatistics().get("1");
        if (metrics != null) {
            return new IlrXUStatistics(metrics).getLastExecutionTime();
        }
        return -1L;
    }

    @Override
    public long getExecuteTaskCount() {
        long[] metrics = this.ruleset.getUnifiedStatistics().get("4");
        if (metrics != null) {
            return new IlrXUStatistics(metrics).getNbExecution();
        }
        return -1L;
    }

    @Override
    public long getTotalExecuteTaskTime() {
        long[] metrics = this.ruleset.getUnifiedStatistics().get("4");
        if (metrics != null) {
            return new IlrXUStatistics(metrics).getTotalExecutionTime();
        }
        return -1L;
    }

    @Override
    public double getAverageExecuteTaskTime() {
        long[] metrics = this.ruleset.getUnifiedStatistics().get("4");
        if (metrics != null) {
            return new IlrXUStatistics(metrics).getAverageExecutionTime();
        }
        return -1.0;
    }

    @Override
    public long getMaxExecuteTaskTime() {
        long[] metrics = this.ruleset.getUnifiedStatistics().get("4");
        if (metrics != null) {
            return new IlrXUStatistics(metrics).getMaxExecutionTime();
        }
        return -1L;
    }

    @Override
    public long getMinExecuteTaskTime() {
        long[] metrics = this.ruleset.getUnifiedStatistics().get("4");
        if (metrics != null) {
            return new IlrXUStatistics(metrics).getMinExecutionTime();
        }
        return -1L;
    }

    @Override
    public long getFirstExecuteTaskTime() {
        long[] metrics = this.ruleset.getUnifiedStatistics().get("4");
        if (metrics != null) {
            return new IlrXUStatistics(metrics).getFirstExecutionDate();
        }
        return -1L;
    }

    @Override
    public long getLastExecuteTaskTime() {
        long[] metrics = this.ruleset.getUnifiedStatistics().get("4");
        if (metrics != null) {
            return new IlrXUStatistics(metrics).getLastExecutionDate();
        }
        return -1L;
    }

    @Override
    public long getLastExecuteTaskDuration() {
        long[] metrics = this.ruleset.getUnifiedStatistics().get("4");
        if (metrics != null) {
            return new IlrXUStatistics(metrics).getLastExecutionTime();
        }
        return -1L;
    }

    @Override
    public void resetStatistics() {
        this.ruleset.resetStatistics();
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo propertyChange = new MBeanNotificationInfo(new String[]{"ilog.ruleset.property.change"}, Notification.class.getName(), "Notify listeners that a property was changed. The notification contains key and new value of the property.");
        MBeanNotificationInfo archiveChange = new MBeanNotificationInfo(new String[]{"ilog.ruleset.rulesetarchive.change"}, Notification.class.getName(), "Notify listeners that the ruleset archive was changed.");
        return new MBeanNotificationInfo[]{propertyChange, archiveChange};
    }

    @Override
    public void sendNotif(Notification notification) {
        this.sendNotification(notification);
    }
}

