/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.model.mbean;

import com.ibm.rules.res.message.internal.XXMessageCode;
import ilog.rules.res.mbean.util.InvocationResult;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.management.ObjectName;

class IlrLogHelper {
    IlrLogHelper() {
    }

    static String getMessage(String messageCode) {
        return IlrLogHelper.getLocalizedMessage(messageCode, null);
    }

    static String getJMXMessage(String messageCode, InvocationResult invocationResult) {
        return IlrLogHelper.getLocalizedMessage(messageCode, new Object[]{invocationResult.getServerInfo(), invocationResult.getObjectName()});
    }

    static String getRulesetPathMessage(String messageCode, String rulesetPath) {
        return IlrLogHelper.getLocalizedMessage(messageCode, new Object[]{rulesetPath});
    }

    static String registerMBeanError(String mbeanType, Properties mbeanProperties, Object mbean) {
        return IlrLogHelper.getLocalizedMessage(XXMessageCode.ERROR_REGISTER_MBEAN_FAILED, new Object[]{mbeanType, mbeanProperties, mbean});
    }

    static String unregisterMBeanError(ObjectName objectName) {
        return IlrLogHelper.getLocalizedMessage(XXMessageCode.ERROR_UNREGISTER_MBEAN_FAILED, new Object[]{objectName});
    }

    private static String getLocalizedMessage(String messageCode, Object[] messageParams) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("com.ibm.rules.res.common");
            if (messageParams == null) {
                return bundle.getString(messageCode);
            }
            MessageFormat formater = new MessageFormat(bundle.getString(messageCode));
            return formater.format(messageParams);
        }
        catch (RuntimeException e) {
            StringBuffer buffer = new StringBuffer("com.ibm.rules.res.common");
            buffer.append(", Message code: ");
            buffer.append(messageCode);
            if (messageParams != null) {
                buffer.append(", parameters: ");
                for (int i = 0; i < messageParams.length; ++i) {
                    buffer.append(messageParams[i]);
                    if (i == messageParams.length - 1) continue;
                    buffer.append(", ");
                }
            }
            return buffer.toString();
        }
    }
}

