/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.model.mbean;

import com.ibm.rules.res.logging.internal.RESLogger;
import com.ibm.rules.res.message.internal.XXMessageCode;
import ilog.rules.res.mbean.util.IlrMBeanManager;
import ilog.rules.res.mbean.util.IlrMBeanManagerFactory;
import ilog.rules.res.model.mbean.IlrJMXMutableRepositoryImpl;
import ilog.rules.res.model.mbean.IlrJMXMutableRuleAppInformationImpl;
import ilog.rules.res.model.mbean.IlrJMXMutableRulesetArchiveInformationImpl;
import ilog.rules.res.model.mbean.IlrJMXRepositoryMBean;
import ilog.rules.res.model.mbean.IlrJMXRuleAppMBean;
import ilog.rules.res.model.mbean.IlrJMXRulesetMBean;
import ilog.rules.res.model.mbean.IlrXUManager;
import ilog.rules.res.model.mbean.websphere.IlrJMXRepository;
import ilog.rules.res.model.mbean.websphere.IlrJMXRuleApp;
import ilog.rules.res.model.mbean.websphere.IlrJMXRuleset;
import java.lang.reflect.Constructor;
import java.util.Properties;
import java.util.logging.Level;

public class IlrMBeanFactory {
    private static final RESLogger logger = RESLogger.getRESLogger("com.ibm.rules.res.mbean", "com.ibm.rules.res.common");
    protected IlrMBeanManagerFactory mbeanManagerFactory;
    protected IlrMBeanManager mbeanManager;
    protected IlrXUManager xuManager;

    public IlrMBeanFactory(Properties properties) throws Exception {
        String xuManagerClassName;
        this.mbeanManagerFactory = new IlrMBeanManagerFactory(properties);
        this.mbeanManager = this.mbeanManagerFactory.createMBeanManager();
        this.mbeanManager.initMBeanManager();
        if (properties != null && (xuManagerClassName = properties.getProperty("ilog.rules.res.XUManagerClass")) != null) {
            try {
                Class<?> xuManagerClass = Class.forName(xuManagerClassName);
                Constructor<?> constr = xuManagerClass.getConstructor(new Class[0]);
                this.xuManager = (IlrXUManager)constr.newInstance(new Object[0]);
            }
            catch (Exception e) {
                logger.log(Level.INFO, XXMessageCode.ERROR_XU_MANAGER_CONSTRUCTION, null, e);
            }
        }
    }

    public IlrMBeanManager getMBeanManager() {
        return this.mbeanManager;
    }

    public IlrXUManager getXUManager() {
        return this.xuManager;
    }

    public IlrJMXRepositoryMBean createRepositoryMBean(IlrJMXMutableRepositoryImpl repository) {
        int jmx_impl = this.mbeanManagerFactory.getJMXImplementation();
        switch (jmx_impl) {
            case 3: {
                return new IlrJMXRepository(repository);
            }
        }
        return new ilog.rules.res.model.mbean.IlrJMXRepository(repository);
    }

    public IlrJMXRuleAppMBean createRuleAppMBean(IlrJMXMutableRuleAppInformationImpl ruleApp) {
        int jmx_impl = this.mbeanManagerFactory.getJMXImplementation();
        switch (jmx_impl) {
            case 3: {
                return new IlrJMXRuleApp(ruleApp);
            }
        }
        return new ilog.rules.res.model.mbean.IlrJMXRuleApp(ruleApp);
    }

    public IlrJMXRulesetMBean createRulesetMBean(IlrJMXMutableRulesetArchiveInformationImpl ruleset) {
        int jmx_impl = this.mbeanManagerFactory.getJMXImplementation();
        switch (jmx_impl) {
            case 3: {
                return new IlrJMXRuleset(ruleset);
            }
        }
        return new ilog.rules.res.model.mbean.IlrJMXRuleset(ruleset);
    }
}

