/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.model.mbean;

import com.ibm.rules.res.logging.internal.RESLogger;
import com.ibm.rules.res.message.internal.XXMessageCode;
import ilog.rules.res.mbean.util.IlrMBeanManager;
import ilog.rules.res.mbean.util.InvocationResult;
import ilog.rules.res.model.mbean.IlrLogHelper;
import ilog.rules.res.model.mbean.IlrXUManager;
import ilog.rules.res.xu.management.IlrXUStatistics;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class IlrXUMBeanUtil {
    private static final transient RESLogger logger = RESLogger.getRESLogger("com.ibm.rules.res.mbean", "com.ibm.rules.res.common");
    private static final String METHOD_notifyRulesetArchiveChanged = "notifyRulesetArchiveChanged";
    private static final String[] METHOD_SIGNATURE_notifyRulesetArchiveChanged = new String[]{String.class.getName()};
    private static final String METHOD_resetWarningCount = "resetWarningCount";
    private static final String[] METHOD_SIGNATURE_resetWarningCount = new String[0];
    private static final String METHOD_resetErrorCount = "resetErrorCount";
    private static final String[] METHOD_SIGNATURE_resetErrorCount = new String[0];
    private static final String METHOD_getStatistics = "getStatistics";
    private static final String[] METHOD_SIGNATURE_getStatistics = new String[]{String.class.getName()};
    private static final String METHOD_resetStatistics = "resetStatistics";
    private static final String[] METHOD_SIGNATURE_resetStatistics = new String[]{String.class.getName()};
    private static final String METHOD_executionTest = "executionTest";
    private static final String[] METHOD_SIGNATURE_executionTest = new String[0];
    private static final String METHOD_getGlobalLogs = "getGlobalLogs";
    private static final String[] METHOD_SIGNATURE_getGlobalLogs = new String[]{Locale.class.getName()};
    private static final String METHOD_getLogs = "getLogs";
    private static final String[] METHOD_SIGNATURE_getLogs = new String[]{Locale.class.getName(), String.class.getName()};
    private static final String METHOD_resetLogs = "resetLogs";
    private static final String[] METHOD_SIGNATURE_resetLogs = new String[]{String.class.getName()};
    private static final String METHOD_resetGlobalLogs = "resetGlobalLogs";
    private static final String[] METHOD_SIGNATURE_resetGlobalLogs = new String[0];
    private static final String ATTRIBUTE_warningCount = "WarningCount";
    private static final String ATTRIBUTE_errorCount = "ErrorCount";
    private static final String ATTRIBUTE_adapterName = "AdapterName";
    private static final String ATTRIBUTE_adapterVersion = "AdapterVersion";
    private static final String ATTRIBUTE_adapterShortDescription = "AdapterShortDescription";
    private static final String ATTRIBUTE_adapterVendorName = "AdapterVendorName";
    private static final String ATTRIBUTE_debugInfos = "DebugInfos";
    private IlrMBeanManager mbeanManager;
    private ObjectName managementQuery;
    private ObjectName monitoringQuery;
    private Set<String> archiveChanges = null;
    private IlrXUManager xuManager = null;

    public IlrXUMBeanUtil(IlrMBeanManager mbeanManager) {
        this.mbeanManager = mbeanManager;
    }

    public IlrXUMBeanUtil(IlrMBeanManager mbeanManager, IlrXUManager xuManager) {
        this.xuManager = xuManager;
        this.mbeanManager = mbeanManager;
    }

    public List<InvocationResult> getAdapterName() {
        List<InvocationResult> tmp;
        List<InvocationResult> result = this.mbeanManager.getAttribute(this.getMonitoringQuery(), ATTRIBUTE_adapterName);
        if (this.xuManager != null && (tmp = this.xuManager.getAdapterName()) != null) {
            result.addAll(tmp);
        }
        this.logErrors(result, XXMessageCode.ERROR_GET_ADAPTER_NAME);
        return result;
    }

    public List<InvocationResult> getAdapterVersion() {
        List<InvocationResult> tmp;
        List<InvocationResult> result = this.mbeanManager.getAttribute(this.getMonitoringQuery(), ATTRIBUTE_adapterVersion);
        if (this.xuManager != null && (tmp = this.xuManager.getAdapterVersion()) != null) {
            result.addAll(tmp);
        }
        this.logErrors(result, XXMessageCode.ERROR_GET_ADAPTER_VERSION);
        return result;
    }

    public List<InvocationResult> getAdapterShortDescription() {
        List<InvocationResult> tmp;
        List<InvocationResult> result = this.mbeanManager.getAttribute(this.getMonitoringQuery(), ATTRIBUTE_adapterShortDescription);
        if (this.xuManager != null && (tmp = this.xuManager.getAdapterShortDescription()) != null) {
            result.addAll(tmp);
        }
        this.logErrors(result, XXMessageCode.ERROR_GET_ADAPTER_SHORT_VERSION);
        return result;
    }

    public List<InvocationResult> getAdapterVendorName() {
        List<InvocationResult> tmp;
        List<InvocationResult> result = this.mbeanManager.getAttribute(this.getMonitoringQuery(), ATTRIBUTE_adapterVendorName);
        if (this.xuManager != null && (tmp = this.xuManager.getAdapterVendorName()) != null) {
            result.addAll(tmp);
        }
        this.logErrors(result, XXMessageCode.ERROR_GET_ADAPTER_VENDOR_NAME);
        return result;
    }

    public synchronized void notifyRulesetArchiveChanged(String canonicalRulesetPath) {
        if (this.archiveChanges != null) {
            this.archiveChanges.add(canonicalRulesetPath);
        } else {
            List<InvocationResult> result = this.mbeanManager.invoke(this.getManagementQuery(), METHOD_notifyRulesetArchiveChanged, new Object[]{canonicalRulesetPath}, METHOD_SIGNATURE_notifyRulesetArchiveChanged);
            if (this.xuManager != null) {
                this.xuManager.notifyRulesetArchiveChanged(canonicalRulesetPath);
            }
            this.logErrors(result, XXMessageCode.ERROR_NOTIF_RULESET_ARCHIVE_CHANGED);
        }
    }

    public List<InvocationResult> getGlobalLogs(Locale locale) {
        List<InvocationResult> tmp;
        List<InvocationResult> result = this.mbeanManager.invoke(this.getMonitoringQuery(), METHOD_getGlobalLogs, new Object[]{locale}, METHOD_SIGNATURE_getGlobalLogs);
        if (this.xuManager != null && (tmp = this.xuManager.getGlobalLogs(locale)) != null) {
            result.addAll(tmp);
        }
        this.logErrors(result, XXMessageCode.ERROR_GET_GLOBAL_LOGS);
        return result;
    }

    public List<InvocationResult> getGlobalLogs(Locale locale, String serverInfo) {
        List<InvocationResult> tmp;
        List<InvocationResult> result = this.mbeanManager.invoke(serverInfo, this.getMonitoringQuery(), METHOD_getGlobalLogs, new Object[]{locale}, METHOD_SIGNATURE_getGlobalLogs);
        if (this.xuManager != null && (tmp = this.xuManager.getGlobalLogs(locale, serverInfo)) != null) {
            result.addAll(tmp);
        }
        this.logErrors(result, XXMessageCode.ERROR_GET_GLOBAL_LOGS);
        return result;
    }

    public List<InvocationResult> getLogs(Locale locale, String canonicalRulesetPath) {
        List<InvocationResult> tmp;
        List<InvocationResult> result = this.mbeanManager.invoke(this.getMonitoringQuery(), METHOD_getLogs, new Object[]{locale, canonicalRulesetPath}, METHOD_SIGNATURE_getLogs);
        if (this.xuManager != null && (tmp = this.xuManager.getLogs(locale, canonicalRulesetPath)) != null) {
            result.addAll(tmp);
        }
        this.logErrors(result, XXMessageCode.ERROR_GET_LOGS);
        return result;
    }

    public List<InvocationResult> getLogs(Locale locale, String serverInfo, String canonicalRulesetPath) {
        List<InvocationResult> tmp;
        List<InvocationResult> result = this.mbeanManager.invoke(serverInfo, this.getMonitoringQuery(), METHOD_getLogs, new Object[]{locale, canonicalRulesetPath}, METHOD_SIGNATURE_getLogs);
        if (this.xuManager != null && (tmp = this.xuManager.getLogs(locale, serverInfo, canonicalRulesetPath)) != null) {
            result.addAll(tmp);
        }
        this.logErrors(result, XXMessageCode.ERROR_GET_LOGS);
        return result;
    }

    public List<InvocationResult> getDebugInfos(String serverInfo) {
        List<InvocationResult> tmp;
        List<InvocationResult> result = this.mbeanManager.getAttribute(serverInfo, this.getMonitoringQuery(), ATTRIBUTE_debugInfos);
        if (this.xuManager != null && (tmp = this.xuManager.getDebugInfos(serverInfo)) != null) {
            result.addAll(tmp);
        }
        this.logErrors(result, XXMessageCode.ERROR_GET_DEBUG_INFOS);
        return result;
    }

    public List<InvocationResult> resetGlobalLogs() {
        List<InvocationResult> tmp;
        List<InvocationResult> result = this.mbeanManager.invoke(this.getMonitoringQuery(), METHOD_resetGlobalLogs, new Object[0], METHOD_SIGNATURE_resetGlobalLogs);
        if (this.xuManager != null && (tmp = this.xuManager.resetGlobalLogs()) != null) {
            result.addAll(tmp);
        }
        this.logErrors(result, XXMessageCode.ERROR_RESET_LOGS);
        return result;
    }

    public List<InvocationResult> resetGlobalLogs(String serverInfo) {
        List<InvocationResult> tmp;
        List<InvocationResult> result = this.mbeanManager.invoke(serverInfo, this.getMonitoringQuery(), METHOD_resetGlobalLogs, new Object[0], METHOD_SIGNATURE_resetGlobalLogs);
        if (this.xuManager != null && (tmp = this.xuManager.resetGlobalLogs(serverInfo)) != null) {
            result.addAll(tmp);
        }
        this.logErrors(result, XXMessageCode.ERROR_RESET_LOGS);
        return result;
    }

    public List<InvocationResult> resetLogs(String canonicalRulesetPath) {
        List<InvocationResult> tmp;
        List<InvocationResult> result = this.mbeanManager.invoke(this.getMonitoringQuery(), METHOD_resetLogs, new Object[]{canonicalRulesetPath}, METHOD_SIGNATURE_resetLogs);
        if (this.xuManager != null && (tmp = this.xuManager.resetLogs(canonicalRulesetPath)) != null) {
            result.addAll(tmp);
        }
        this.logErrors(result, XXMessageCode.ERROR_RESET_LOGS);
        return result;
    }

    public List<InvocationResult> getWarningCount() {
        List<InvocationResult> tmp;
        List<InvocationResult> result = this.mbeanManager.getAttribute(this.getMonitoringQuery(), ATTRIBUTE_warningCount);
        if (this.xuManager != null && (tmp = this.xuManager.getWarningCount()) != null) {
            result.addAll(tmp);
        }
        this.logErrors(result, XXMessageCode.ERROR_GET_WARNING_COUNT);
        return result;
    }

    public List<InvocationResult> getErrorCount() {
        List<InvocationResult> tmp;
        List<InvocationResult> result = this.mbeanManager.getAttribute(this.getMonitoringQuery(), ATTRIBUTE_errorCount);
        if (this.xuManager != null && (tmp = this.xuManager.getErrorCount()) != null) {
            result.addAll(tmp);
        }
        this.logErrors(result, XXMessageCode.ERROR_GET_ERROR_COUNT);
        return result;
    }

    public List<InvocationResult> resetWarningCount() {
        List<InvocationResult> tmp;
        List<InvocationResult> result = this.mbeanManager.invoke(this.getMonitoringQuery(), METHOD_resetWarningCount, new Object[0], METHOD_SIGNATURE_resetWarningCount);
        if (this.xuManager != null && (tmp = this.xuManager.resetWarningCount()) != null) {
            result.addAll(tmp);
        }
        this.logErrors(result, XXMessageCode.ERROR_RESET_WARNING_COUNT);
        return result;
    }

    public List<InvocationResult> resetErrorCount() {
        List<InvocationResult> tmp;
        List<InvocationResult> result = this.mbeanManager.invoke(this.getMonitoringQuery(), METHOD_resetErrorCount, new Object[0], METHOD_SIGNATURE_resetErrorCount);
        if (this.xuManager != null && (tmp = this.xuManager.resetErrorCount()) != null) {
            result.addAll(tmp);
        }
        this.logErrors(result, XXMessageCode.ERROR_RESET_ERROR_COUNT);
        return result;
    }

    public List<InvocationResult> getStatistics(String canonicalRulesetPath) {
        List<InvocationResult> tmp;
        List<InvocationResult> result = this.mbeanManager.invoke(this.getMonitoringQuery(), METHOD_getStatistics, new Object[]{canonicalRulesetPath}, METHOD_SIGNATURE_getStatistics);
        if (this.xuManager != null && (tmp = this.xuManager.getStatistics(canonicalRulesetPath)) != null) {
            result.addAll(tmp);
        }
        this.logErrors(result, XXMessageCode.ERROR_GET_STAT);
        return result;
    }

    public List<InvocationResult> resetStatistics(String canonicalRulesetPath) {
        List<InvocationResult> tmp;
        List<InvocationResult> result = this.mbeanManager.invoke(this.getMonitoringQuery(), METHOD_resetStatistics, new Object[]{canonicalRulesetPath}, METHOD_SIGNATURE_resetStatistics);
        if (this.xuManager != null && (tmp = this.xuManager.resetStatistics(canonicalRulesetPath)) != null) {
            result.addAll(tmp);
        }
        this.logErrors(result, XXMessageCode.ERROR_RESET_STAT);
        return result;
    }

    public List<InvocationResult> executionTest() {
        List<InvocationResult> tmp;
        List<InvocationResult> result = this.mbeanManager.invoke(this.getMonitoringQuery(), METHOD_executionTest, new Object[0], METHOD_SIGNATURE_executionTest);
        if (this.xuManager != null && (tmp = this.xuManager.executionTest()) != null) {
            result.addAll(tmp);
        }
        this.logErrors(result, XXMessageCode.ERROR_EXECUTION_TEST);
        return result;
    }

    public static Map<String, long[]> getUnifiedStatistics(List<InvocationResult> statistics) {
        HashMap<String, long[]> result = new HashMap<String, long[]>();
        for (InvocationResult invResult : statistics) {
            Map stats = (Map)invResult.getResult();
            if (stats == null) continue;
            for (Map.Entry entry : stats.entrySet()) {
                IlrXUStatistics rmetrics;
                IlrXUStatistics metrics = new IlrXUStatistics((long[])entry.getValue());
                long[] obj = (long[])result.get(entry.getKey());
                IlrXUStatistics ilrXUStatistics = rmetrics = obj == null ? null : new IlrXUStatistics(obj);
                if (rmetrics == null) {
                    result.put((String)entry.getKey(), metrics.toObject());
                    continue;
                }
                rmetrics.unifiedStatistics(metrics);
            }
        }
        return result;
    }

    public synchronized void startBuffering() {
        this.archiveChanges = new HashSet<String>();
    }

    public synchronized void flushBuffer() {
        Set<String> changes = this.archiveChanges;
        this.archiveChanges = null;
        for (String canonicalRulesetPath : changes) {
            this.notifyRulesetArchiveChanged(canonicalRulesetPath);
        }
    }

    private synchronized ObjectName getMonitoringQuery() {
        if (this.monitoringQuery == null) {
            try {
                Properties managerProps = this.mbeanManager.getProperties();
                String queryPart = managerProps.getProperty("JMX_XU_QUERY_PART");
                this.monitoringQuery = this.mbeanManager.getQuery(null, queryPart, this.getXUFilter(null));
            }
            catch (MalformedObjectNameException e) {
                throw new UnsupportedOperationException(e.getMessage());
            }
        }
        return this.monitoringQuery;
    }

    private synchronized ObjectName getManagementQuery() {
        if (this.managementQuery == null) {
            try {
                Properties managerProps = this.mbeanManager.getProperties();
                String queryPart = managerProps.getProperty("JMX_XU_QUERY_PART");
                Properties filter = this.getXUFilter("management");
                this.managementQuery = this.mbeanManager.getQuery("IlrXUManagement", queryPart, filter);
            }
            catch (MalformedObjectNameException e) {
                throw new UnsupportedOperationException(e.getMessage());
            }
        }
        return this.managementQuery;
    }

    private Properties getXUFilter(String type) {
        Properties props = new Properties();
        props.setProperty("xuId", "IlrXU");
        props.setProperty("xuVersion", "8.*");
        if (type != null) {
            props.setProperty("xuType", type);
        }
        return props;
    }

    private void logErrors(List<InvocationResult> result, String messageCode) {
        for (InvocationResult element : result) {
            if (element.getError() == null) continue;
            logger.severe(IlrLogHelper.getJMXMessage(messageCode, element), null, element.getError());
        }
    }

    public IlrXUManager getXuManager() {
        return this.xuManager;
    }
}

