/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.model.mbean.impl;

import ilog.rules.res.mbean.util.IlrMBeanManager;
import ilog.rules.res.model.IlrAlreadyExistException;
import ilog.rules.res.model.IlrIllegalArgumentRuntimeException;
import ilog.rules.res.model.IlrMutableRepository;
import ilog.rules.res.model.IlrMutableRuleAppInformation;
import ilog.rules.res.model.IlrResourceRuntimeException;
import ilog.rules.res.model.IlrVersion;
import ilog.rules.res.model.mbean.IlrJMXRepositoryMBean;
import ilog.rules.res.model.mbean.impl.IlrJMXProxyMutableRuleAppInformationImp;
import java.util.HashSet;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InvalidAttributeValueException;
import javax.management.ObjectName;
import javax.management.OperationsException;

public class IlrJMXProxyMutableRepositoryImpl
implements IlrMutableRepository {
    final IlrMBeanManager mbeanManager;
    private final IlrJMXRepositoryMBean proxy;

    protected IlrJMXProxyMutableRepositoryImpl(IlrMBeanManager mbeanManager, IlrJMXRepositoryMBean proxy) {
        this.mbeanManager = mbeanManager;
        this.proxy = proxy;
    }

    @Override
    public Set<IlrMutableRuleAppInformation> getRuleApps() {
        HashSet<IlrMutableRuleAppInformation> result = new HashSet<IlrMutableRuleAppInformation>();
        Set<ObjectName> objectNames = this.proxy.getRuleAppObjectNames();
        for (ObjectName objectName : objectNames) {
            result.add(new IlrJMXProxyMutableRuleAppInformationImp(this, objectName));
        }
        return result;
    }

    @Override
    public Set<IlrMutableRuleAppInformation> getRuleApps(String ruleAppName) {
        HashSet<IlrMutableRuleAppInformation> result = new HashSet<IlrMutableRuleAppInformation>();
        if (ruleAppName == null) {
            return result;
        }
        Set<ObjectName> objectNames = this.proxy.getRuleAppObjectNames(ruleAppName);
        for (ObjectName objectName : objectNames) {
            result.add(new IlrJMXProxyMutableRuleAppInformationImp(this, objectName));
        }
        return result;
    }

    @Override
    public IlrMutableRuleAppInformation getGreatestRuleApp(String ruleAppName) {
        if (ruleAppName == null) {
            return null;
        }
        ObjectName objectName = this.proxy.getGreatestRuleAppObjectName(ruleAppName);
        if (objectName == null) {
            return null;
        }
        return new IlrJMXProxyMutableRuleAppInformationImp(this, objectName);
    }

    @Override
    public IlrMutableRuleAppInformation getRuleApp(String ruleAppName, IlrVersion ruleAppVersion) {
        if (ruleAppName == null || ruleAppVersion == null) {
            return null;
        }
        ObjectName objectName = this.proxy.getRuleAppObjectName(ruleAppName, ruleAppVersion.toString());
        if (objectName == null) {
            return null;
        }
        return new IlrJMXProxyMutableRuleAppInformationImp(this, objectName);
    }

    @Override
    public IlrMutableRuleAppInformation addRuleApp(IlrMutableRuleAppInformation ruleApp) throws IlrAlreadyExistException {
        if (ruleApp == null) {
            return null;
        }
        if (ruleApp.getRepository() != null && ruleApp.getRepository() != this) {
            throw new IllegalStateException();
        }
        try {
            ObjectName objectName = this.proxy.addRuleApp(ruleApp.getName(), ruleApp.getVersion().toString());
            if (objectName == null) {
                return null;
            }
            ((IlrJMXProxyMutableRuleAppInformationImp)ruleApp).added(this, objectName);
            return ruleApp;
        }
        catch (InstanceAlreadyExistsException e) {
            throw new IlrAlreadyExistException(e.getMessage());
        }
        catch (InvalidAttributeValueException e) {
            throw new IlrIllegalArgumentRuntimeException(e.getMessage());
        }
        catch (OperationsException e) {
            throw new IlrResourceRuntimeException(e.getMessage());
        }
    }

    @Override
    public boolean removeRuleApp(IlrMutableRuleAppInformation ruleApp) {
        if (ruleApp == null) {
            return false;
        }
        try {
            boolean result = this.proxy.removeRuleApp(ruleApp.getName(), ruleApp.getVersion().toString());
            ((IlrJMXProxyMutableRuleAppInformationImp)ruleApp).removed();
            return result;
        }
        catch (OperationsException e) {
            throw new IlrResourceRuntimeException(e.getMessage());
        }
    }
}

