/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.model.mbean.impl;

import com.ibm.rules.res.util.internal.StreamUtil;
import ilog.rules.res.mbean.util.IlrSingleMBeanInvocationHandler;
import ilog.rules.res.model.IlrAlreadyExistException;
import ilog.rules.res.model.IlrCRERulesetArchive;
import ilog.rules.res.model.IlrDERulesetArchive;
import ilog.rules.res.model.IlrEngineType;
import ilog.rules.res.model.IlrFormatException;
import ilog.rules.res.model.IlrIllegalArgumentRuntimeException;
import ilog.rules.res.model.IlrMutableRepository;
import ilog.rules.res.model.IlrMutableRulesetArchiveInformation;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.model.IlrRESRulesetArchive;
import ilog.rules.res.model.IlrResourceRuntimeException;
import ilog.rules.res.model.IlrRuleAppProperties;
import ilog.rules.res.model.IlrVersion;
import ilog.rules.res.model.internal.IlrMutableRuleAppInformationImpl;
import ilog.rules.res.model.internal.IlrRuleAppPropertiesImpl;
import ilog.rules.res.model.mbean.IlrJMXRuleAppMBean;
import ilog.rules.res.model.mbean.impl.IlrJMXProxyMutableRepositoryImpl;
import ilog.rules.res.model.mbean.impl.IlrJMXProxyMutableRulesetArchiveInformationImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarOutputStream;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InvalidAttributeValueException;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.RuntimeOperationsException;

public class IlrJMXProxyMutableRuleAppInformationImp
extends IlrMutableRuleAppInformationImpl {
    private IlrJMXProxyMutableRepositoryImpl _repository;
    protected ObjectName _objectName;
    private IlrJMXRuleAppMBean _proxy;
    private IlrPath _path;
    private IlrVersion _version;

    public IlrJMXProxyMutableRuleAppInformationImp(String name, IlrVersion version, Date creationDate) {
        super(name, version, creationDate);
    }

    public IlrJMXProxyMutableRuleAppInformationImp(IlrJMXProxyMutableRepositoryImpl repository, ObjectName objectName) {
        super(null, null, null);
        this._repository = repository;
        this._objectName = objectName;
        this.init();
    }

    @Override
    public String getName() {
        if (this._objectName != null) {
            return this._objectName.getKeyProperty("Name");
        }
        return super.getName();
    }

    @Override
    public IlrVersion getVersion() {
        if (this._objectName != null) {
            return this._version;
        }
        return super.getVersion();
    }

    @Override
    public Date getCreationDate() {
        if (this._objectName != null) {
            return new Date(this._proxy.getCreationDate());
        }
        return super.getCreationDate();
    }

    @Override
    public String getDisplayName() {
        if (this._objectName != null) {
            return this._proxy.getDisplayName();
        }
        return super.getDisplayName();
    }

    @Override
    public void setDisplayName(String displayName) {
        if (this._objectName != null) {
            try {
                this._proxy.setDisplayName(displayName);
            }
            catch (RuntimeOperationsException e) {
                throw new IlrResourceRuntimeException(e.getMessage());
            }
        } else {
            super.setDisplayName(displayName);
        }
    }

    @Override
    public String getDescription() {
        if (this._objectName != null) {
            return this._proxy.getDescription();
        }
        return super.getDescription();
    }

    @Override
    public void setDescription(String description) {
        if (this._objectName != null) {
            try {
                this._proxy.setDescription(description);
            }
            catch (RuntimeOperationsException e) {
                throw new IlrResourceRuntimeException(e.getMessage());
            }
        } else {
            super.setDescription(description);
        }
    }

    @Override
    public IlrMutableRepository getRepository() {
        if (this._objectName != null) {
            return this._repository;
        }
        return super.getRepository();
    }

    @Override
    public Set<IlrMutableRulesetArchiveInformation> getRulesets() {
        if (this._objectName != null) {
            Set<ObjectName> objectNames = this._proxy.getRulesetObjectNames();
            HashSet<IlrMutableRulesetArchiveInformation> result = new HashSet<IlrMutableRulesetArchiveInformation>();
            for (ObjectName objectName : objectNames) {
                result.add(new IlrJMXProxyMutableRulesetArchiveInformationImpl(this._repository, this, objectName));
            }
            return result;
        }
        return super.getRulesets();
    }

    @Override
    public Set<IlrMutableRulesetArchiveInformation> getRulesets(String rulesetName) {
        if (this._objectName != null) {
            HashSet<IlrMutableRulesetArchiveInformation> result = new HashSet<IlrMutableRulesetArchiveInformation>();
            if (rulesetName == null) {
                return result;
            }
            Set<ObjectName> objectNames = this._proxy.getRulesetObjectNames(rulesetName);
            for (ObjectName objectName : objectNames) {
                result.add(new IlrJMXProxyMutableRulesetArchiveInformationImpl(this._repository, this, objectName));
            }
            return result;
        }
        return super.getRulesets(rulesetName);
    }

    @Override
    public IlrMutableRulesetArchiveInformation getGreatestRuleset(String rulesetName) {
        if (this._objectName != null) {
            if (rulesetName == null) {
                return null;
            }
            ObjectName objectName = this._proxy.getGreatestRulesetObjectName(rulesetName);
            if (objectName == null) {
                return null;
            }
            return new IlrJMXProxyMutableRulesetArchiveInformationImpl(this._repository, this, objectName);
        }
        return super.getGreatestRuleset(rulesetName);
    }

    @Override
    public IlrMutableRulesetArchiveInformation getRuleset(String rulesetName, IlrVersion rulesetVersion) {
        if (this._objectName != null) {
            if (rulesetName == null || rulesetVersion == null) {
                return null;
            }
            ObjectName objectName = this._proxy.getRulesetObjectName(rulesetName, rulesetVersion.toString());
            if (objectName == null) {
                return null;
            }
            return new IlrJMXProxyMutableRulesetArchiveInformationImpl(this._repository, this, objectName);
        }
        return super.getRuleset(rulesetName, rulesetVersion);
    }

    @Override
    public IlrMutableRulesetArchiveInformation addRuleset(IlrMutableRulesetArchiveInformation ruleset) throws IlrAlreadyExistException {
        if (this._objectName != null) {
            if (ruleset == null) {
                return null;
            }
            if (ruleset.getRuleApp() != null && ruleset.getRuleApp() != this) {
                throw new IllegalStateException();
            }
            try {
                ObjectName objectName;
                IlrRESRulesetArchive rulesetArchive = ruleset.getRESRulesetArchive();
                IlrEngineType engineType = IlrEngineType.CRE;
                byte[] archive = null;
                if (rulesetArchive != null) {
                    if (rulesetArchive instanceof IlrCRERulesetArchive) {
                        engineType = IlrEngineType.CRE;
                        IlrCRERulesetArchive creRulesetArchive = (IlrCRERulesetArchive)rulesetArchive;
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        JarOutputStream jos = new JarOutputStream(baos);
                        jos.setLevel(9);
                        creRulesetArchive.getRulesetArchive().write(jos);
                        jos.finish();
                        archive = baos.toByteArray();
                    } else {
                        engineType = IlrEngineType.DE;
                        IlrDERulesetArchive deArchive = (IlrDERulesetArchive)rulesetArchive;
                        archive = StreamUtil.toByteArray(deArchive.getContentStream());
                    }
                }
                if ((objectName = this._proxy.addRuleset(ruleset.getName(), ruleset.getVersion().toString(), engineType.toString(), archive)) == null) {
                    return null;
                }
                ((IlrJMXProxyMutableRulesetArchiveInformationImpl)ruleset).added(this, objectName);
                return ruleset;
            }
            catch (InstanceAlreadyExistsException e) {
                throw new IlrAlreadyExistException(e.getMessage());
            }
            catch (InvalidAttributeValueException e) {
                throw new IlrIllegalArgumentRuntimeException(e.getMessage());
            }
            catch (OperationsException e) {
                throw new IlrResourceRuntimeException(e.getMessage());
            }
            catch (IOException e) {
                throw new IlrResourceRuntimeException(e.getMessage());
            }
        }
        return super.addRuleset(ruleset);
    }

    @Override
    public boolean removeRuleset(IlrMutableRulesetArchiveInformation ruleset) {
        if (this._objectName != null) {
            if (ruleset == null) {
                return false;
            }
            try {
                boolean result = this._proxy.removeRuleset(ruleset.getName(), ruleset.getVersion().toString());
                ((IlrJMXProxyMutableRulesetArchiveInformationImpl)ruleset).removed();
                return result;
            }
            catch (OperationsException e) {
                throw new IlrResourceRuntimeException(e.getMessage());
            }
        }
        return super.removeRuleset(ruleset);
    }

    @Override
    public IlrRuleAppProperties getProperties() {
        if (this._objectName != null) {
            try {
                HashMap<String, String> props = new HashMap<String, String>();
                for (Map.Entry<Object, Object> entry : this._proxy.getProperties().entrySet()) {
                    props.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
                }
                return new IlrRuleAppPropertiesImpl(props);
            }
            catch (OperationsException e) {
                throw new IlrResourceRuntimeException(e.getMessage());
            }
        }
        return super.getProperties();
    }

    @Override
    public void setProperty(String key, String value) {
        if (this._objectName != null) {
            try {
                this._proxy.setProperty(key, value);
            }
            catch (OperationsException e) {
                throw new IlrResourceRuntimeException(e.getMessage());
            }
        } else {
            super.setProperty(key, value);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IlrJMXProxyMutableRuleAppInformationImp)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public String toString() {
        if (this._objectName != null) {
            return this._path.toString();
        }
        return super.toString();
    }

    protected void removed() {
        this._repository = null;
        this._objectName = null;
        this._proxy = null;
        this._path = null;
        this._version = null;
    }

    protected void added(IlrJMXProxyMutableRepositoryImpl repository, ObjectName objectName) throws OperationsException, IlrAlreadyExistException {
        this._repository = repository;
        this._objectName = objectName;
        this.init();
        if (super.getDescription() != null) {
            this._proxy.setDescription(super.getDescription());
        }
        if (super.getDisplayName() != null) {
            this._proxy.setDisplayName(super.getDisplayName());
        }
        for (Map.Entry entry : super.getProperties().entrySet()) {
            this._proxy.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        for (IlrMutableRulesetArchiveInformation ruleset : super.getRulesets()) {
            this.addRuleset(ruleset);
        }
    }

    private void init() {
        if (this._objectName != null) {
            IlrSingleMBeanInvocationHandler handler = new IlrSingleMBeanInvocationHandler(this._repository.mbeanManager, this._objectName);
            this._proxy = (IlrJMXRuleAppMBean)Proxy.newProxyInstance(IlrJMXRuleAppMBean.class.getClassLoader(), new Class[]{IlrJMXRuleAppMBean.class}, (InvocationHandler)handler);
            try {
                this._version = IlrVersion.parseVersion(this._objectName.getKeyProperty("Version"));
            }
            catch (IlrFormatException e) {
                this._version = null;
            }
            this._path = new IlrPath(this._objectName.getKeyProperty("Name"), this._version);
        }
    }
}

