/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.model.mbean.impl;

import ilog.rules.archive.IlrRulesetArchive;
import ilog.rules.res.mbean.util.IlrSingleMBeanInvocationHandler;
import ilog.rules.res.model.IlrEngineType;
import ilog.rules.res.model.IlrFormatException;
import ilog.rules.res.model.IlrIllegalArgumentRuntimeException;
import ilog.rules.res.model.IlrMutableRepository;
import ilog.rules.res.model.IlrMutableRuleAppInformation;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.model.IlrRESRulesetArchive;
import ilog.rules.res.model.IlrResourceRuntimeException;
import ilog.rules.res.model.IlrRulesetArchiveProperties;
import ilog.rules.res.model.IlrVersion;
import ilog.rules.res.model.internal.IlrMutableRulesetArchiveInformationImpl;
import ilog.rules.res.model.internal.IlrRESArchiveUtil;
import ilog.rules.res.model.internal.IlrRulesetArchivePropertiesImpl;
import ilog.rules.res.model.mbean.IlrJMXRulesetMBean;
import ilog.rules.res.model.mbean.impl.IlrJMXProxyMutableRepositoryImpl;
import ilog.rules.res.model.mbean.impl.IlrJMXProxyMutableRuleAppInformationImp;
import ilog.rules.res.util.IlrRulesetArchiveExtractor;
import ilog.rules.res.util.io.IlrFileUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarOutputStream;
import javax.management.InvalidAttributeValueException;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.RuntimeOperationsException;

public class IlrJMXProxyMutableRulesetArchiveInformationImpl
extends IlrMutableRulesetArchiveInformationImpl {
    private IlrJMXProxyMutableRepositoryImpl _repository;
    private IlrJMXProxyMutableRuleAppInformationImp _ruleApp;
    private ObjectName _objectName;
    private IlrJMXRulesetMBean _proxy;
    private IlrPath _path;
    private IlrVersion _version;

    public IlrJMXProxyMutableRulesetArchiveInformationImpl(String name, IlrVersion version, Date creationDate) {
        super(name, version, creationDate);
    }

    public IlrJMXProxyMutableRulesetArchiveInformationImpl(IlrJMXProxyMutableRepositoryImpl repository, IlrJMXProxyMutableRuleAppInformationImp ruleApp, ObjectName objectName) {
        super(null, null, null);
        this._repository = repository;
        this._ruleApp = ruleApp;
        this._objectName = objectName;
        this.init();
    }

    @Override
    public String getName() {
        if (this._objectName != null) {
            return this._objectName.getKeyProperty("Name");
        }
        return super.getName();
    }

    @Override
    public IlrVersion getVersion() {
        if (this._objectName != null) {
            return this._version;
        }
        return super.getVersion();
    }

    @Override
    public Date getCreationDate() {
        if (this._objectName != null) {
            return new Date(this._proxy.getCreationDate());
        }
        return super.getCreationDate();
    }

    @Override
    public String getDisplayName() {
        if (this._objectName != null) {
            return this._proxy.getDisplayName();
        }
        return super.getDisplayName();
    }

    @Override
    public void setDisplayName(String displayName) {
        if (this._objectName != null) {
            try {
                this._proxy.setDisplayName(displayName);
            }
            catch (RuntimeOperationsException e) {
                throw new IlrResourceRuntimeException(e.getMessage());
            }
        } else {
            super.setDisplayName(displayName);
        }
    }

    @Override
    public String getDescription() {
        if (this._objectName != null) {
            return this._proxy.getDescription();
        }
        return super.getDescription();
    }

    @Override
    public void setDescription(String description) {
        if (this._objectName != null) {
            try {
                this._proxy.setDescription(description);
            }
            catch (RuntimeOperationsException e) {
                throw new IlrResourceRuntimeException(e.getMessage());
            }
        } else {
            super.setDescription(description);
        }
    }

    @Override
    public IlrMutableRepository getRepository() {
        if (this._objectName != null) {
            return this._repository;
        }
        return super.getRepository();
    }

    @Override
    public IlrMutableRuleAppInformation getRuleApp() {
        if (this._objectName != null) {
            return this._ruleApp;
        }
        return super.getRuleApp();
    }

    @Override
    public IlrRulesetArchive getRulesetArchive() {
        if (this._objectName != null) {
            try {
                byte[] bytes = this._proxy.getRulesetArchive();
                if (bytes != null) {
                    return IlrRulesetArchiveExtractor.extract(new ByteArrayInputStream(bytes));
                }
                return null;
            }
            catch (OperationsException e) {
                throw new IlrResourceRuntimeException(e.getMessage());
            }
            catch (IlrRulesetArchive.RulesetArchiveException e) {
                throw new IlrResourceRuntimeException(e.getMessage());
            }
            catch (IOException e) {
                throw new IlrResourceRuntimeException(e.getMessage());
            }
        }
        return super.getRulesetArchive();
    }

    @Override
    public IlrRESRulesetArchive getRESRulesetArchive() {
        if (this._objectName != null) {
            try {
                String engineTypeAsString = this._proxy.getProperty("ruleset.engine");
                IlrEngineType engineType = IlrRulesetArchivePropertiesImpl.getEngineType(engineTypeAsString);
                byte[] bytes = this._proxy.getRESRulesetArchive();
                if (bytes != null) {
                    return IlrRESArchiveUtil.getRESRulesetArchive(engineType, new ByteArrayInputStream(bytes));
                }
                return null;
            }
            catch (OperationsException e) {
                throw new IlrResourceRuntimeException(e.getMessage());
            }
            catch (IOException e) {
                throw new IlrResourceRuntimeException(e.getMessage());
            }
        }
        return super.getRESRulesetArchive();
    }

    @Override
    @Deprecated
    public void setRulesetArchive(IlrRulesetArchive rulesetArchive) {
        if (this._objectName != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                byte[] archive = null;
                if (rulesetArchive != null) {
                    JarOutputStream jos = new JarOutputStream(baos);
                    jos.setLevel(9);
                    rulesetArchive.write(jos);
                    jos.finish();
                    archive = baos.toByteArray();
                }
                this._proxy.setRulesetArchive(archive);
            }
            catch (InvalidAttributeValueException e) {
                throw new IlrIllegalArgumentRuntimeException(e.getMessage());
            }
            catch (OperationsException e) {
                throw new IlrResourceRuntimeException(e.getMessage());
            }
            catch (IOException e) {
                throw new IlrResourceRuntimeException(e.getMessage());
            }
        } else {
            super.setRulesetArchive(rulesetArchive);
        }
    }

    @Override
    public void setRESRulesetArchive(IlrEngineType engineType, InputStream content) {
        if (this._objectName != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                byte[] archive = null;
                IlrFileUtil.copy(content, baos);
                baos.close();
                archive = baos.toByteArray();
                this._proxy.setRESRulesetArchive(engineType.toString(), archive);
            }
            catch (InvalidAttributeValueException e) {
                throw new IlrIllegalArgumentRuntimeException(e.getMessage());
            }
            catch (OperationsException e) {
                throw new IlrResourceRuntimeException(e.getMessage());
            }
            catch (IOException e) {
                throw new IlrResourceRuntimeException(e.getMessage());
            }
        } else {
            super.setRESRulesetArchive(engineType, content);
        }
    }

    @Override
    public IlrPath getCanonicalPath() {
        if (this._objectName != null) {
            return this._path;
        }
        return super.getCanonicalPath();
    }

    @Override
    public IlrRulesetArchiveProperties getProperties() {
        if (this._objectName != null) {
            try {
                HashMap<String, String> props = new HashMap<String, String>();
                for (Map.Entry<Object, Object> entry : this._proxy.getProperties().entrySet()) {
                    props.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
                }
                return new IlrRulesetArchivePropertiesImpl(props);
            }
            catch (OperationsException e) {
                throw new IlrResourceRuntimeException(e.getMessage());
            }
        }
        return super.getProperties();
    }

    @Override
    public void setProperty(String key, String value) {
        if (this._objectName != null) {
            try {
                this._proxy.setProperty(key, value);
            }
            catch (OperationsException e) {
                throw new IlrResourceRuntimeException(e.getMessage());
            }
        } else {
            super.setProperty(key, value);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IlrJMXProxyMutableRulesetArchiveInformationImpl)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public String toString() {
        if (this._objectName != null) {
            return this._path.toString();
        }
        return super.toString();
    }

    public void removed() {
        this._repository = null;
        this._ruleApp = null;
        this._objectName = null;
        this._proxy = null;
        this._path = null;
        this._version = null;
    }

    public void added(IlrJMXProxyMutableRuleAppInformationImp ruleApp, ObjectName objectName) throws OperationsException {
        this._repository = (IlrJMXProxyMutableRepositoryImpl)ruleApp.getRepository();
        this._objectName = objectName;
        this._ruleApp = ruleApp;
        this.init();
        if (super.getDescription() != null) {
            this._proxy.setDescription(super.getDescription());
        }
        if (super.getDisplayName() != null) {
            this._proxy.setDisplayName(super.getDisplayName());
        }
        for (Map.Entry entry : super.getProperties().entrySet()) {
            this._proxy.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void init() {
        if (this._objectName != null) {
            IlrSingleMBeanInvocationHandler handler = new IlrSingleMBeanInvocationHandler(this._repository.mbeanManager, this._objectName);
            this._proxy = (IlrJMXRulesetMBean)Proxy.newProxyInstance(IlrJMXRulesetMBean.class.getClassLoader(), new Class[]{IlrJMXRulesetMBean.class}, (InvocationHandler)handler);
            try {
                this._version = IlrVersion.parseVersion(this._objectName.getKeyProperty("Version"));
            }
            catch (IlrFormatException e) {
                this._version = null;
            }
            this._path = new IlrPath(this._ruleApp.getName(), this._ruleApp.getVersion(), this._objectName.getKeyProperty("Name"), this._version);
        }
    }
}

