/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.mprofiler;

import ilog.rules.res.mprofiler.IlrObjectInfoImpl;
import ilog.rules.res.mprofiler.IlrProfilerException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;

public class IlrMemoryProfiler {
    protected Instrumentation instrumentation;
    protected List<String> defaultIncludedPackageNames = new ArrayList<String>();

    IlrMemoryProfiler(Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
        this.defaultIncludedPackageNames.add("java.");
        this.defaultIncludedPackageNames.add("ilog.");
    }

    public void setDefaultIncludedPackageNames(List<String> defaultIncludedPackageNames) {
        this.defaultIncludedPackageNames = defaultIncludedPackageNames;
    }

    public IlrObjectInfoImpl getObjectInfo(Object object) throws IlrProfilerException {
        IlrObjectInfoImpl impl = this.getObjectInfo(object, new IdentityHashMap<Object, IlrObjectInfoImpl>(), this.defaultIncludedPackageNames);
        return impl;
    }

    public IlrObjectInfoImpl getObjectInfo(Object object, List<String> includedPackageNames) throws IlrProfilerException {
        if (includedPackageNames == null) {
            includedPackageNames = this.defaultIncludedPackageNames;
        }
        IlrObjectInfoImpl result = this.getObjectInfo(object, new IdentityHashMap<Object, IlrObjectInfoImpl>(), includedPackageNames);
        return result;
    }

    protected IlrObjectInfoImpl getObjectInfo(Object object, IdentityHashMap<Object, IlrObjectInfoImpl> objects, List<String> includedPackageNames) throws IlrProfilerException {
        if (this.instrumentation == null) {
            return null;
        }
        IlrObjectInfoImpl objectInfo = objects.get(object);
        if (objectInfo != null) {
            return objectInfo;
        }
        Class<?> clazz = object.getClass();
        objectInfo = this.addObjectInfo(object, objects);
        objectInfo.size = this.instrumentation.getObjectSize(object);
        if (clazz.isArray()) {
            if (clazz.getName().length() != 2) {
                int length = Array.getLength(object);
                for (int i = 0; i < length; ++i) {
                    Object o = Array.get(object, i);
                    if (o == null || o.getClass().isPrimitive() || o == null) continue;
                    if (this.contains(objects, o)) {
                        objectInfo.addArrayEntry(this.get(objects, o));
                        continue;
                    }
                    IlrObjectInfoImpl entryInfo = this.getObjectInfo(o, objects, includedPackageNames);
                    objectInfo.addArrayEntry(entryInfo);
                }
            }
            return objectInfo;
        }
        String nc = clazz.getName();
        boolean found = false;
        for (String packageName : includedPackageNames) {
            if (!nc.startsWith(packageName)) continue;
            found = true;
            break;
        }
        if (!found) {
            return objectInfo;
        }
        while (clazz != null) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                boolean accessible = field.isAccessible();
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                try {
                    Object fieldO;
                    if (field.getType().isPrimitive()) {
                        fieldO = null;
                        if (field.getType() == Integer.TYPE) {
                            fieldO = field.getInt(object);
                        } else if (field.getType() == Boolean.TYPE) {
                            fieldO = field.getBoolean(object);
                        } else if (field.getType() == Long.TYPE) {
                            fieldO = field.getLong(object);
                        }
                        objectInfo.addField(field.getName(), fieldO, field.getType(), new IlrObjectInfoImpl(-1L, field.getType()));
                        continue;
                    }
                    fieldO = field.get(object);
                    if (Modifier.isStatic(field.getModifiers())) continue;
                    if (fieldO == null) {
                        objectInfo.addField(field.getName(), fieldO, field.getType(), this.get(objects, fieldO));
                        continue;
                    }
                    if (this.contains(objects, fieldO)) {
                        objectInfo.addField(field.getName(), fieldO, field.getType(), this.get(objects, fieldO));
                        continue;
                    }
                    IlrObjectInfoImpl fieldInfo = this.getObjectInfo(fieldO, objects, includedPackageNames);
                    objectInfo.addField(field.getName(), fieldO, field.getType(), fieldInfo);
                }
                catch (IllegalAccessException e) {
                    throw new IlrProfilerException(e);
                }
                if (accessible) continue;
                field.setAccessible(false);
            }
            clazz = clazz.getSuperclass();
        }
        return objectInfo;
    }

    protected boolean contains(IdentityHashMap<Object, IlrObjectInfoImpl> objects, Object obj) {
        return objects.containsKey(obj);
    }

    protected IlrObjectInfoImpl get(IdentityHashMap<Object, IlrObjectInfoImpl> objects, Object obj) {
        return objects.get(obj);
    }

    protected IlrObjectInfoImpl addObjectInfo(Object object, IdentityHashMap<Object, IlrObjectInfoImpl> objects) {
        if (object == null) {
            return null;
        }
        IlrObjectInfoImpl objectInfo = new IlrObjectInfoImpl(objects.size(), object.getClass());
        objectInfo.object = object;
        objects.put(object, objectInfo);
        return objectInfo;
    }
}

