/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence.impl;

import ilog.rules.res.model.trace.IlrDWTraceFilter;
import ilog.rules.res.model.trace.IlrDWTraceFilterImpl;
import ilog.rules.res.persistence.trace.IlrCriteria;
import ilog.rules.res.persistence.trace.IlrCriteriaPart;
import ilog.rules.res.persistence.trace.IlrTraceQuery;
import ilog.rules.res.persistence.trace.impl.IlrCriteriaBuilder;

public class IlrTraceQueryImpl
implements IlrTraceQuery {
    private final IlrCriteriaBuilder criteriaBuilder = new IlrCriteriaBuilder();
    public static final String EXECUTION_ID = "executionId";
    public static final String OUTPUT_PARAMETERS = "outputParameters";
    public static final String INPUT_PARAMETERS = "inputParameters";
    public static final String EXECUTION_OUTPUT = "executionOutput";
    public static final String TASKS_EXECUTED = "tasksExecuted";
    public static final String EXECUTION_TRACE = "executionTrace";
    public static final String ALL_TASKS = "allTasks";
    public static final String RULES_FIRED = "rulesFired";
    public static final String ALL_RULES = "allRules";
    public static final String NUMBER_OF_TASKS_NOT_EXECUTED = "numberOfTasksNotExecuted";
    public static final String NUMBER_OF_TASKS_EXECUTED = "numberOfTasksExecuted";
    public static final String NUMBER_OF_TASKS = "numberOfTasks";
    public static final String NUMBER_OF_RULES_NOT_FIRED = "numberOfRulesNotFired";
    public static final String NUMBER_OF_RULES_FIRED = "numberOfRulesFired";
    public static final String NB_RULES = "nbRules";
    public static final String EXECUTION_DURATION = "executionDuration";
    public static final String USER_DATA = "userData";
    public static final String EXECUTED_RULESET_PATH = "executedRulesetPath";
    public static final String REQUEST_RULESET_PATH = "requestRulesetPath";
    public static final String LOCATION = "location";
    public static final String TIME_STAMP = "timeStamp";

    @Override
    public IlrCriteriaPart.IlrCriteriaPartLong timeStamp() {
        return this.criteriaBuilder.createCriteriaPartLong(TIME_STAMP);
    }

    @Override
    public IlrCriteriaPart.IlrCriteriaPartString location() {
        return this.criteriaBuilder.createCriteriaPartString(LOCATION);
    }

    @Override
    public IlrCriteriaPart.IlrCriteriaPartString requestRulesetPath() {
        return this.criteriaBuilder.createCriteriaPartString(REQUEST_RULESET_PATH);
    }

    @Override
    public IlrCriteriaPart.IlrCriteriaPartString executedRulesetPath() {
        return this.criteriaBuilder.createCriteriaPartString(EXECUTED_RULESET_PATH);
    }

    @Override
    public IlrCriteriaPart.IlrCriteriaPartString userData() {
        return this.criteriaBuilder.createCriteriaPartString(USER_DATA);
    }

    @Override
    public IlrCriteriaPart.IlrCriteriaPartLong elapsedTime() {
        return this.criteriaBuilder.createCriteriaPartLong(EXECUTION_DURATION);
    }

    @Override
    public IlrCriteriaPart.IlrCriteriaPartLong nbRules() {
        return this.criteriaBuilder.createCriteriaPartLong(NB_RULES);
    }

    @Override
    public IlrCriteriaPart.IlrCriteriaPartLong nbRulesFired() {
        return this.criteriaBuilder.createCriteriaPartLong(NUMBER_OF_RULES_FIRED);
    }

    @Override
    public IlrCriteriaPart.IlrCriteriaPartLong nbRulesNotFired() {
        return this.criteriaBuilder.createCriteriaPartLong(NUMBER_OF_RULES_NOT_FIRED);
    }

    @Override
    public IlrCriteriaPart.IlrCriteriaPartLong nbTasks() {
        return this.criteriaBuilder.createCriteriaPartLong(NUMBER_OF_TASKS);
    }

    @Override
    public IlrCriteriaPart.IlrCriteriaPartLong nbTasksExecuted() {
        return this.criteriaBuilder.createCriteriaPartLong(NUMBER_OF_TASKS_EXECUTED);
    }

    @Override
    public IlrCriteriaPart.IlrCriteriaPartLong nbTasksNotExecuted() {
        return this.criteriaBuilder.createCriteriaPartLong(NUMBER_OF_TASKS_NOT_EXECUTED);
    }

    @Override
    public IlrCriteriaPart.IlrCriteriaPartString allRules() {
        return this.criteriaBuilder.createCriteriaPartString(ALL_RULES);
    }

    @Override
    public IlrCriteriaPart.IlrCriteriaPartString rulesFired() {
        return this.criteriaBuilder.createCriteriaPartString(RULES_FIRED);
    }

    @Override
    public IlrCriteriaPart.IlrCriteriaPartString allTasks() {
        return this.criteriaBuilder.createCriteriaPartString(ALL_TASKS);
    }

    @Override
    public IlrCriteriaPart.IlrCriteriaPartString executionTrace() {
        return this.criteriaBuilder.createCriteriaPartString(EXECUTION_TRACE);
    }

    @Override
    public IlrCriteriaPart.IlrCriteriaPartString tasksExecuted() {
        return this.criteriaBuilder.createCriteriaPartString(TASKS_EXECUTED);
    }

    @Override
    public IlrCriteriaPart.IlrCriteriaPartString executionOutput() {
        return this.criteriaBuilder.createCriteriaPartString(EXECUTION_OUTPUT);
    }

    @Override
    public IlrCriteriaPart.IlrCriteriaPartString inputParameters() {
        return this.criteriaBuilder.createCriteriaPartString(INPUT_PARAMETERS);
    }

    @Override
    public IlrCriteriaPart.IlrCriteriaPartString outputParameters() {
        return this.criteriaBuilder.createCriteriaPartString(OUTPUT_PARAMETERS);
    }

    @Override
    public IlrCriteriaPart.IlrCriteriaPartString executionId() {
        return this.criteriaBuilder.createCriteriaPartString(EXECUTION_ID);
    }

    @Override
    public IlrDWTraceFilter getFilter() {
        return new IlrDWTraceFilterImpl();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(this.getClass().getName());
        sb.append(" crit='");
        IlrCriteria criteria = this.criteriaBuilder.getResult();
        if (criteria != null) {
            sb.append(criteria.toString());
        }
        sb.append("']");
        return sb.toString();
    }

    @Override
    public IlrCriteria getCriteria() {
        return this.criteriaBuilder.getResult();
    }
}

