/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence.impl.file.helper;

import ilog.rules.archive.IlrRulesetArchive;
import ilog.rules.res.model.IlrAlreadyExistException;
import ilog.rules.res.model.IlrCRERulesetArchive;
import ilog.rules.res.model.IlrDERulesetArchive;
import ilog.rules.res.model.IlrEngineType;
import ilog.rules.res.model.IlrFormatException;
import ilog.rules.res.model.IlrMutableRuleAppInformation;
import ilog.rules.res.model.IlrMutableRulesetArchiveInformation;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.model.IlrRESRulesetArchive;
import ilog.rules.res.model.IlrRepositoryFactory;
import ilog.rules.res.model.IlrVersion;
import ilog.rules.res.model.internal.IlrRESArchiveUtil;
import ilog.rules.res.model.internal.IlrRulesetArchivePropertiesImpl;
import ilog.rules.res.persistence.IlrDAOException;
import ilog.rules.res.persistence.impl.IlrDAOLocalization;
import ilog.rules.res.persistence.impl.file.helper.IlrFile;
import ilog.rules.res.persistence.impl.file.security.IlrDeletePrivilegedAction;
import ilog.rules.res.persistence.impl.file.security.IlrDirectoryNameFilter;
import ilog.rules.res.persistence.impl.file.security.IlrDirectoryVersionFilter;
import ilog.rules.res.persistence.impl.file.security.IlrIsDirectoryPrivilegedAction;
import ilog.rules.res.persistence.impl.file.security.IlrIsFilePrivilegedAction;
import ilog.rules.res.persistence.impl.file.security.IlrListFilesPrivilegedAction;
import ilog.rules.res.persistence.impl.file.security.IlrMkdirsPrivilegedAction;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.UUID;

public class IlrRulesetDir {
    public static final String RESOURCE_BUNDLE_NAME = "ilog.rules.res.persistence.impl.messages";

    public static void load(IlrRepositoryFactory repositoryFactory, File ruleAppDir, IlrMutableRuleAppInformation ruleApp) throws IlrDAOException, IOException, IlrFormatException, IlrAlreadyExistException {
        File[] dirs;
        for (File dir : dirs = IlrListFilesPrivilegedAction.execute(ruleAppDir, new IlrDirectoryNameFilter(false))) {
            File[] versionDirs;
            for (File versionDir : versionDirs = IlrListFilesPrivilegedAction.execute(dir, new IlrDirectoryVersionFilter())) {
                File creationDateFile = new File(versionDir, "creation_date.txt");
                if (!IlrIsFilePrivilegedAction.execute(creationDateFile)) continue;
                Date creationDate = IlrFile.getCreationDate(creationDateFile);
                String displayName = IlrFile.getStringContent(new File(versionDir, "display_name.txt"));
                String description = IlrFile.getStringContent(new File(versionDir, "description.txt"));
                IlrMutableRulesetArchiveInformation ruleset = repositoryFactory.createRuleset(dir.getName(), IlrVersion.parseVersion(versionDir.getName()), creationDate);
                ruleset.setDisplayName(displayName);
                ruleset.setDescription(description);
                ruleApp.addRuleset(ruleset);
            }
        }
    }

    public static File getDir(File repositoryDir, String ruleAppName, IlrVersion ruleAppVersion, String name, IlrVersion version) {
        File ruleAppDir = new File(repositoryDir, ruleAppName);
        File versionRADir = new File(ruleAppDir, ruleAppVersion.toString());
        File rulesetDir = new File(versionRADir, name);
        File versionRSDir = new File(rulesetDir, version.toString());
        if (IlrIsDirectoryPrivilegedAction.execute(versionRSDir)) {
            return versionRSDir;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void add(String name, IlrVersion version, File ruleAppDir, IlrMutableRulesetArchiveInformation ruleset, IlrEngineType engineType, boolean rulesetArchiveExpanded) throws PrivilegedActionException, IOException {
        IlrRulesetArchivePropertiesImpl props;
        InputStream input = null;
        File rulesetDir = new File(ruleAppDir, name);
        File versionDir = new File(rulesetDir, version.toString());
        IlrMkdirsPrivilegedAction.execute(versionDir);
        IlrFile.setCreationDate(new File(versionDir, "creation_date.txt"), ruleset.getCreationDate().getTime());
        IlrFile.setContent(new File(versionDir, "display_name.txt"), ruleset.getDisplayName());
        IlrFile.setContent(new File(versionDir, "description.txt"), ruleset.getDescription());
        IlrRESRulesetArchive resArchive = ruleset.getRESRulesetArchive();
        try {
            if (!rulesetArchiveExpanded) {
                File file;
                if (engineType.equals((Object)IlrEngineType.CRE)) {
                    IlrRulesetArchive archive = ((IlrCRERulesetArchive)resArchive).getRulesetArchive();
                    input = IlrRESArchiveUtil.getRulesetArchiveAsStream(archive);
                    file = new File(versionDir, "ruleset.jar");
                } else if (engineType.equals((Object)IlrEngineType.DE)) {
                    input = ((IlrDERulesetArchive)resArchive).getContentStream();
                    file = new File(versionDir, "ruleset.dsar");
                    props = (IlrRulesetArchivePropertiesImpl)ruleset.getProperties();
                    if (props.get("ruleset.uuid") == null) {
                        ruleset.setProperty("ruleset.uuid", UUID.randomUUID().toString());
                    }
                } else {
                    input = null;
                    file = null;
                }
                IlrFile.setRESRulesetArchive(file, input);
            } else if (resArchive instanceof IlrCRERulesetArchive) {
                IlrRulesetDir.setRulesetArchive(new File(versionDir, "archive"), ((IlrCRERulesetArchive)resArchive).getRulesetArchive());
            }
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
        props = (IlrRulesetArchivePropertiesImpl)ruleset.getProperties();
        IlrFile.setProperties(new File(versionDir, "properties.txt"), props);
    }

    public static void remove(File repositoryDir, IlrPath path) throws PrivilegedActionException {
        File ruleAppDir = new File(repositoryDir, path.getRuleAppName());
        File versionRADir = new File(ruleAppDir, path.getRuleAppVersion().toString());
        File rulesetDir = new File(versionRADir, path.getRulesetName());
        File versionRSDir = new File(rulesetDir, path.getRulesetVersion().toString());
        if (!IlrDeletePrivilegedAction.execute(versionRSDir)) {
            throw new PrivilegedActionException(new IlrDAOException(RESOURCE_BUNDLE_NAME, IlrDAOLocalization.ERROR_CANNOT_DELETE_DIRECTORY, new String[]{versionRSDir.getAbsolutePath()}));
        }
        File[] files = IlrListFilesPrivilegedAction.execute(rulesetDir, null);
        if (!(files != null && files.length != 0 || IlrDeletePrivilegedAction.execute(rulesetDir))) {
            throw new PrivilegedActionException(new IlrDAOException(RESOURCE_BUNDLE_NAME, IlrDAOLocalization.ERROR_CANNOT_DELETE_DIRECTORY, new String[]{rulesetDir.getAbsolutePath()}));
        }
    }

    public static Map<String, String> getProperties(File repositoryDir, IlrPath path) throws IOException {
        File rulesetDir = IlrRulesetDir.getDir(repositoryDir, path.getRuleAppName(), path.getRuleAppVersion(), path.getRulesetName(), path.getRulesetVersion());
        if (rulesetDir != null) {
            Properties props = IlrFile.getProperties(new File(rulesetDir, "properties.txt"));
            HashMap<String, String> result = new HashMap<String, String>(props.size());
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                result.put((String)entry.getKey(), (String)entry.getValue());
            }
            return result;
        }
        return null;
    }

    public static byte[] getRESRulesetArchive(File repositoryDir, IlrPath path, IlrEngineType engineType, boolean rulesetArchiveExpanded) throws PrivilegedActionException, IOException {
        File rulesetDir = IlrRulesetDir.getDir(repositoryDir, path.getRuleAppName(), path.getRuleAppVersion(), path.getRulesetName(), path.getRulesetVersion());
        if (rulesetDir != null) {
            if (!rulesetArchiveExpanded) {
                File rulesetArchiveFile = null;
                rulesetArchiveFile = engineType.equals((Object)IlrEngineType.DE) ? new File(rulesetDir, "ruleset.dsar") : new File(rulesetDir, "ruleset.jar");
                return IlrFile.getContent(rulesetArchiveFile);
            }
            File archiveDir = new File(rulesetDir, "archive");
            if (IlrIsDirectoryPrivilegedAction.execute(archiveDir)) {
                IlrRulesetArchive archive = new IlrRulesetArchive();
                IlrRulesetDir.buildRulesetArchive(archiveDir, null, archive);
                return IlrRESArchiveUtil.getRulesetArchiveAsBytes(archive);
            }
        }
        return null;
    }

    public static IlrRulesetArchive getExpandedCRERulesetArchive(File repositoryDir, IlrPath path, IlrEngineType engineType) throws PrivilegedActionException, IOException {
        File archiveDir;
        File rulesetDir = IlrRulesetDir.getDir(repositoryDir, path.getRuleAppName(), path.getRuleAppVersion(), path.getRulesetName(), path.getRulesetVersion());
        if (rulesetDir != null && IlrIsDirectoryPrivilegedAction.execute(archiveDir = new File(rulesetDir, "archive"))) {
            IlrRulesetArchive archive = new IlrRulesetArchive();
            IlrRulesetDir.buildRulesetArchive(archiveDir, null, archive);
            return archive;
        }
        return null;
    }

    public static boolean setDisplayName(File repositoryDir, IlrPath path, String displayName) throws PrivilegedActionException, IOException {
        File rulesetDir = IlrRulesetDir.getDir(repositoryDir, path.getRuleAppName(), path.getRuleAppVersion(), path.getRulesetName(), path.getRulesetVersion());
        if (rulesetDir != null) {
            IlrFile.setContent(new File(rulesetDir, "display_name.txt"), displayName);
            return true;
        }
        return false;
    }

    public static boolean setDescription(File repositoryDir, IlrPath path, String description) throws PrivilegedActionException, IOException {
        File rulesetDir = IlrRulesetDir.getDir(repositoryDir, path.getRuleAppName(), path.getRuleAppVersion(), path.getRulesetName(), path.getRulesetVersion());
        if (rulesetDir != null) {
            IlrFile.setContent(new File(rulesetDir, "description.txt"), description);
            return true;
        }
        return false;
    }

    public static boolean setProperty(File repositoryDir, IlrPath path, String key, String value) throws PrivilegedActionException, IOException {
        File rulesetDir = IlrRulesetDir.getDir(repositoryDir, path.getRuleAppName(), path.getRuleAppVersion(), path.getRulesetName(), path.getRulesetVersion());
        if (rulesetDir != null) {
            File propertiesFile = new File(rulesetDir, "properties.txt");
            Properties props = IlrFile.getProperties(propertiesFile);
            if (value == null) {
                props.remove(key);
            } else {
                props.setProperty(key, value);
            }
            IlrFile.setProperties(propertiesFile, props);
            return true;
        }
        return false;
    }

    public static boolean setRESRulesetArchive(File repositoryDir, IlrPath path, IlrEngineType engineType, InputStream stream, boolean rulesetArchiveExpanded) throws PrivilegedActionException, IOException {
        File rulesetDir = IlrRulesetDir.getDir(repositoryDir, path.getRuleAppName(), path.getRuleAppVersion(), path.getRulesetName(), path.getRulesetVersion());
        IlrRulesetDir.setProperty(repositoryDir, path, "ruleset.engine", engineType.toString());
        if (rulesetDir != null) {
            if (!rulesetArchiveExpanded) {
                File rulesetArchiveFile = null;
                rulesetArchiveFile = engineType.equals((Object)IlrEngineType.DE) ? new File(rulesetDir, "ruleset.dsar") : new File(rulesetDir, "ruleset.jar");
                IlrFile.setRESRulesetArchive(rulesetArchiveFile, stream);
            } else {
                File archiveDir = new File(rulesetDir, "archive");
                if (engineType == IlrEngineType.CRE) {
                    IlrRulesetDir.setRulesetArchive(archiveDir, IlrRESArchiveUtil.getRulesetArchive(stream));
                } else {
                    throw new UnsupportedOperationException();
                }
            }
            return true;
        }
        return false;
    }

    public static IlrPath getCanonicalRulesetPath(File repositoryDir, String raName, IlrVersion raVersion, String rsName, IlrVersion rsVersion) throws IOException {
        File rulesetDir = IlrRulesetDir.getDir(repositoryDir, raName, raVersion, rsName, rsVersion);
        if (rulesetDir != null && IlrRulesetDir.isRulesetEnabled(rulesetDir)) {
            return new IlrPath(raName, raVersion, rsName, rsVersion);
        }
        return null;
    }

    public static IlrPath getCanonicalRulesetPath(File repositoryDir, String raName, IlrVersion raVersion, String rsName) throws IlrFormatException, IOException {
        File ruleAppDir = new File(repositoryDir, raName);
        File versionRADir = new File(ruleAppDir, raVersion.toString());
        File rulesetDir = new File(versionRADir, rsName);
        File[] dirs = IlrListFilesPrivilegedAction.execute(rulesetDir, new IlrDirectoryVersionFilter());
        if (dirs != null) {
            TreeMap map = new TreeMap(Collections.reverseOrder());
            for (File dir : dirs) {
                map.put(IlrVersion.parseVersion(dir.getName()), dir);
            }
            for (Map.Entry entry : map.entrySet()) {
                File dir = (File)entry.getValue();
                if (!IlrRulesetDir.isRulesetEnabled(dir)) continue;
                return new IlrPath(raName, raVersion, rsName, (IlrVersion)entry.getKey());
            }
        }
        return null;
    }

    public static IlrPath getCanonicalRulesetPath(File repositoryDir, String raName, String rsName, IlrVersion rsVersion) throws IlrFormatException, IOException {
        File raDir = new File(repositoryDir, raName);
        File[] dirs = IlrListFilesPrivilegedAction.execute(raDir, new IlrDirectoryVersionFilter());
        if (dirs != null) {
            TreeMap map = new TreeMap(Collections.reverseOrder());
            for (File dir : dirs) {
                map.put(IlrVersion.parseVersion(dir.getName()), dir);
            }
            for (Map.Entry entry : map.entrySet()) {
                File ruleAppDir = (File)entry.getValue();
                File rulesetDir = new File(new File(ruleAppDir, rsName), rsVersion.toString());
                if (!IlrIsDirectoryPrivilegedAction.execute(rulesetDir) || !IlrRulesetDir.isRulesetEnabled(rulesetDir)) continue;
                return new IlrPath(raName, (IlrVersion)entry.getKey(), rsName, rsVersion);
            }
        }
        return null;
    }

    public static IlrPath getCanonicalRulesetPath(File repositoryDir, String raName, String rsName) throws IlrFormatException, IOException {
        File raDir = new File(repositoryDir, raName);
        File[] ruleAppDirs = IlrListFilesPrivilegedAction.execute(raDir, new IlrDirectoryVersionFilter());
        if (ruleAppDirs != null) {
            TreeMap ruleAppDirMap = new TreeMap(Collections.reverseOrder());
            for (File dir : ruleAppDirs) {
                ruleAppDirMap.put(IlrVersion.parseVersion(dir.getName()), dir);
            }
            for (Map.Entry ruleAppDirEntry : ruleAppDirMap.entrySet()) {
                File ruleAppDir = (File)ruleAppDirEntry.getValue();
                File rsDir = new File(ruleAppDir, rsName);
                File[] rulesetDirs = IlrListFilesPrivilegedAction.execute(rsDir, new IlrDirectoryVersionFilter());
                if (rulesetDirs == null) continue;
                TreeMap rulesetDirMap = new TreeMap(Collections.reverseOrder());
                for (File dir : rulesetDirs) {
                    rulesetDirMap.put(IlrVersion.parseVersion(dir.getName()), dir);
                }
                for (Map.Entry rulesetDirEntry : rulesetDirMap.entrySet()) {
                    File dir = (File)rulesetDirEntry.getValue();
                    if (!IlrRulesetDir.isRulesetEnabled(dir)) continue;
                    return new IlrPath(raName, (IlrVersion)ruleAppDirEntry.getKey(), rsName, (IlrVersion)rulesetDirEntry.getKey());
                }
            }
        }
        return null;
    }

    private static void setRulesetArchive(File archiveDir, IlrRulesetArchive archive) throws PrivilegedActionException, IOException {
        IlrDeletePrivilegedAction.execute(archiveDir);
        for (IlrRulesetArchive.Element element : archive.getElements()) {
            File elementFile = IlrFile.keyToFile(archiveDir, element.getKey());
            IlrMkdirsPrivilegedAction.execute(elementFile.getParentFile());
            IlrFile.setContent(elementFile, element.getContent());
        }
    }

    private static void buildRulesetArchive(File file, String key, IlrRulesetArchive rulesetArchive) throws PrivilegedActionException, IOException {
        File[] childs = IlrListFilesPrivilegedAction.execute(file, null);
        if (childs != null) {
            key = key != null ? key + "/" : "";
            for (File child : childs) {
                IlrRulesetDir.buildRulesetArchive(child, key + child.getName(), rulesetArchive);
            }
        } else {
            IlrRulesetArchive ilrRulesetArchive = rulesetArchive;
            ilrRulesetArchive.getClass();
            IlrRulesetArchive.Element elt = ilrRulesetArchive.new IlrRulesetArchive.Element(key);
            elt.setContent(IlrFile.getContent(file));
            rulesetArchive.addElement(elt);
        }
    }

    private static boolean isRulesetEnabled(File rulesetDir) throws IOException {
        Properties props = IlrFile.getProperties(new File(rulesetDir, "properties.txt"));
        String status = props.getProperty("ruleset.status", "enabled");
        return "enabled".equals(status);
    }
}

