/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence.impl.jdbc.helper;

import com.ibm.rules.res.logging.internal.RESLogger;
import ilog.rules.res.model.IlrRuleAppProperties;
import ilog.rules.res.persistence.impl.jdbc.IlrDAOConfigurator;
import ilog.rules.res.persistence.impl.jdbc.helper.IlrDatabaseUtility;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class IlrRuleAppPropertiesTable {
    private static final RESLogger LOGGER = RESLogger.getRESLogger("com.ibm.rules.res.persistence.sql", "ilog.rules.res.persistence.impl.messages");
    private static final String SQLST_SELECT_RULEAPP_PROPERTIES = "select_ruleapp_properties";
    private static final String SQLST_DELETE_RULEAPP_PROPERTY = "delete_ruleapp_property";
    private static final String SQLST_INSERT_RULEAPP_PROPERTY = "insert_ruleapp_property";
    private static final String SQLST_DELETE_RULEAPP_PROPERTIES = "delete_ruleapp_properties";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> get(IlrDAOConfigurator configurator, Connection connection, int ruleAppId) throws SQLException {
        HashMap<String, String> hashMap;
        String sqlStatement = configurator.getSQLStatement(SQLST_SELECT_RULEAPP_PROPERTIES);
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            statement.setInt(1, ruleAppId);
            HashMap<String, String> props = new HashMap<String, String>();
            ArrayList<String> parameterValues = new ArrayList<String>();
            if (LOGGER.isLoggable(Level.FINEST)) {
                parameterValues.add(String.valueOf(ruleAppId));
            }
            rs = IlrDatabaseUtility.executeQuery(statement, sqlStatement, parameterValues);
            while (rs.next()) {
                String value = rs.getString(2);
                if (value == null) {
                    value = "";
                }
                props.put(rs.getString(1), value);
            }
            hashMap = props;
        }
        catch (Throwable throwable) {
            IlrDatabaseUtility.closeStatement(statement);
            IlrDatabaseUtility.closeResultSet(rs);
            throw throwable;
        }
        IlrDatabaseUtility.closeStatement(statement);
        IlrDatabaseUtility.closeResultSet(rs);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean insert(IlrDAOConfigurator configurator, Connection connection, int ruleAppId, String key, String value) throws SQLException {
        String sqlStatement = configurator.getSQLStatement(SQLST_INSERT_RULEAPP_PROPERTY);
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            statement.setInt(1, ruleAppId);
            statement.setString(2, key);
            statement.setString(3, value);
            ArrayList<String> parameterValues = new ArrayList<String>();
            if (LOGGER.isLoggable(Level.FINEST)) {
                parameterValues.add(String.valueOf(ruleAppId));
                parameterValues.add(key);
                parameterValues.add(value);
            }
            boolean bl = IlrDatabaseUtility.executeUpdate(statement, sqlStatement, parameterValues) == 1;
            return bl;
        }
        finally {
            IlrDatabaseUtility.closeStatement(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(IlrDAOConfigurator configurator, Connection connection, int ruleAppId, IlrRuleAppProperties props) throws SQLException {
        String sqlStatement = configurator.getSQLStatement(SQLST_INSERT_RULEAPP_PROPERTY);
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            HashMap<Integer, List<String>> parameterValues = new HashMap<Integer, List<String>>();
            int line = 0;
            for (Map.Entry entry : props.entrySet()) {
                statement.setInt(1, ruleAppId);
                statement.setString(2, (String)entry.getKey());
                statement.setString(3, (String)entry.getValue());
                statement.addBatch();
                if (!LOGGER.isLoggable(Level.FINEST)) continue;
                ArrayList<String> lineValues = new ArrayList<String>();
                lineValues.add(String.valueOf(ruleAppId));
                lineValues.add((String)entry.getKey());
                lineValues.add((String)entry.getValue());
                parameterValues.put(line, lineValues);
                ++line;
            }
            IlrDatabaseUtility.executeBatch(statement, sqlStatement, parameterValues);
        }
        finally {
            IlrDatabaseUtility.closeStatement(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean delete(IlrDAOConfigurator configurator, Connection connection, String key, int ruleAppId) throws SQLException {
        String sqlStatement = configurator.getSQLStatement(SQLST_DELETE_RULEAPP_PROPERTY);
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            statement.setString(1, key);
            statement.setInt(2, ruleAppId);
            ArrayList<String> parameterValues = new ArrayList<String>();
            if (LOGGER.isLoggable(Level.FINEST)) {
                parameterValues.add(key);
                parameterValues.add(String.valueOf(ruleAppId));
            }
            boolean bl = IlrDatabaseUtility.executeUpdate(statement, sqlStatement, parameterValues) == 1;
            return bl;
        }
        finally {
            IlrDatabaseUtility.closeStatement(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(IlrDAOConfigurator configurator, Connection connection, int ruleAppId) throws SQLException {
        String sqlStatement = configurator.getSQLStatement(SQLST_DELETE_RULEAPP_PROPERTIES);
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            statement.setInt(1, ruleAppId);
            ArrayList<String> parameterValues = new ArrayList<String>();
            if (LOGGER.isLoggable(Level.FINEST)) {
                parameterValues.add(String.valueOf(ruleAppId));
            }
            IlrDatabaseUtility.executeUpdate(statement, sqlStatement, parameterValues);
        }
        finally {
            IlrDatabaseUtility.closeStatement(statement);
        }
    }
}

