/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence.trace.impl;

import ilog.rules.res.persistence.trace.IlrCriteriaPlain;
import ilog.rules.res.persistence.trace.IlrPartOperator;
import ilog.rules.res.persistence.trace.impl.IlrCriteriaBuilder;
import ilog.rules.res.persistence.trace.impl.IlrCriteriaImpl;
import ilog.rules.res.persistence.trace.impl.IlrTraceLocalization;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;

public class IlrCriteriaPlainImpl<T>
extends IlrCriteriaImpl
implements IlrCriteriaPlain<T> {
    private final String name;
    private final IlrPartOperator operator;
    private final T other;
    private BeanInfo beanInfo;

    public IlrCriteriaPlainImpl(IlrCriteriaBuilder builder, String name, IlrPartOperator operator, T other) {
        super(builder);
        this.name = name;
        this.operator = operator;
        this.other = other;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IlrPartOperator getOperator() {
        return this.operator;
    }

    @Override
    public T getOther() {
        return this.other;
    }

    @Override
    public boolean matches(Object o) throws IllegalAccessException, InvocationTargetException, IntrospectionException {
        Object extractedValue = this.extractValue(o);
        return this.operator.apply(extractedValue, this.other);
    }

    private Object extractValue(Object o) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        if (this.beanInfo == null) {
            this.beanInfo = Introspector.getBeanInfo(o.getClass());
        }
        PropertyDescriptor[] pds = this.beanInfo.getPropertyDescriptors();
        PropertyDescriptor descriptor = null;
        for (PropertyDescriptor pd : pds) {
            if (!pd.getName().equals(this.name)) continue;
            descriptor = pd;
            break;
        }
        if (descriptor != null) {
            return descriptor.getReadMethod().invoke(o, new Object[0]);
        }
        throw new IllegalAccessException(IlrTraceLocalization.HELPER.getLocalizedMessage(IlrTraceLocalization.ERROR_NOT_A_NUMBER, new Object[]{this.name, o.toString()}));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String theName = this.name;
        if (theName == null) {
            theName = "null";
        }
        sb.append(theName);
        String theOperator = "null";
        if (this.operator != null) {
            theOperator = this.operator.toString();
        }
        sb.append(theOperator);
        String theOther = "null";
        if (this.other != null) {
            theOther = this.other.toString();
        }
        sb.append(theOther);
        return sb.toString();
    }
}

