/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence.trace.impl;

import ilog.rules.res.persistence.trace.IlrTraceDAOException;
import ilog.rules.res.persistence.trace.IlrTraceDAOFactory;
import ilog.rules.res.persistence.trace.impl.IlrTraceLocalization;
import java.util.Map;

public class IlrTraceDAOFactoryProvider {
    public static IlrTraceDAOFactory createTraceDaoFactory(Map<String, String> properties, ClassLoader classLoader) throws IlrTraceDAOException {
        String factoryClassName = properties.get("factoryClassname");
        if (factoryClassName == null) {
            throw IlrTraceLocalization.newIlrTraceDAOException(IlrTraceLocalization.NO_TRACE_DAO_FACTORY_ERROR);
        }
        if (classLoader == null) {
            classLoader = IlrTraceDAOFactoryProvider.class.getClassLoader();
        }
        try {
            Class<?> clazz = Class.forName(factoryClassName, true, classLoader);
            Object o = clazz.newInstance();
            IlrTraceDAOFactory f = (IlrTraceDAOFactory)o;
            f.initialize(properties);
            return f;
        }
        catch (Exception e) {
            throw IlrTraceLocalization.newIlrTraceDAOException(IlrTraceLocalization.TRACE_DAO_CREATION_ERROR, new String[]{factoryClassName}, e);
        }
    }
}

