/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence.trace.impl.jdbc;

import ilog.rules.res.persistence.IlrDAOException;
import ilog.rules.res.persistence.impl.jdbc.IlrDriverConnectionProvider;
import ilog.rules.res.persistence.impl.jdbc.IlrJDBCConnectionProvider;
import ilog.rules.res.persistence.trace.impl.IlrTraceLocalization;
import ilog.rules.res.persistence.trace.impl.jdbc.IlrGenericTraceDAOFactory;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;

public class IlrDriverTraceDAOFactory
extends IlrGenericTraceDAOFactory {
    public static final String DRIVER_CLASS_NAME = "driver-classname";
    public static final String CONNECTION_URL = "driver-url";
    public static final String CONNECTION_USERNAME = "driver-user";
    public static final String CONNECTION_PASSWORD = "driver-password";
    public static final String CLASSPATH = "classpath";
    private static final String USER = "user";
    private static final String PASSWORD = "password";
    private Driver driver;
    private String url;
    private String driverClassName;
    private ClassLoader cl;
    private Properties connProperties;

    @Override
    protected IlrJDBCConnectionProvider initializeConnectionProvider(Map<String, String> properties) throws IlrDAOException {
        this.initProperties = properties;
        this.driverClassName = properties.get(DRIVER_CLASS_NAME);
        this.url = properties.get(CONNECTION_URL);
        String classpath = properties.get(CLASSPATH);
        String user = this.putIfNotNullOrEmpty(properties, USER, properties.get(CONNECTION_USERNAME));
        String password = this.putIfNotNullOrEmpty(properties, PASSWORD, properties.get(CONNECTION_PASSWORD));
        try {
            Class<?> clazz = null;
            if (classpath != null && classpath.length() > 0) {
                String[] jars;
                ArrayList<URL> urls = new ArrayList<URL>();
                for (String jar : jars = classpath.split(";")) {
                    urls.add(this.getClass().getClassLoader().getResource("lib/" + jar));
                }
                this.cl = new URLClassLoader(urls.toArray(new URL[0]), this.getClass().getClassLoader());
                clazz = Class.forName(this.driverClassName, true, this.cl);
            } else {
                this.cl = this.getClass().getClassLoader();
                clazz = Class.forName(this.driverClassName);
            }
            this.driver = (Driver)clazz.newInstance();
            this.connProperties = new Properties();
            this.putIfNotNullOrEmpty(this.connProperties, USER, user);
            this.putIfNotNullOrEmpty(this.connProperties, PASSWORD, password);
            return new IlrDriverConnectionProvider(this.driver, this.url, this.connProperties);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw IlrTraceLocalization.newIlrDAOException(IlrTraceLocalization.DRIVER_INSTANCIATION_ERROR, new String[]{this.driverClassName});
        }
    }

    private String putIfNotNullOrEmpty(Map properties, String key, String value) {
        if (value != null && value.length() != 0) {
            properties.put(key, value);
        }
        return value;
    }
}

