/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence.trace.impl.jdbc;

import ilog.rules.res.persistence.trace.IlrBooleanCriteria;
import ilog.rules.res.persistence.trace.IlrCriteria;
import ilog.rules.res.persistence.trace.IlrCriteriaPlain;
import ilog.rules.res.persistence.trace.IlrPartOperator;
import ilog.rules.res.persistence.trace.impl.operators.IlrMapContainsOperator;
import ilog.rules.res.persistence.trace.impl.operators.IlrStringCollectionContainsOperator;
import ilog.rules.res.persistence.trace.impl.operators.IlrStringContainsOperator;
import ilog.rules.res.persistence.trace.impl.sql.IlrPreparedStatementPart;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class TracesSQLWriter {
    static final String REQUESTED_PATH_COLUMN = "REQUEST_PATH";
    static final String EXECUTED_PATH_COLUMN = "CANONICAL_PATH";
    static final String ALL_RULES_COLUMN = "RULES";
    static final String ALL_TASKS_COLUMN = "TASKS";
    static final String EXEC_OUTPUT_COLUMN = "EXEC_OUTPUT";
    static final String IN_PARAMS_COLUMN = "INPUT_PARAMS";
    static final String OUT_PARAMS_COLUMN = "OUTPUT_PARAMS";
    static final String EXEC_DURATION_COLUMN = "ELAPSED_TIME";
    static final String NB_RULES_FIRED_COLUMN = "NB_RULES_FIRED";
    static final String NB_RULES_NOT_FIRED_COLUMN = "NB_RULES_NOT_FIRED";
    static final String NB_TASKS_EXECUTED_COLUMN = "NB_TASKS_EXECUTED";
    static final String NB_TASKS_NOT_EXECUTED_COLUMN = "NB_TASKS_NOT_EXECUTED";
    static final String EXEC_TRACE_COLUMN = "EXECUTION_TRACE_TREE";
    private static final String LIKE_SQL_OPERATOR = " LIKE ";
    private final Map<String, String> nameToColumnMappings = new HashMap<String, String>();

    public TracesSQLWriter() {
        this.addNameColumnMapping("requestRulesetPath", REQUESTED_PATH_COLUMN);
        this.addNameColumnMapping("executedRulesetPath", EXECUTED_PATH_COLUMN);
        this.addNameColumnMapping("allRules", ALL_RULES_COLUMN);
        this.addNameColumnMapping("allTasks", ALL_TASKS_COLUMN);
        this.addNameColumnMapping("executionOutput", EXEC_OUTPUT_COLUMN);
        this.addNameColumnMapping("inputParameters", IN_PARAMS_COLUMN);
        this.addNameColumnMapping("outputParameters", OUT_PARAMS_COLUMN);
        this.addNameColumnMapping("executionDuration", EXEC_DURATION_COLUMN);
        this.addNameColumnMapping("numberOfRulesFired", NB_RULES_FIRED_COLUMN);
        this.addNameColumnMapping("numberOfRulesNotFired", NB_RULES_NOT_FIRED_COLUMN);
        this.addNameColumnMapping("numberOfTasksExecuted", NB_TASKS_EXECUTED_COLUMN);
        this.addNameColumnMapping("numberOfTasksNotExecuted", NB_TASKS_NOT_EXECUTED_COLUMN);
        this.addNameColumnMapping("executionTrace", EXEC_TRACE_COLUMN);
    }

    protected void addNameColumnMapping(String propertyName, String columnName) {
        this.nameToColumnMappings.put(propertyName, columnName);
    }

    public String toColumnNameListSQL(IlrCriteria criteria, Map<String, String> exception) {
        StringBuffer res = new StringBuffer();
        if (criteria instanceof IlrCriteriaPlain) {
            IlrCriteriaPlain plain = (IlrCriteriaPlain)criteria;
            if (!exception.containsKey(this.convertCriteriaNameToColumnName(plain))) {
                res.append(",");
                res.append(this.convertCriteriaNameToColumnName(plain));
            }
        } else if (criteria instanceof IlrBooleanCriteria) {
            IlrBooleanCriteria bool = (IlrBooleanCriteria)criteria;
            res.append(this.toColumnNameListSQL(bool.getCriteria1(), exception));
            res.append(this.toColumnNameListSQL(bool.getCriteria2(), exception));
        }
        return res.toString();
    }

    private String convertCriteriaNameToColumnName(IlrCriteriaPlain criteriaPlain) {
        String name = criteriaPlain.getName();
        String converted = this.nameToColumnMappings.get(name);
        if (converted == null) {
            converted = this.convertCamelCasedNameToSQLStyle(name);
        }
        return converted;
    }

    private String convertCamelCasedNameToSQLStyle(String name) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append("_");
            }
            sb.append(Character.toUpperCase(c));
        }
        return sb.toString();
    }

    public IlrPreparedStatementPart toPreparedStatementPart(IlrCriteria criteria) {
        CriteriaToPreparedStatementConverter converter = new CriteriaToPreparedStatementConverter();
        return converter.convert(criteria);
    }

    private class CriteriaToPreparedStatementConverter {
        private CriteriaToPreparedStatementConverter() {
        }

        public IlrPreparedStatementPart convert(IlrCriteria criteria) {
            if (criteria instanceof IlrBooleanCriteria) {
                IlrBooleanCriteria bool = (IlrBooleanCriteria)criteria;
                return this.interpretBooleanCriteria(bool);
            }
            IlrCriteriaPlain plain = (IlrCriteriaPlain)criteria;
            return this.convertPlainCriteria(plain);
        }

        private IlrPreparedStatementPart convertPlainCriteria(IlrCriteriaPlain<?> plain) {
            StringBuffer sql = this.createSQLForPlainCriteria(plain);
            List<Object> values = this.createValuesForPlainCriteria(plain);
            return this.createStatementPart(sql, values);
        }

        private List<Object> createValuesForPlainCriteria(IlrCriteriaPlain<?> plain) {
            Object valueToAdd = plain.getOther();
            if (TracesSQLWriter.LIKE_SQL_OPERATOR.equals(this.convertToSQLTokenWithSpaces(plain.getOperator())) && valueToAdd != null && valueToAdd instanceof String) {
                valueToAdd = new StringBuffer("%").append(valueToAdd).append("%").toString();
            }
            LinkedList<Object> values = new LinkedList<Object>();
            values.add(valueToAdd);
            return values;
        }

        private StringBuffer createSQLForPlainCriteria(IlrCriteriaPlain<?> plain) {
            StringBuffer sql = new StringBuffer();
            sql.append(TracesSQLWriter.this.convertCriteriaNameToColumnName(plain));
            sql.append(this.convertToSQLTokenWithSpaces(plain.getOperator()));
            sql.append("?");
            return sql;
        }

        private IlrPreparedStatementPart createStatementPart(StringBuffer sql, List<Object> values) {
            IlrPreparedStatementPart part = new IlrPreparedStatementPart();
            part.setSQL(sql.toString());
            part.setValues(values);
            return part;
        }

        private IlrPreparedStatementPart interpretBooleanCriteria(IlrBooleanCriteria bool) {
            IlrPreparedStatementPart part1 = this.convert(bool.getCriteria1());
            IlrPreparedStatementPart part2 = this.convert(bool.getCriteria2());
            StringBuffer sql = this.createSQLForBooleanCriteria(bool, part1, part2);
            List<Object> values = this.createValuesForBooleanCriteria(part1, part2);
            return this.createStatementPart(sql, values);
        }

        private List<Object> createValuesForBooleanCriteria(IlrPreparedStatementPart part1, IlrPreparedStatementPart part2) {
            LinkedList<Object> values = new LinkedList<Object>();
            values.addAll(part1.getValues());
            values.addAll(part2.getValues());
            return values;
        }

        private StringBuffer createSQLForBooleanCriteria(IlrBooleanCriteria bool, IlrPreparedStatementPart part1, IlrPreparedStatementPart part2) {
            StringBuffer sql = new StringBuffer();
            sql.append("(");
            sql.append(part1.getSQL());
            sql.append(this.convertToSQLTokenWithSpaces(bool));
            sql.append(part2.getSQL());
            sql.append(")");
            return sql;
        }

        private String convertToSQLTokenWithSpaces(IlrBooleanCriteria bool) {
            return " " + bool.getOperator() + " ";
        }

        private String convertToSQLTokenWithSpaces(IlrPartOperator partOperator) {
            if (partOperator instanceof IlrStringContainsOperator || partOperator instanceof IlrStringCollectionContainsOperator || partOperator instanceof IlrMapContainsOperator) {
                return TracesSQLWriter.LIKE_SQL_OPERATOR;
            }
            return partOperator.toString();
        }
    }
}

