/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence.trace.impl.sql;

import ilog.rules.res.persistence.trace.impl.sql.IlrPreparedStatementPartSQLException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class IlrPreparedStatementPart {
    private String sql = "";
    private List<Object> values = new ArrayList<Object>();

    public String getSQL() {
        return this.sql;
    }

    public void setSQL(String sql) {
        this.sql = sql;
        if (this.sql == null) {
            this.sql = "";
        }
    }

    public List<Object> getValues() {
        return this.values;
    }

    public void setValues(List<Object> values) {
        this.values = values;
        if (this.values == null) {
            this.values = new ArrayList<Object>();
        }
    }

    public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
        try {
            PreparedStatement returnedValue = connection.prepareStatement(this.sql);
            int parameterIndex = 1;
            for (Object value : this.values) {
                returnedValue.setObject(parameterIndex, value);
                ++parameterIndex;
            }
            return returnedValue;
        }
        catch (SQLException e) {
            throw new IlrPreparedStatementPartSQLException(this, e);
        }
    }

    public boolean isEmpty() {
        return this.sql.length() == 0;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append("[");
        res.append(super.toString());
        res.append(" sql='");
        res.append(this.sql);
        res.append("' values='");
        Iterator<Object> it = this.values.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o == null) {
                res.append("null");
            } else {
                res.append(o.toString());
            }
            if (!it.hasNext()) continue;
            res.append(", ");
        }
        res.append("']");
        return res.toString();
    }
}

