/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.session;

import com.ibm.rules.res.logging.internal.RESLogger;
import com.ibm.rules.res.xu.client.internal.PluginConfigImpl;
import com.ibm.rules.res.xu.client.internal.XUClient;
import com.ibm.rules.res.xu.config.internal.PersistenceConfig;
import com.ibm.rules.res.xu.config.internal.PluginConfig;
import com.ibm.rules.res.xu.config.internal.PoolConfig;
import com.ibm.rules.res.xu.config.internal.RulesetCacheConfig;
import com.ibm.rules.res.xu.config.internal.XUConfig;
import com.ibm.rules.res.xu.internal.XUException;
import com.ibm.rules.util.ffdc.FFDCLogger;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.session.IlrManagementSession;
import ilog.rules.res.session.IlrSessionCreationException;
import ilog.rules.res.session.IlrStatefulSession;
import ilog.rules.res.session.IlrStatelessSession;
import ilog.rules.res.session.config.IlrPersistenceType;
import ilog.rules.res.session.config.IlrPluginConfig;
import ilog.rules.res.session.config.IlrPoolConfig;
import ilog.rules.res.session.config.IlrSessionFactoryConfig;
import ilog.rules.res.session.config.IlrXUConfig;
import ilog.rules.res.session.config.internal.IlrConfigFiles;
import ilog.rules.res.session.config.internal.IlrDecisionWarehouseDAOConfigImpl;
import ilog.rules.res.session.config.internal.IlrPersistenceConfigImpl;
import ilog.rules.res.session.config.internal.IlrPropertyMapConfig;
import ilog.rules.res.session.config.internal.IlrSessionFactoryConfigImpl;
import ilog.rules.res.session.config.internal.IlrXOMPersistenceConfigImpl;
import ilog.rules.res.session.config.internal.IlrXUConfigImpl;
import ilog.rules.res.session.impl.IlrSessionFactoryBase;
import ilog.rules.res.session.impl.j2se.IlrManagementSessionJ2SE;
import ilog.rules.res.session.impl.j2se.IlrStatefulSessionJ2SE;
import ilog.rules.res.session.impl.j2se.IlrStatelessSessionJ2SE;
import ilog.rules.res.session.interceptor.IlrSessionInterceptorException;
import ilog.rules.res.session.util.IlrSessionLocalization;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class IlrJ2SESessionFactory
extends IlrSessionFactoryBase {
    private static final String CREATE_XU_CLIENT_FAILURE_ID = "151";
    private XUClient xuClient;
    private PrintWriter output;
    private final IlrSessionFactoryConfigImpl factoryConfig;
    private RESLogger log = IlrSessionLocalization.LOGGER;

    public IlrJ2SESessionFactory() {
        this((IlrSessionFactoryConfig)null);
    }

    public IlrJ2SESessionFactory(PrintWriter logWriter) {
        this((IlrSessionFactoryConfig)null);
        this.output = logWriter;
    }

    public IlrJ2SESessionFactory(IlrSessionFactoryConfig config) {
        super(config == null ? null : config.getXOMClassLoader());
        this.factoryConfig = (IlrSessionFactoryConfigImpl)config;
        if (config != null) {
            this.output = config.getXUConfig().getLogWriter();
        }
    }

    public static IlrSessionFactoryConfig createDefaultConfig() {
        return new IlrSessionFactoryConfigImpl();
    }

    @Override
    public IlrStatelessSession createStatelessSession() throws IlrSessionCreationException {
        try {
            return new IlrStatelessSessionJ2SE(this, this.getXUClient(), this.getXOMClassLoader());
        }
        catch (Exception e) {
            throw new IlrSessionCreationException(e);
        }
    }

    @Override
    public IlrStatefulSession createStatefulSession(IlrPath rulesetPath, Serializable userData, Map<String, Object> initParameters, boolean forceUptodate, boolean enableInterceptor) throws IlrSessionCreationException {
        try {
            return new IlrStatefulSessionJ2SE(this.getXUClient(), this, rulesetPath, userData, initParameters, forceUptodate, enableInterceptor);
        }
        catch (XUException xue) {
            throw new IlrSessionCreationException(xue);
        }
        catch (IlrSessionInterceptorException e) {
            throw new IlrSessionCreationException(e);
        }
    }

    @Override
    public IlrManagementSession createManagementSession() throws IlrSessionCreationException {
        return new IlrManagementSessionJ2SE(this.getXUClient(), this.getXOMClassLoader());
    }

    @Override
    protected Map<String, String> getTraceDAOConfigurationMap() {
        if (this.factoryConfig == null) {
            return IlrConfigFiles.readTraceDAOConfiguration();
        }
        return this.makeTraceDAOConfiguration(this.factoryConfig.getDecisionWarehouseDAOConfig());
    }

    private Map<String, String> makeTraceDAOConfiguration(IlrDecisionWarehouseDAOConfigImpl dwDAOConfig) {
        HashMap<String, String> result = new HashMap<String, String>(dwDAOConfig.getFactoryProperties());
        result.put("factoryClassname", dwDAOConfig.getFactoryClassName());
        return result;
    }

    protected XUClient createXUClient() throws XUException {
        InputStream is = null;
        try {
            XUClient xuClient = XUClient.createJ2SEXUClient(this.getOutput());
            if (this.factoryConfig == null) {
                is = this.findXUDescriptorStream();
                this.log.info(IlrSessionLocalization.LOADING_XU_SETTINGS_INFO, null);
                xuClient.getConfig().loadJCADescriptor(is);
            } else {
                is = IlrConfigFiles.getDefaultXUDescriptorStream();
                this.log.info(IlrSessionLocalization.LOADING_DEFAULT_SETTINGS_INFO, new String[]{"META-INF/default_ra.xml"});
                xuClient.getConfig().loadJCADescriptor(is);
                this.applyFactoryConfigToXU(xuClient);
            }
            return xuClient;
        }
        catch (XUException e) {
            FFDCLogger.log(e, this, this.getClass().getName(), CREATE_XU_CLIENT_FAILURE_ID, "xuDescriptorStream=" + is, "factoryConfig=" + this.factoryConfig);
            throw e;
        }
    }

    protected InputStream findXUDescriptorStream() {
        return IlrConfigFiles.findXUDescriptorStream();
    }

    private void applyFactoryConfigToXU(XUClient xuClient) throws XUException {
        if (this.factoryConfig == null) {
            return;
        }
        this.log.info(IlrSessionLocalization.APPLYING_FACTORY_CONFIGURATION_INFO, null);
        IlrXUConfigImpl factoryXUConfig = this.factoryConfig.getXUConfig();
        XUConfig xuConfig = xuClient.getConfig();
        IlrJ2SESessionFactory.copyPoolConfig(xuConfig.getDocumentBuilderPoolConfig(), factoryXUConfig.getDocumentBuilderPoolConfig());
        IlrJ2SESessionFactory.copyPoolConfig(xuConfig.getTransformerPoolConfig(), factoryXUConfig.getTransformerPoolConfig());
        IlrJ2SESessionFactory.copyPoolConfig(xuConfig.getConnectionPoolConfig(), factoryXUConfig.getConnectionPoolConfig());
        this.copyRulesetsAndXOMPersistenceConfig(xuConfig, factoryXUConfig);
        this.copyRulesetCacheConfig(xuConfig, factoryXUConfig);
        this.copyPluginConfigs(xuConfig, factoryXUConfig);
        this.applyLogLevelIfNotNull(xuConfig, factoryXUConfig);
        this.applyLogAutoFlush(xuConfig, factoryXUConfig);
        this.applyAsynchronousRulesetParsing(xuConfig, factoryXUConfig);
        this.applyRulesetUsageMonitorEnabled(xuConfig, factoryXUConfig);
    }

    private void applyAsynchronousRulesetParsing(XUConfig xuConfig, IlrXUConfigImpl factoryXUConfig) throws XUException {
        boolean asyncRulesetParsingEnabled = factoryXUConfig.isAsynchronousRulesetParsingEnabled();
        xuConfig.setAsynchronousRulesetParsingEnabled(asyncRulesetParsingEnabled);
    }

    private void applyLogLevelIfNotNull(XUConfig xuConfig, IlrXUConfig factoryXUConfig) throws XUException {
        Level loglevel = factoryXUConfig.getLoglevel();
        if (loglevel != null) {
            xuConfig.setLogLevel(loglevel);
        }
    }

    private void applyLogAutoFlush(XUConfig xuConfig, IlrXUConfig factoryXUConfig) throws XUException {
        boolean logAutoFlush = factoryXUConfig.isLogAutoFlushEnabled();
        xuConfig.setLogAutoFlush(logAutoFlush);
    }

    private void copyRulesetCacheConfig(XUConfig xuConfig, IlrXUConfigImpl factoryXUConfig) throws XUException {
        Map<String, String> factoryProperties = factoryXUConfig.getRulesetCacheConfig().getProperties();
        RulesetCacheConfig xuRSCacheConfig = xuConfig.getRulesetCacheConfig();
        for (Map.Entry<String, String> entry : factoryProperties.entrySet()) {
            xuRSCacheConfig.putProperty(entry.getKey(), entry.getValue());
        }
    }

    private void copyPluginConfigs(XUConfig xuConfig, IlrXUConfig factoryXUConfig) throws XUException {
        List<IlrPluginConfig> factoryPluginConfigs = factoryXUConfig.getPluginConfigs();
        LinkedList<PluginConfig> configs = new LinkedList<PluginConfig>();
        for (IlrPluginConfig config : factoryPluginConfigs) {
            configs.add(this.copyFactoryPluginConfig(config));
        }
        xuConfig.setPluginConfigs(configs);
    }

    private PluginConfigImpl copyFactoryPluginConfig(IlrPluginConfig config) {
        PluginConfigImpl pcfg = new PluginConfigImpl();
        for (Map.Entry<String, String> e : config.getProperties().entrySet()) {
            pcfg.putProperty(e.getKey(), e.getValue());
        }
        pcfg.putProperty("pluginClass", config.getPluginClassName());
        return pcfg;
    }

    private void copyRulesetsAndXOMPersistenceConfig(XUConfig xuConfig, IlrXUConfigImpl factoryXUConfig) throws XUException {
        PersistenceConfig xuPersistenceConfig = xuConfig.getPersistenceConfig();
        IlrPersistenceConfigImpl factoryPersistenceConfig = factoryXUConfig.getPersistenceConfig();
        IlrPersistenceType persistenceType = factoryPersistenceConfig.getPersistenceType();
        String stype = persistenceType == null ? factoryPersistenceConfig.getCustomPersistenceType() : persistenceType.getName();
        xuPersistenceConfig.setType(stype);
        this.putPersistenceProperties(xuPersistenceConfig, factoryPersistenceConfig.getFilePersistenceConfig());
        this.putPersistenceProperties(xuPersistenceConfig, factoryPersistenceConfig.getJDBCPersistenceConfig());
        this.putPersistenceProperties(xuPersistenceConfig, factoryPersistenceConfig.getDatasourcePersistenceConfig());
        IlrXOMPersistenceConfigImpl factoryXOMPersistenceConfig = factoryXUConfig.getManagedXOMPersistenceConfig();
        persistenceType = factoryXOMPersistenceConfig.getPersistenceType();
        if (persistenceType != null) {
            xuPersistenceConfig.putProperty("XOM_PERSISTENCE_TYPE", persistenceType.getName());
        }
        this.putPersistenceProperties(xuPersistenceConfig, factoryXOMPersistenceConfig.getFilePersistenceConfig());
        this.putPersistenceProperties(xuPersistenceConfig, factoryXOMPersistenceConfig.getJDBCPersistenceConfig());
        this.putPersistenceProperties(xuPersistenceConfig, factoryXOMPersistenceConfig.getDatasourcePersistenceConfig());
    }

    private void putPersistenceProperties(PersistenceConfig xuPersistenceConfig, IlrPropertyMapConfig persistenceConfig) throws XUException {
        for (Map.Entry<String, String> entry : persistenceConfig.getProperties().entrySet()) {
            xuPersistenceConfig.putProperty(entry.getKey(), entry.getValue());
        }
    }

    private static void copyPoolConfig(PoolConfig toPoolConfig, IlrPoolConfig fromPoolConfig) throws XUException {
        if (fromPoolConfig instanceof IlrPropertyMapConfig) {
            IlrPropertyMapConfig props = (IlrPropertyMapConfig)((Object)fromPoolConfig);
            toPoolConfig.setProperties(props.getProperties());
        } else {
            toPoolConfig.setMaxSize(fromPoolConfig.getMaxSize());
            toPoolConfig.setWaitTimeout(fromPoolConfig.getWaitTimeout());
        }
    }

    private void applyRulesetUsageMonitorEnabled(XUConfig xuConfig, IlrXUConfigImpl factoryXUConfig) throws XUException {
        boolean rulesetUsageMonitorEnabled = factoryXUConfig.isRulesetUsageMonitorEnabled();
        xuConfig.setRulesetUsageMonitorEnabled(rulesetUsageMonitorEnabled);
    }

    public PrintWriter getOutput() {
        return this.output;
    }

    public void setOutput(PrintWriter output) {
        this.output = output;
        RESLogger log = RESLogger.getRESLogger("com.ibm.rules.res.execution", "ilog.rules.res.session.messages");
        log.warning(IlrSessionLocalization.WARNING_SET_OUTPUT_DEPRECATED, null, null);
    }

    @Override
    protected synchronized XUClient getXUClient() throws IlrSessionCreationException {
        if (this.xuClient == null) {
            try {
                this.xuClient = this.createXUClient();
            }
            catch (XUException e) {
                throw new IlrSessionCreationException(e);
            }
        }
        return this.xuClient;
    }

    public synchronized void release() throws IllegalStateException {
        if (this.xuClient == null) {
            return;
        }
        try {
            this.xuClient.stopXU();
        }
        catch (XUException e) {
            throw new IllegalStateException(e);
        }
        this.xuClient = null;
    }
}

