/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.session.config;

import ilog.rules.res.session.internal.IlrIllegalPersistenceTypeException;
import ilog.rules.res.session.util.IlrSessionLocalization;

public enum IlrPersistenceType {
    FILE("file"),
    JDBC("jdbc"),
    DATASOURCE("datasource");

    private final String name;

    private IlrPersistenceType(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public static IlrPersistenceType parse(String name) {
        for (IlrPersistenceType value : IlrPersistenceType.values()) {
            if (!value.getName().equals(name)) continue;
            return value;
        }
        throw new IlrIllegalPersistenceTypeException("ilog.rules.res.session.messages", IlrSessionLocalization.PERSISTENCE_TYPE_NOT_VALID_ERROR, new String[]{String.valueOf(name)});
    }
}

