/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.session.extension;

import com.ibm.rules.res.xu.client.internal.OperationParameter;
import com.ibm.rules.res.xu.client.internal.XUClient;
import com.ibm.rules.res.xu.client.internal.XURuleEngineSession;
import com.ibm.rules.res.xu.client.internal.XUWarning;
import com.ibm.rules.res.xu.client.internal.XUWarningListener;
import com.ibm.rules.res.xu.client.internal.jca.XUInteractionSpec;
import com.ibm.rules.res.xu.internal.XUException;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.session.IlrSessionException;
import java.io.Serializable;
import java.util.List;
import javax.resource.cci.Record;

class IlrXUOperations {
    IlrXUOperations() {
    }

    public static boolean execute(XUClient xuClient, ClassLoader cl, String path, Serializable userData, XUInteractionSpec spec, Record input, Record output, List<XUWarning> warningsCollector) throws IlrSessionException {
        XURuleEngineSession xuSession = IlrXUOperations.createXUSession(xuClient, cl, path, userData);
        IlrXUOperations.addWarningsListener(xuSession, warningsCollector);
        try {
            boolean bl = xuSession.executeOperation(spec, (OperationParameter)input, (OperationParameter)output);
            return bl;
        }
        catch (XUException e) {
            throw new IlrSessionException(e);
        }
        finally {
            IlrXUOperations.closeXUSession(xuSession);
        }
    }

    private static XURuleEngineSession createXUSession(XUClient xuClient, ClassLoader cl, String path, Serializable userData) throws IlrSessionException {
        XURuleEngineSession xuSession;
        try {
            xuSession = xuClient.createRuleEngineSession(IlrPath.parsePath(path), cl, null, userData, "8.7.1.0");
        }
        catch (Exception e) {
            throw new IlrSessionException(e);
        }
        return xuSession;
    }

    private static void addWarningsListener(XURuleEngineSession xuSession, final List<XUWarning> warningsCollector) {
        xuSession.addXUWarningListener(new XUWarningListener(){

            @Override
            public void xuWarningRaised(XUWarning warning) {
                warningsCollector.add(warning);
            }
        });
    }

    private static void closeXUSession(XURuleEngineSession engineSession) throws IlrSessionException {
        if (engineSession != null) {
            try {
                engineSession.close();
            }
            catch (XUException e) {
                throw new IlrSessionException(e);
            }
        }
    }
}

