/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.session.impl;

import com.ibm.rules.res.xu.client.internal.RulesetExecutionListener;
import com.ibm.rules.res.xu.client.internal.XURuleEngineSession;
import com.ibm.rules.res.xu.internal.XUException;
import ilog.rules.res.session.IlrSessionException;
import ilog.rules.res.session.async.IlrAsyncExecutionEndedEvent;
import ilog.rules.res.session.async.IlrAsyncExecutionFailedEvent;
import ilog.rules.res.session.async.IlrAsyncExecutionObserver;
import ilog.rules.res.session.impl.IlrSessionResponseImpl;
import java.util.Map;

class IlrInternalAsyncRulesetExecutionListener
implements RulesetExecutionListener {
    protected XURuleEngineSession cciClient;
    private final IlrAsyncExecutionObserver observer;

    IlrInternalAsyncRulesetExecutionListener(IlrAsyncExecutionObserver observer, XURuleEngineSession client) {
        this.observer = observer;
        this.cciClient = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executionEnded(Map<String, Object> parameters) {
        try {
            IlrSessionResponseImpl response = new IlrSessionResponseImpl();
            response.getOutputParameters().putAll(parameters);
            IlrAsyncExecutionEndedEvent evt = new IlrAsyncExecutionEndedEvent(response);
            this.observer.update(evt);
        }
        finally {
            if (this.cciClient != null) {
                try {
                    this.cciClient.close();
                }
                catch (XUException xUException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executionFailed(XUException e) {
        try {
            IlrSessionException se = new IlrSessionException(e);
            IlrAsyncExecutionFailedEvent evt = new IlrAsyncExecutionFailedEvent(se);
            this.observer.update(evt);
        }
        finally {
            if (this.cciClient != null) {
                try {
                    this.cciClient.close();
                }
                catch (XUException xUException) {}
            }
        }
    }
}

