/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.session.impl;

import ilog.rules.res.model.IlrPath;
import ilog.rules.res.session.IlrSessionRequest;
import ilog.rules.res.session.IlrTraceFilter;
import ilog.rules.res.session.impl.IlrTraceFilterImpl;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public final class IlrSessionRequestImpl
implements IlrSessionRequest {
    private static final long serialVersionUID = 1L;
    protected IlrPath rulesetPath;
    protected Map<String, Object> parameters;
    protected Serializable userData;
    protected boolean bomAccess;
    protected String taskName;
    protected boolean traceEnabled;
    protected IlrTraceFilter traceFilter;
    protected boolean interceptorEnabled;
    protected String executionId;
    protected boolean forceUptodate;

    IlrSessionRequestImpl(IlrPath rulesetPath, boolean interceptorEnabled, boolean traceEnabled, IlrTraceFilter traceFilter, Serializable userData, boolean forceUptodate, Map<String, Object> parameters, String taskName, boolean bomAccess, String executionId) {
        this.rulesetPath = rulesetPath;
        this.interceptorEnabled = interceptorEnabled;
        this.traceEnabled = traceEnabled;
        this.traceFilter = traceFilter;
        this.userData = userData;
        this.forceUptodate = forceUptodate;
        this.parameters = parameters;
        this.taskName = taskName;
        this.bomAccess = bomAccess;
        this.executionId = executionId;
    }

    public IlrSessionRequestImpl() {
        this.parameters = new HashMap<String, Object>();
        this.bomAccess = false;
        this.traceFilter = new IlrTraceFilterImpl();
        this.interceptorEnabled = false;
        this.forceUptodate = false;
    }

    public IlrSessionRequestImpl(IlrSessionRequestImpl request) {
        this.bomAccess = request.bomAccess;
        this.executionId = request.executionId;
        this.forceUptodate = request.forceUptodate;
        this.interceptorEnabled = request.interceptorEnabled;
        this.parameters = new HashMap<String, Object>(request.parameters);
        this.rulesetPath = request.rulesetPath;
        this.taskName = request.taskName;
        this.traceEnabled = request.traceEnabled;
        IlrTraceFilterImpl traceFilterCopy = new IlrTraceFilterImpl();
        traceFilterCopy.loadFromProperties(request.traceFilter.toMap());
        this.traceFilter = traceFilterCopy;
        this.userData = request.userData;
    }

    @Override
    public void setRulesetPath(IlrPath rulesetPath) {
        this.rulesetPath = rulesetPath;
    }

    @Override
    public IlrPath getRulesetPath() {
        return this.rulesetPath;
    }

    @Override
    public void setInputParameter(String name, Object value) {
        this.parameters.put(name, value);
    }

    @Override
    public Object getInputParameter(String name) {
        return this.parameters.get(name);
    }

    @Override
    public Map<String, Object> getInputParameters() {
        return this.parameters;
    }

    @Override
    public void setUserData(Serializable userData) {
        this.userData = userData;
    }

    @Override
    public Serializable getUserData() {
        return this.userData;
    }

    @Override
    public boolean isBOMAccess() {
        return this.bomAccess;
    }

    @Override
    public void setBOMAccess(boolean bomAccess) {
        this.bomAccess = bomAccess;
    }

    @Override
    public String getTaskName() {
        return this.taskName;
    }

    @Override
    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    @Override
    public void setTraceEnabled(boolean traceEnabled) {
        this.traceEnabled = traceEnabled;
    }

    @Override
    public IlrTraceFilter getTraceFilter() {
        return this.traceFilter;
    }

    @Override
    public void setInputParameters(Map<String, Object> inputParameters) {
        this.parameters = inputParameters;
    }

    @Override
    public boolean isInterceptorEnabled() {
        return this.interceptorEnabled;
    }

    @Override
    public void setInterceptorEnabled(boolean interceptorEnabled) {
        this.interceptorEnabled = interceptorEnabled;
    }

    @Override
    public void removeInputParameter(String name) {
        this.parameters.remove(name);
    }

    public void setTraceFilter(IlrTraceFilter traceFilter) {
        this.traceFilter = traceFilter;
    }

    @Override
    public boolean isForceUptodate() {
        return this.forceUptodate;
    }

    @Override
    public void setForceUptodate(boolean forceUptodate) {
        this.forceUptodate = forceUptodate;
    }

    @Override
    public String getExecutionId() {
        return this.executionId;
    }

    @Override
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }
}

