/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.session.impl;

import ilog.rules.res.session.IlrTraceFilter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public abstract class IlrTraceFilterBase
implements IlrTraceFilter,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final int M_INFO_TOTAL_RULES_FIRED = 1;
    protected static final int M_INFO_TOTAL_TASKS_EXECUTED = 2;
    protected static final int M_INFO_TOTAL_RULES_NOT_FIRED = 4;
    protected static final int M_INFO_TOTAL_TASKS_NOT_EXECUTED = 8;
    protected static final int M_INFO_RULES_NOT_FIRED = 16;
    protected static final int M_INFO_TASKS_NOT_EXECUTED = 32;
    protected static final int M_INFO_EXECUTION_DATE = 64;
    protected static final int M_INFO_EXECUTION_DURATION = 128;
    protected static final int M_INFO_RULES = 256;
    protected static final int M_INFO_TASKS = 512;
    protected static final int M_INFO_EXECUTION_EVENTS = 1024;
    protected static final int M_INFO_WORKING_MEMORY = 2048;
    protected static final int M_INFO_SYSTEM_PROPERTIES = 4096;
    protected static final int M_INFO_BOUND_OBJECT_BY_RULES = 8192;
    protected static final int M_INFO_INET_ADDRESS = 16384;
    protected static final int M_ALL = Short.MAX_VALUE;
    protected String wmFilter;
    protected int filters;

    @Override
    public final void setInfoTotalRulesFired(Boolean enabled) {
        this.filters = enabled.booleanValue() ? (this.filters |= 1) : (this.filters &= 0xFFFFFFFE);
    }

    @Override
    public final void setInfoTotalTasksExecuted(Boolean enabled) {
        this.filters = enabled.booleanValue() ? (this.filters |= 2) : (this.filters &= 0xFFFFFFFD);
    }

    @Override
    public final void setInfoTotalRulesNotFired(Boolean enabled) {
        this.filters = enabled.booleanValue() ? (this.filters |= 4) : (this.filters &= 0xFFFFFFFB);
    }

    @Override
    public final void setInfoTotalTasksNotExecuted(Boolean enabled) {
        this.filters = enabled.booleanValue() ? (this.filters |= 8) : (this.filters &= 0xFFFFFFF7);
    }

    @Override
    public final void setInfoRulesNotFired(Boolean enabled) {
        this.filters = enabled.booleanValue() ? (this.filters |= 0x10) : (this.filters &= 0xFFFFFFEF);
    }

    @Override
    public final void setInfoTasksNotExecuted(Boolean enabled) {
        this.filters = enabled.booleanValue() ? (this.filters |= 0x20) : (this.filters &= 0xFFFFFFDF);
    }

    @Override
    public final void setInfoExecutionDate(Boolean enabled) {
        this.filters = enabled.booleanValue() ? (this.filters |= 0x40) : (this.filters &= 0xFFFFFFBF);
    }

    @Override
    public final void setInfoExecutionDuration(Boolean enabled) {
        this.filters = enabled.booleanValue() ? (this.filters |= 0x80) : (this.filters &= 0xFFFFFF7F);
    }

    @Override
    public final void setInfoRules(Boolean enabled) {
        this.filters = enabled.booleanValue() ? (this.filters |= 0x100) : (this.filters &= 0xFFFFFEFF);
    }

    @Override
    public final void setInfoTasks(Boolean enabled) {
        this.filters = enabled.booleanValue() ? (this.filters |= 0x200) : (this.filters &= 0xFFFFFDFF);
    }

    @Override
    public final Boolean isInfoRules() {
        return (this.filters & 0x100) > 0;
    }

    @Override
    public final Boolean isInfoRulesNotFired() {
        return (this.filters & 0x10) > 0;
    }

    @Override
    public final Boolean isInfoTasksNotExecuted() {
        return (this.filters & 0x20) > 0;
    }

    @Override
    public final Boolean isInfoExecutionDate() {
        return (this.filters & 0x40) > 0;
    }

    @Override
    public final Boolean isInfoExecutionDuration() {
        return (this.filters & 0x80) > 0;
    }

    @Override
    public final Boolean isInfoTotalRulesFired() {
        return (this.filters & 1) > 0;
    }

    @Override
    public final Boolean isInfoTotalTasksExecuted() {
        return (this.filters & 2) > 0;
    }

    @Override
    public final Boolean isInfoTotalRulesNotFired() {
        return (this.filters & 4) > 0;
    }

    @Override
    public final Boolean isInfoTasks() {
        return (this.filters & 0x200) > 0;
    }

    @Override
    public final Boolean isInfoTotalTasksNotExecuted() {
        return (this.filters & 8) > 0;
    }

    @Override
    public void setInfoAllFilters(Boolean enabled) {
        this.filters = enabled.booleanValue() ? (this.filters |= Short.MAX_VALUE) : (this.filters &= Short.MIN_VALUE);
    }

    @Override
    public final void setInfoExecutionEvents(Boolean enabled) {
        this.filters = enabled.booleanValue() ? (this.filters |= 0x400) : (this.filters &= 0xFFFFFBFF);
    }

    @Override
    public final void setInfoWorkingMemory(Boolean enabled) {
        this.filters = enabled.booleanValue() ? (this.filters |= 0x800) : (this.filters &= 0xFFFFF7FF);
    }

    @Override
    public final void setInfoSystemProperties(Boolean enabled) {
        this.filters = enabled.booleanValue() ? (this.filters |= 0x1000) : (this.filters &= 0xFFFFEFFF);
    }

    @Override
    public final void setInfoBoundObjectByRule(Boolean enabled) {
        this.filters = enabled.booleanValue() ? (this.filters |= 0x2000) : (this.filters &= 0xFFFFDFFF);
    }

    @Override
    public final Boolean isInfoExecutionEvents() {
        return (this.filters & 0x400) > 0;
    }

    @Override
    public final Boolean isInfoWorkingMemory() {
        return (this.filters & 0x800) > 0;
    }

    @Override
    public final Boolean isInfoSystemProperties() {
        return (this.filters & 0x1000) > 0;
    }

    @Override
    public final Boolean isInfoBoundObjectByRule() {
        return (this.filters & 0x2000) > 0;
    }

    @Override
    public final Boolean isInfoInetAddress() {
        return (this.filters & 0x4000) > 0;
    }

    @Override
    public void setInfoInetAddress(Boolean enabled) {
        this.filters = enabled.booleanValue() ? (this.filters |= 0x4000) : (this.filters &= 0xFFFFBFFF);
    }

    @Override
    public final void setWorkingMemoryFilter(String wmFilter) {
        this.wmFilter = wmFilter;
    }

    @Override
    public final String getWorkingMemoryFilter() {
        return this.wmFilter;
    }

    @Override
    public final void loadFromProperties(Map<String, String> properties) {
        if (properties == null) {
            return;
        }
        for (Map.Entry<String, String> e : properties.entrySet()) {
            this.setFilter(e.getKey(), e.getValue());
        }
    }

    @Override
    public Map<String, String> toMap() {
        String t = Boolean.TRUE.toString();
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.wmFilter != null) {
            result.put("WORKING_MEMORY_FILTER", this.wmFilter);
        }
        if (this.isInfoTotalRulesFired().booleanValue()) {
            result.put("INFO_TOTAL_RULES_FIRED", t);
        }
        if (this.isInfoTotalTasksExecuted().booleanValue()) {
            result.put("INFO_TOTAL_TASKS_EXECUTED", t);
        }
        if (this.isInfoTotalRulesNotFired().booleanValue()) {
            result.put("INFO_TOTAL_RULES_NOT_FIRED", t);
        }
        if (this.isInfoTotalTasksNotExecuted().booleanValue()) {
            result.put("INFO_TOTAL_TASKS_NOT_EXECUTED", t);
        }
        if (this.isInfoRulesNotFired().booleanValue()) {
            result.put("INFO_RULES_NOT_FIRED", t);
        }
        if (this.isInfoTasksNotExecuted().booleanValue()) {
            result.put("INFO_TASKS_NOT_EXECUTED", t);
        }
        if (this.isInfoExecutionDate().booleanValue()) {
            result.put("INFO_EXECUTION_DATE", t);
        }
        if (this.isInfoExecutionDuration().booleanValue()) {
            result.put("INFO_EXECUTION_DURATION", t);
        }
        if (this.isInfoRules().booleanValue()) {
            result.put("INFO_RULES", t);
        }
        if (this.isInfoTasks().booleanValue()) {
            result.put("INFO_TASKS", t);
        }
        if (this.isInfoExecutionEvents().booleanValue()) {
            result.put("INFO_EXECUTION_EVENTS", t);
        }
        if (this.isInfoWorkingMemory().booleanValue()) {
            result.put("INFO_WORKING_MEMORY", t);
        }
        if (this.isInfoSystemProperties().booleanValue()) {
            result.put("INFO_SYSTEM_PROPERTIES", t);
        }
        if (this.isInfoBoundObjectByRule().booleanValue()) {
            result.put("INFO_BOUND_OBJECT_BY_RULE", t);
        }
        if (this.isInfoInetAddress().booleanValue()) {
            result.put("INFO_INET_ADDRESS", t);
        }
        return result;
    }

    protected int to_mask(String name) {
        if (name.equals("INFO_TOTAL_RULES_FIRED")) {
            return 1;
        }
        if (name.equals("INFO_TOTAL_TASKS_EXECUTED")) {
            return 2;
        }
        if (name.equals("INFO_TOTAL_RULES_NOT_FIRED")) {
            return 4;
        }
        if (name.equals("INFO_TOTAL_TASKS_NOT_EXECUTED")) {
            return 8;
        }
        if (name.equals("INFO_RULES_NOT_FIRED")) {
            return 16;
        }
        if (name.equals("INFO_TASKS_NOT_EXECUTED")) {
            return 32;
        }
        if (name.equals("INFO_EXECUTION_DATE")) {
            return 64;
        }
        if (name.equals("INFO_EXECUTION_DURATION")) {
            return 128;
        }
        if (name.equals("INFO_RULES")) {
            return 256;
        }
        if (name.equals("INFO_TASKS")) {
            return 512;
        }
        if (name.equals("INFO_EXECUTION_EVENTS")) {
            return 1024;
        }
        if (name.equals("INFO_WORKING_MEMORY")) {
            return 2048;
        }
        if (name.equals("INFO_SYSTEM_PROPERTIES")) {
            return 4096;
        }
        if (name.equals("INFO_BOUND_OBJECT_BY_RULE")) {
            return 8192;
        }
        if (name.equals("INFO_INET_ADDRESS")) {
            return 16384;
        }
        return 0;
    }

    @Override
    public final void setFilter(String k, String v) {
        if (k.equals("WORKING_MEMORY_FILTER")) {
            this.setWorkingMemoryFilter(v);
            return;
        }
        int m = this.to_mask(k);
        if (m > 0) {
            this.filters = Boolean.valueOf(v).booleanValue() ? (this.filters |= m) : (this.filters &= ~m);
        }
    }

    public final void setFilters(IlrTraceFilterBase filter) {
        this.filters |= filter.filters;
    }
}

