/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.session.impl.j2se;

import com.ibm.rules.res.persistence.internal.PersistencePropertiesConverter;
import com.ibm.rules.res.xu.client.internal.XUClient;
import com.ibm.rules.res.xu.client.internal.XUManagementSession;
import com.ibm.rules.res.xu.internal.XUException;
import com.ibm.rules.util.ffdc.FFDCLogger;
import ilog.rules.res.model.IlrMutableRepository;
import ilog.rules.res.model.IlrRepositoryFactory;
import ilog.rules.res.model.internal.IlrRepositoryFactoryImpl;
import ilog.rules.res.persistence.IlrRepositoryDAO;
import ilog.rules.res.session.IlrSessionException;
import ilog.rules.res.session.impl.IlrManagementSessionBase;
import ilog.rules.res.session.util.IlrPersistenceFactory;
import java.util.Map;

public class IlrManagementSessionJ2SE
extends IlrManagementSessionBase {
    private static final String CREATE_REPO_DAO_FAILURE_ID = "50";
    private IlrRepositoryDAO repositoryDAO;

    @Override
    public IlrRepositoryFactory getRepositoryFactory() throws IlrSessionException {
        if (this.repositoryDAO == null) {
            XUManagementSession mgtSession = null;
            Map<String, String> props = null;
            try {
                mgtSession = this.createManagementSession();
                IlrPersistenceFactory persistenceFactory = new IlrPersistenceFactory();
                props = persistenceFactory.getPersistenceProperties(mgtSession);
                this.repositoryDAO = persistenceFactory.createRepositoryDAO(props);
            }
            catch (Throwable e) {
                String strProps = props == null ? "" : String.valueOf(PersistencePropertiesConverter.obfuscate(props));
                FFDCLogger.log(e, this, this.getClass().getName(), CREATE_REPO_DAO_FAILURE_ID, "persistenceProperties=" + strProps);
                throw new IlrSessionException(e);
            }
            finally {
                if (mgtSession != null) {
                    try {
                        mgtSession.close();
                    }
                    catch (XUException e) {
                        throw new IlrSessionException(e);
                    }
                }
            }
        }
        return new IlrRepositoryFactoryImpl(){
            private static final long serialVersionUID = 1L;

            @Override
            public IlrMutableRepository createRepository() {
                return this.createRepository(IlrManagementSessionJ2SE.this.repositoryDAO);
            }
        };
    }

    public IlrManagementSessionJ2SE(XUClient xuClient, ClassLoader classLoader) {
        super(xuClient, classLoader);
    }
}

