/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.session.impl.trace;

import ilog.rules.res.session.IlrTraceFilter;
import ilog.rules.res.session.ruleset.IlrTaskInformation;
import ilog.rules.res.session.ruleset.impl.IlrExecutionTraceImpl;
import ilog.rules.res.xu.cci.ruleset.IlrRulesetExecutionTrace;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class IlrXUExecutionTraceConverter {
    public static IlrExecutionTraceImpl convertXUSessionTrace(IlrRulesetExecutionTrace xuTrace, IlrTraceFilter filter) {
        IlrExecutionTraceImpl rsTrace = new IlrExecutionTraceImpl();
        if (filter.isInfoInetAddress().booleanValue()) {
            rsTrace.setInetAddress(xuTrace.getInetAddress());
        }
        if (filter.isInfoSystemProperties().booleanValue() && xuTrace.getSystemProperties() != null) {
            rsTrace.setSystemProperties(xuTrace.getSystemProperties());
        }
        if (filter.isInfoRulesNotFired().booleanValue()) {
            rsTrace.setRulesNotFired(xuTrace.getRulesNotFired());
        }
        if (filter.isInfoTasksNotExecuted().booleanValue()) {
            IlrXUExecutionTraceConverter.initTasksNotExecuted(rsTrace, xuTrace);
        }
        if (filter.isInfoTotalRulesFired().booleanValue()) {
            rsTrace.setTotalRulesFired(xuTrace.getTotalRulesFired());
        }
        if (filter.isInfoTotalRulesNotFired().booleanValue()) {
            rsTrace.setTotalRulesNotFired(xuTrace.getTotalRulesNotFired());
        }
        if (filter.isInfoTotalTasksExecuted().booleanValue()) {
            rsTrace.setTotalTasksExecuted(xuTrace.getTotalTasksExecuted());
        }
        if (filter.isInfoTotalTasksNotExecuted().booleanValue()) {
            rsTrace.setTotalTasksNotExecuted(xuTrace.getTotalTasksNotExecuted());
        }
        if (filter.isInfoWorkingMemory().booleanValue()) {
            rsTrace.setWorkingMemory(xuTrace.getWorkingMemory());
        }
        if (filter.isInfoRules().booleanValue()) {
            rsTrace.setRules(xuTrace.getRules());
        }
        if (filter.isInfoTasks().booleanValue()) {
            rsTrace.setTasks(xuTrace.getTasks());
        }
        if (filter.isInfoExecutionEvents().booleanValue()) {
            rsTrace.setExecutionEvents(xuTrace.getExecutionEvents());
        }
        return rsTrace;
    }

    private static void initTasksNotExecuted(IlrExecutionTraceImpl rsTrace, IlrRulesetExecutionTrace xuTrace) {
        HashSet<IlrTaskInformation> information = new HashSet<IlrTaskInformation>();
        Map<String, IlrTaskInformation> taskInformations = xuTrace.getTaskInformations();
        Set<String> tasksNotExecuted = xuTrace.getTasksNotExecuted();
        for (String taskName : tasksNotExecuted) {
            information.add(taskInformations.get(taskName));
        }
        rsTrace.setTasksNotExecuted(information);
    }
}

