/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.session.interceptor;

import ilog.rules.res.model.IlrMutableRuleAppInformation;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.model.IlrRepositoryFactory;
import ilog.rules.res.model.IlrRuleAppInformation;
import ilog.rules.res.session.IlrManagementSession;
import ilog.rules.res.session.IlrSession;
import ilog.rules.res.session.IlrSessionFactory;
import ilog.rules.res.session.IlrSessionRequest;
import ilog.rules.res.session.IlrSessionResponse;

public class IlrInterceptorContext {
    private IlrSessionRequest request;
    private IlrSessionResponse response;
    private IlrSession session;
    private IlrSessionFactory sessionFactory;
    private IlrRuleAppInformation ruleAppInformation;
    private final IlrPath initialRsPath;

    public IlrInterceptorContext(IlrPath initialRsPath) {
        this.initialRsPath = initialRsPath;
    }

    public IlrSessionRequest getRequest() {
        return this.request;
    }

    public void setRequest(IlrSessionRequest request) {
        this.request = request;
    }

    public IlrSessionResponse getResponse() {
        return this.response;
    }

    public void setResponse(IlrSessionResponse response) {
        this.response = response;
    }

    public IlrSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(IlrSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public IlrRuleAppInformation getRuleAppInformation() {
        if (this.ruleAppInformation == null) {
            try {
                IlrPath path = this.initialRsPath;
                IlrManagementSession managementSession = this.sessionFactory.createManagementSession();
                IlrRepositoryFactory repositoryFactory = managementSession.getRepositoryFactory();
                IlrMutableRuleAppInformation mutableRuleAppInfo = path.getRuleAppVersion() == null ? (IlrMutableRuleAppInformation)repositoryFactory.createRepository().getGreatestRuleApp(path.getRuleAppName()) : (IlrMutableRuleAppInformation)repositoryFactory.createRepository().getRuleApp(path.getRuleAppName(), path.getRuleAppVersion());
                this.ruleAppInformation = repositoryFactory.unmodifiableRuleApp(mutableRuleAppInfo);
            }
            catch (Exception e) {
                this.ruleAppInformation = null;
            }
        }
        return this.ruleAppInformation;
    }

    public void setRuleAppInformation(IlrRuleAppInformation ruleAppInformation) {
        this.ruleAppInformation = ruleAppInformation;
    }

    public IlrSession getSession() {
        return this.session;
    }

    public void setSession(IlrSession session) {
        this.session = session;
    }
}

