/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.session.util;

import ilog.rules.res.model.IlrPath;
import ilog.rules.res.model.IlrRuleAppInformation;
import ilog.rules.res.session.IlrSessionFactory;
import ilog.rules.res.session.IlrSessionResponse;
import ilog.rules.res.session.IlrStatefulSession;
import ilog.rules.res.session.impl.IlrSessionResponseImpl;
import ilog.rules.res.session.interceptor.IlrInterceptorContext;
import ilog.rules.res.session.interceptor.IlrSessionInterceptor;
import ilog.rules.res.session.interceptor.IlrSessionInterceptorException;
import ilog.rules.res.session.util.IlrSessionLocalization;
import ilog.rules.res.util.classloader.IlrClassLoader;
import ilog.rules.res.util.classloader.IlrClassLoaderUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class IlrInterceptorHelper {
    private IlrInterceptorContext context;
    private List<IlrSessionInterceptor> interceptorChain;
    private IlrPath executedRulesetPath = null;

    public void initialize(IlrPath rsPath, IlrStatefulSession session, IlrSessionFactory sessionFactory) throws IlrSessionInterceptorException {
        this.context = new IlrInterceptorContext(rsPath);
        this.context.setSession(session);
        this.context.setSessionFactory(sessionFactory);
        this.initChain(rsPath);
    }

    private void initChain(IlrPath rsPath) throws IlrSessionInterceptorException {
        this.interceptorChain = new ArrayList<IlrSessionInterceptor>();
        IlrRuleAppInformation ruleAppInfo = this.context.getRuleAppInformation();
        if (ruleAppInfo == null) {
            throw new IlrSessionInterceptorException(IlrSessionLocalization.SESSION_INTERCEPTOR_RULEAPP_NOT_FOUND, new String[]{rsPath.toString()});
        }
        String interceptorClassProperty = ruleAppInfo.getProperties().getInterceptorClassName();
        String[] classNames = null;
        if (interceptorClassProperty != null) {
            classNames = interceptorClassProperty.split("[,;]");
        }
        if (classNames != null) {
            for (String line : classNames) {
                if (line.equals("") || line.startsWith("#")) continue;
                String interceptorClassName = line;
                ClassLoader classLoader = IlrClassLoaderUtil.getThreadClassLoader();
                Class<?> clazz = IlrClassLoaderUtil.loadClassNoException(interceptorClassName, classLoader);
                if (clazz == null) {
                    byte[] xomBytes = ruleAppInfo.getXOM();
                    ClassLoader xomClassLoader = null;
                    if (xomBytes != null && xomBytes.length > 0) {
                        try {
                            xomClassLoader = new IlrClassLoader(classLoader, xomBytes);
                        }
                        catch (IOException e) {
                            throw new IlrSessionInterceptorException(e);
                        }
                    }
                    if (xomClassLoader != null) {
                        try {
                            clazz = xomClassLoader.loadClass(interceptorClassName);
                        }
                        catch (ClassNotFoundException e) {
                            throw new IlrSessionInterceptorException(e);
                        }
                    }
                }
                if (clazz == null) {
                    throw new IlrSessionInterceptorException(IlrSessionLocalization.SESSION_INTERCEPTOR_CLASS_NOT_FOUND, new String[]{interceptorClassName});
                }
                try {
                    Object o = clazz.newInstance();
                    IlrSessionInterceptor interceptor = (IlrSessionInterceptor)o;
                    this.interceptorChain.add(interceptor);
                }
                catch (Exception e) {
                    throw new IlrSessionInterceptorException(e);
                }
            }
        }
    }

    public void invokeBeforeInterceptors() throws IlrSessionInterceptorException {
        for (IlrSessionInterceptor interceptor : this.interceptorChain) {
            interceptor.beforeExecute(this.context);
        }
    }

    public IlrSessionResponse invokeAfterInterceptors(IlrSessionResponse response) throws IlrSessionInterceptorException {
        this.context.setResponse(response);
        ArrayList<IlrSessionInterceptor> reversedChain = new ArrayList<IlrSessionInterceptor>(this.interceptorChain);
        Collections.reverse(reversedChain);
        StringBuffer interceptorClassNames = new StringBuffer();
        Iterator<IlrSessionInterceptor> iterator = reversedChain.iterator();
        while (iterator.hasNext()) {
            IlrSessionInterceptor interceptor = (IlrSessionInterceptor)iterator.next();
            interceptor.afterExecute(this.context);
            this.appendInterceptorClassName(interceptorClassNames, iterator, interceptor);
        }
        IlrSessionResponse responseFromContext = this.setInterceptorClassNamesInResponse(interceptorClassNames);
        return responseFromContext;
    }

    private IlrSessionResponse setInterceptorClassNamesInResponse(StringBuffer interceptorClassNames) {
        IlrSessionResponse responseFromContext = this.context.getResponse();
        if (interceptorClassNames.length() == 0) {
            return responseFromContext;
        }
        if (responseFromContext instanceof IlrSessionResponseImpl) {
            ((IlrSessionResponseImpl)responseFromContext).setInterceptorClassNameUsed(interceptorClassNames.toString());
        }
        return responseFromContext;
    }

    private void appendInterceptorClassName(StringBuffer interceptorClassNames, Iterator<IlrSessionInterceptor> iterator, IlrSessionInterceptor interceptor) {
        interceptorClassNames.append(interceptor.getClass().getCanonicalName());
        if (iterator.hasNext()) {
            interceptorClassNames.append(";");
        }
    }

    public void invokeTranformPathInterceptors(IlrPath path, Serializable userData, Map<String, Object> parameters) throws IlrSessionInterceptorException {
        IlrPath res = path;
        for (IlrSessionInterceptor interceptor : this.interceptorChain) {
            res = interceptor.transformRsPath(res, this.context.getRuleAppInformation(), userData, parameters, this.context.getSessionFactory());
        }
        this.executedRulesetPath = res;
    }

    public IlrPath getExecutedRulesetPath() {
        return this.executedRulesetPath;
    }

    public IlrInterceptorContext getContext() {
        return this.context;
    }
}

