/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.util.http;

import com.ibm.rules.res.util.internal.StreamUtil;
import ilog.rules.res.util.IlrRemoteException;
import ilog.rules.res.util.http.EasySSLProtocolSocketFactory;
import ilog.rules.res.util.http.IlrAuthenticationException;
import ilog.rules.res.util.http.IlrConnectionException;
import ilog.rules.res.util.http.IlrServiceCall;
import ilog.rules.res.util.io.IlrFileUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

public class IlrHttpClient {
    private static final String AUTHORIZATION = "Authorization";
    private static final String BASIC = "Basic ";
    private static final String UTF_8 = "UTF-8";
    private static final String COLON = ":";
    private static final String USE_BASIC_AUTHENTICATION = "com.ibm.odm.res.useBasicAuthentication";
    public static final String ACCEPT_SELF_SIGNED_CERTIFICATE = "ilog.rules.res.allowSelfSignedCertificate";
    public static final String PROXYHOST = "http.proxyHost";
    public static final String PROXYPORT = "http.proxyPort";
    public static final String CUSTOM_PROTOCOL_FACTORY = "custom.protocol.factory";
    public static final String CUSTOM_PROTOCOL_SCHEME = "custom.protocol.scheme";
    public static final String CUSTOM_PROTOCOL_DEFAULTPORT = "custom.protocol.defaultPort";
    public static final String AUTH_FOR_METHOD = "auth_for_method";
    protected static final String SECURITY_CHECK = "/j_security_check";
    protected static final String PARAM_USERNAME = "j_username";
    protected static final String PARAM_PASSWORD = "j_password";
    protected static final int DEFAULT_TIMEOUT_MS = 600000;
    protected final URL url;
    protected final HttpClient client;
    protected final HttpConnectionManager connectionManager;
    protected final HostConfiguration config;
    protected final String serviceContext;
    protected String sessionId;

    public IlrHttpClient(URL url, String serviceContext) {
        this(url, serviceContext, null, null, System.getProperty(ACCEPT_SELF_SIGNED_CERTIFICATE));
    }

    private IlrHttpClient(URL url, String serviceContext, String proxyHost, String proxyPort, String allowSelfSignedCertificate) {
        if (url.getFile().endsWith("/")) {
            try {
                url = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile().substring(0, url.getFile().length() - 1));
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        this.url = url;
        this.serviceContext = serviceContext;
        this.client = new HttpClient((HttpConnectionManager)new SimpleHttpConnectionManager());
        this.connectionManager = this.client.getHttpConnectionManager();
        this.config = this.client.getHostConfiguration();
        this.connectionManager.getParams().setConnectionTimeout(600000);
        String customProtocolFactory = System.getProperty(CUSTOM_PROTOCOL_FACTORY);
        String customProtocolScheme = System.getProperty(CUSTOM_PROTOCOL_SCHEME);
        String customProtocolDefaultPort = System.getProperty(CUSTOM_PROTOCOL_DEFAULTPORT);
        if (this.allowSelfSignedCertificate(allowSelfSignedCertificate) && url.getProtocol().equalsIgnoreCase("https")) {
            Protocol protocol = new Protocol(url.getProtocol(), (SecureProtocolSocketFactory)new EasySSLProtocolSocketFactory(allowSelfSignedCertificate), 443);
            Protocol.registerProtocol((String)url.getProtocol(), (Protocol)protocol);
        } else if (customProtocolFactory != null && customProtocolScheme != null && url.getProtocol().equalsIgnoreCase(customProtocolScheme)) {
            try {
                Class<?> clazz = Class.forName(customProtocolFactory);
                ProtocolSocketFactory protSocketFactory = (ProtocolSocketFactory)clazz.newInstance();
                int defaultPort = Integer.parseInt(customProtocolDefaultPort);
                Protocol protocol = new Protocol(url.getProtocol(), protSocketFactory, defaultPort);
                Protocol.registerProtocol((String)url.getProtocol(), (Protocol)protocol);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.config.setHost(url.getHost(), url.getPort(), url.getProtocol());
        if (proxyHost != null && proxyPort != null) {
            this.config.setProxy(proxyHost, Integer.parseInt(proxyPort));
        } else {
            Proxy proxyToUse;
            ProxySelector proxySelector = ProxySelector.getDefault();
            List<Proxy> proxies = null;
            try {
                proxies = proxySelector.select(url.toURI());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            if (proxies != null && proxies.size() > 0 && Proxy.NO_PROXY != (proxyToUse = proxies.get(0)) && proxyToUse.address() instanceof InetSocketAddress) {
                InetSocketAddress proxyAdress = (InetSocketAddress)proxyToUse.address();
                this.config.setProxy(proxyAdress.getHostName(), proxyAdress.getPort());
            }
        }
    }

    private boolean allowSelfSignedCertificate(String allowSelfSignedCertificate) {
        return Boolean.TRUE.toString().equalsIgnoreCase(allowSelfSignedCertificate) || "SSL".equalsIgnoreCase(allowSelfSignedCertificate) || "TLS".equalsIgnoreCase(allowSelfSignedCertificate);
    }

    public IlrHttpClient(URL url, String serviceContext, String proxyHost, String proxyPort, boolean allowSelfSignedCertificate) {
        this(url, serviceContext, proxyHost, proxyPort, Boolean.toString(allowSelfSignedCertificate));
    }

    public boolean doAuthenticate(String user, String password) throws IlrAuthenticationException, IlrConnectionException {
        return this.doAuthenticate(user, password, "GET", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doAuthenticate(String user, String password, String method, boolean[] forbidden) throws IlrAuthenticationException, IlrConnectionException {
        if (user == null) {
            user = "";
        }
        if (password == null) {
            password = "";
        }
        if (this.hasAccessGranted(false, method, forbidden)) {
            return false;
        }
        PostMethod authentication = new PostMethod(this.url.getFile() + SECURITY_CHECK);
        this.setBasicAuthenticationHeader((HttpMethodBase)authentication, user, password);
        authentication.addParameter(PARAM_USERNAME, user);
        authentication.addParameter(PARAM_PASSWORD, password);
        try {
            this.executeMethod((HttpMethod)authentication);
        }
        finally {
            authentication.releaseConnection();
        }
        if (!this.hasAccessGranted(true)) {
            throw new IlrAuthenticationException(user, this.url);
        }
        return true;
    }

    private void setBasicAuthenticationHeader(HttpMethodBase method, String user, String password) throws IlrConnectionException {
        if (this.useBasicAuthentication()) {
            StringBuffer tmp = new StringBuffer(user).append(COLON).append(password);
            String encoded = DatatypeConverter.printBase64Binary((byte[])this.getBytes(tmp.toString()));
            tmp = new StringBuffer(BASIC).append(encoded);
            method.setRequestHeader(AUTHORIZATION, tmp.toString());
        }
    }

    private byte[] getBytes(String string) throws IlrConnectionException {
        try {
            return string.getBytes(UTF_8);
        }
        catch (UnsupportedEncodingException exception) {
            throw new IlrConnectionException(IlrConnectionException.UTF_8_ENCODING_ERROR, null, exception);
        }
    }

    private boolean useBasicAuthentication() {
        return Boolean.getBoolean(USE_BASIC_AUTHENTICATION);
    }

    public Object invoke(IlrServiceCall call) throws Throwable {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(call);
        oos.close();
        PostMethod httpMethod = new PostMethod(this.url.getFile() + this.serviceContext);
        httpMethod.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(baos.toByteArray()));
        try {
            int httpStatus = this.executeMethod((HttpMethod)httpMethod);
            if (httpStatus == 200) {
                ObjectInputStream ois = new ObjectInputStream(httpMethod.getResponseBodyAsStream());
                Object result = ois.readObject();
                if (result instanceof IlrRemoteException) {
                    throw (IlrRemoteException)result;
                }
                Object object = result;
                return object;
            }
            throw new IlrConnectionException(IlrConnectionException.HTTP_ERROR, new String[]{String.valueOf(httpStatus), HttpStatus.getStatusText((int)httpStatus), httpMethod.getPath()});
        }
        finally {
            httpMethod.releaseConnection();
        }
    }

    public String getServiceContext() {
        return this.serviceContext;
    }

    public byte[] invoke(HttpMethod httpMethod) throws Throwable {
        try {
            int httpStatus = this.executeMethod(httpMethod);
            if (httpStatus == 200) {
                byte[] content;
                byte[] byArray = content = StreamUtil.toByteArray(httpMethod.getResponseBodyAsStream());
                return byArray;
            }
            throw new IlrConnectionException(IlrConnectionException.HTTP_ERROR, new String[]{String.valueOf(httpStatus), new String(StreamUtil.toByteArray(httpMethod.getResponseBodyAsStream())), httpMethod.getPath()});
        }
        finally {
            httpMethod.releaseConnection();
        }
    }

    public Object invokeGetString(HttpMethod httpMethod) throws Throwable {
        try {
            int httpStatus = this.executeMethod(httpMethod);
            if (httpStatus == 200 || httpStatus == 201 || httpStatus == 204 || httpStatus == 202) {
                String[] tokens;
                String content;
                Header headerContent = httpMethod.getResponseHeader("Content-Type");
                if (headerContent != null && (content = headerContent.getValue()) != null && (tokens = content.split(";"))[0].trim().equals("application/octet-stream")) {
                    byte[] byArray = StreamUtil.toByteArray(httpMethod.getResponseBodyAsStream());
                    return byArray;
                }
                String string = httpMethod.getResponseBodyAsString();
                return string;
            }
            throw new IlrConnectionException(IlrConnectionException.HTTP_ERROR, new String[]{String.valueOf(httpStatus), new String(StreamUtil.toByteArray(httpMethod.getResponseBodyAsStream())), httpMethod.getPath()});
        }
        finally {
            httpMethod.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        StringBuffer buffer = new StringBuffer(this.url.getFile());
        buffer.append(this.serviceContext);
        buffer.append('?');
        buffer.append("logout");
        buffer.append('=');
        buffer.append("logout");
        GetMethod httpMethod = new GetMethod(buffer.toString());
        try {
            this.executeMethod((HttpMethod)httpMethod);
        }
        catch (Exception e) {
        }
        finally {
            httpMethod.releaseConnection();
        }
        HttpConnection connection = this.connectionManager.getConnection(this.config);
        connection.releaseConnection();
        connection.close();
        Protocol.unregisterProtocol((String)this.url.getProtocol());
    }

    public boolean hasAccessGranted(boolean failWithStatus) throws IlrConnectionException {
        return this.hasAccessGranted(failWithStatus, "GET", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasAccessGranted(boolean failWithStatus, String method, boolean[] forbidden) throws IlrConnectionException {
        StringBuffer buffer = new StringBuffer(this.url.getFile());
        buffer.append(this.serviceContext);
        buffer.append('?');
        buffer.append("ping");
        buffer.append('=');
        buffer.append("pong");
        GetMethod httpMethod = new GetMethod(buffer.toString());
        httpMethod.addRequestHeader(AUTH_FOR_METHOD, method);
        try {
            int httpStatus = this.executeMethod((HttpMethod)httpMethod);
            if (httpStatus == 403 && forbidden != null && forbidden.length == 1) {
                forbidden[0] = true;
            }
            if (httpStatus == 200) {
                try {
                    String response = this.getResponse((HttpMethodBase)httpMethod);
                    if ("pong".equals(response)) {
                        boolean bl = true;
                        return bl;
                    }
                    String pong = "pong=";
                    if (response != null && response.startsWith(pong)) {
                        this.sessionId = response.substring(pong.length());
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                catch (IOException e) {
                    throw new IlrConnectionException(IlrConnectionException.IO_ERROR, new String[]{httpMethod.getPath()}, e);
                }
            }
            if (httpStatus == 302) {
                String location = httpMethod.getResponseHeader("Location").getValue();
                if (location != null && location.endsWith("/protected/installer.jsf")) {
                    throw new IlrConnectionException(IlrConnectionException.RES_CONSOLE_NOT_INSTALLED_ERROR, new String[0]);
                }
                boolean bl = false;
                return bl;
            }
            if (failWithStatus) {
                throw new IlrConnectionException(IlrConnectionException.HTTP_ERROR, new String[]{String.valueOf(httpStatus), HttpStatus.getStatusText((int)httpStatus), httpMethod.getPath()});
            }
            boolean bl = false;
            return bl;
        }
        finally {
            httpMethod.releaseConnection();
        }
    }

    public int executeMethod(HttpMethod httpMethod) throws IlrConnectionException {
        int httpStatus;
        HttpConnection connection = this.connectionManager.getConnection(this.config);
        if (connection != null && !connection.isOpen()) {
            try {
                connection.open();
            }
            catch (ConnectException e) {
                this.connectionManager.releaseConnection(connection);
                throw new IlrConnectionException(IlrConnectionException.PORT_ERROR, new String[]{String.valueOf(this.url.getPort())}, e);
            }
            catch (UnknownHostException e) {
                this.connectionManager.releaseConnection(connection);
                throw new IlrConnectionException("HOST_ERROR", new String[]{e.getMessage()}, e);
            }
            catch (IOException e) {
                throw new IlrConnectionException(IlrConnectionException.IO_ERROR, new String[]{this.url.toString()}, e);
            }
        }
        try {
            httpStatus = httpMethod.execute(this.client.getState(), connection);
        }
        catch (HttpException e) {
            throw new IlrConnectionException(IlrConnectionException.PROTOCOL_ERROR, new String[]{httpMethod.getPath()}, e);
        }
        catch (IOException e) {
            throw new IlrConnectionException(IlrConnectionException.IO_ERROR, new String[]{httpMethod.getPath()}, e);
        }
        if (httpStatus == 404) {
            throw new IlrConnectionException(IlrConnectionException.UNKNOW_SERVICE, new String[]{httpMethod.getPath()});
        }
        return httpStatus;
    }

    private String getResponse(HttpMethodBase httpMethod) throws IOException {
        InputStream stream = httpMethod.getResponseBodyAsStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IlrFileUtil.copy(stream, baos);
        return baos.toString(httpMethod.getResponseCharSet());
    }

    public String getSessionId() {
        return this.sessionId;
    }
}

