/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.util.xml;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IlrDOMUtil {
    public static String textNodesToString(NodeList nodes) {
        StringBuffer result = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 3) continue;
            if (result == null) {
                result = new StringBuffer();
            }
            result.append(node.getNodeValue());
        }
        return result == null ? null : result.toString();
    }

    public static NodeList getChildElementsByTagName(Element element, String tagName) {
        NodeList children = element.getChildNodes();
        NodeListImpl result = new NodeListImpl();
        for (int i = 0; i < children.getLength(); ++i) {
            Element childElement;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !(childElement = (Element)child).getTagName().equals(tagName)) continue;
            result.add(childElement);
        }
        return result;
    }

    public static Element getFirstElementByTagName(Element element, String tagName) {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element childElement;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !(childElement = (Element)child).getTagName().equals(tagName)) continue;
            return childElement;
        }
        return null;
    }

    public static Element getFirstElementByTagName(Element element, String tagName, boolean isDirectChild) {
        if (isDirectChild) {
            return IlrDOMUtil.getFirstElementByTagName(element, tagName);
        }
        NodeList children = element.getElementsByTagName(tagName);
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            return (Element)child;
        }
        return null;
    }

    protected static class NodeListImpl
    implements NodeList {
        protected List<Node> nodes = new ArrayList<Node>();

        protected NodeListImpl() {
        }

        public void add(Node node) {
            this.nodes.add(node);
        }

        @Override
        public int getLength() {
            return this.nodes.size();
        }

        @Override
        public Node item(int index) {
            return this.nodes.get(index);
        }
    }
}

