/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util;

import ilog.rules.util.IlrFileChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;

public class IlrFileMonitor {
    private Timer timer = new Timer(true);
    private Hashtable timerEntries = new Hashtable();

    public static IlrFileMonitor createInstance() {
        return new IlrFileMonitor();
    }

    protected IlrFileMonitor() {
    }

    public void removeAllListeners() {
        ArrayList tasks = new ArrayList(this.timerEntries.values());
        for (FileMonitorTask task : tasks) {
            task.cancel();
        }
        this.timerEntries.clear();
    }

    public void addFileChangeListener(IlrFileChangeListener listener, String fileName, long period) {
        this.removeFileChangeListener(listener, fileName);
        try {
            FileMonitorTask task = new FileMonitorTask(listener, fileName);
            this.timerEntries.put(fileName + listener.hashCode(), task);
            this.timer.schedule((TimerTask)task, period, period);
        }
        catch (FileNotFoundException ex) {
            // empty catch block
        }
    }

    public void removeFileChangeListener(IlrFileChangeListener listener, String fileName) {
        FileMonitorTask task = (FileMonitorTask)this.timerEntries.remove(fileName + listener.hashCode());
        if (task != null) {
            task.cancel();
        }
    }

    protected void fireFileChangeEvent(IlrFileChangeListener listener, String fileName) {
        listener.fileChanged(fileName);
    }

    protected void fireFileRemovedEvent(IlrFileChangeListener listener, String fileName) {
        listener.fileRemoved(fileName);
    }

    class FileMonitorTask
    extends TimerTask {
        IlrFileChangeListener listener;
        String fileName;
        File monitoredFile;
        boolean canWrite;
        long lastModified;

        public FileMonitorTask(IlrFileChangeListener listener, String fileName) throws FileNotFoundException {
            this.listener = listener;
            this.fileName = fileName;
            this.canWrite = true;
            this.lastModified = 0L;
            this.monitoredFile = new File(fileName);
            if (!this.monitoredFile.exists()) {
                URL fileURL = listener.getClass().getClassLoader().getResource(fileName);
                if (fileURL != null) {
                    this.monitoredFile = new File(fileURL.getFile());
                } else {
                    throw new FileNotFoundException("File Not Found: " + fileName);
                }
            }
            this.lastModified = this.monitoredFile.lastModified();
            this.canWrite = this.monitoredFile.canWrite();
        }

        @Override
        public void run() {
            URL fileURL;
            long lastModified = this.monitoredFile.lastModified();
            boolean canWrite = this.monitoredFile.canWrite();
            if (!this.monitoredFile.exists() && (fileURL = this.listener.getClass().getClassLoader().getResource(this.fileName)) == null) {
                IlrFileMonitor.this.fireFileRemovedEvent(this.listener, this.fileName);
                return;
            }
            if (lastModified != this.lastModified || canWrite != this.canWrite) {
                this.lastModified = lastModified;
                this.canWrite = canWrite;
                IlrFileMonitor.this.fireFileChangeEvent(this.listener, this.fileName);
            }
        }
    }
}

